/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServiceBinding
implements Cloneable {
    private String name = null;
    private String hostName = null;
    private int port = 0;
    private InetAddress bindAddress = null;

    public Object clone() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public ServiceBinding(String name, String hostName, int port) throws UnknownHostException {
        this.setName(name);
        this.setHostName(hostName);
        this.setBindAddress(hostName);
        this.setPort(port);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setBindAddress(String hostName) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(hostName);
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer("ServiceBinding [name=");
        String host = this.getHostName();
        if (this.hostName == null) {
            host = "<ANY>";
        }
        sBuf.append(this.getName());
        sBuf.append(";hostName=");
        sBuf.append(host);
        sBuf.append(";bindAddress=");
        sBuf.append(this.getBindAddress().toString());
        sBuf.append(";port=");
        sBuf.append(this.getPort());
        sBuf.append("]");
        return sBuf.toString();
    }
}

