/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.IdentityResourceBundle;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.PropertiesClassLoader;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleLoader;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.BaseResourceBundlePlugin;
import org.picocontainer.Startable;

public abstract class BaseResourceBundleService
implements ResourceBundleService,
Startable {
    protected Log log_;
    protected volatile List<String> classpathResources_;
    protected volatile String[] portalResourceBundleNames_;
    protected LocaleConfigService localeService_;
    protected ExoCache<String, ResourceBundle> cache_;
    private volatile List<String> initResources_;

    protected void initParams(InitParams params) {
        this.classpathResources_ = params.getValuesParam("classpath.resources").getValues();
        ArrayList prnames = params.getValuesParam("portal.resource.names").getValues();
        this.portalResourceBundleNames_ = new String[prnames.size()];
        for (int i = 0; i < prnames.size(); ++i) {
            this.portalResourceBundleNames_[i] = (String)prnames.get(i);
        }
        this.initResources_ = params.getValuesParam("init.resources").getValues();
    }

    public synchronized void addResourceBundle(BaseResourceBundlePlugin plugin) {
        List<String> initResources;
        List<String> portalResources;
        List<String> classpathResources = plugin.getClasspathResources();
        if (classpathResources != null && !classpathResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(classpathResources);
            if (this.classpathResources_ != null) {
                result.addAll(this.classpathResources_);
            }
            this.classpathResources_ = Collections.unmodifiableList(result);
        }
        if ((portalResources = plugin.getPortalResources()) != null && !portalResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(portalResources);
            if (this.portalResourceBundleNames_ != null) {
                result.addAll(Arrays.asList(this.portalResourceBundleNames_));
            }
            this.portalResourceBundleNames_ = result.toArray(new String[result.size()]);
        }
        if ((initResources = plugin.getInitResources()) != null && !initResources.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(initResources);
            if (this.initResources_ != null) {
                result.addAll(this.initResources_);
            }
            this.initResources_ = Collections.unmodifiableList(result);
        }
    }

    public void start() {
        PageList<ResourceBundleData> pl = null;
        try {
            pl = this.findResourceDescriptions(new Query(null, null));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot check if a resource already exists", e);
        }
        if (pl.getAvailable() > 0) {
            return;
        }
        List<String> initResources = this.initResources_;
        for (String resource : initResources) {
            this.initResources(resource, Thread.currentThread().getContextClassLoader());
        }
    }

    public void stop() {
    }

    public ResourceBundle getResourceBundle(String[] name, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getResourceBundle(name, locale, cl);
    }

    public ResourceBundle getResourceBundle(String name, Locale locale) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getResourceBundle(name, locale, cl);
    }

    public String[] getSharedResourceBundleNames() {
        return this.portalResourceBundleNames_;
    }

    public ResourceBundleData createResourceBundleDataInstance() {
        return new ResourceBundleData();
    }

    protected boolean isClasspathResource(String name) {
        if (this.classpathResources_ == null) {
            return false;
        }
        for (int i = 0; i < this.classpathResources_.size(); ++i) {
            String pack = this.classpathResources_.get(i);
            if (!name.startsWith(pack)) continue;
            return true;
        }
        return false;
    }

    protected void initResources(String baseName, ClassLoader cl) {
        String name = baseName.replace('.', '/');
        try {
            Collection<LocaleConfig> localeConfigs = this.localeService_.getLocalConfigs();
            String defaultLang = this.localeService_.getDefaultLocaleConfig().getLanguage();
            for (LocaleConfig localeConfig : localeConfigs) {
                String language = localeConfig.getLanguage();
                String content = this.getResourceBundleContent(name, language, defaultLang, cl);
                if (content == null) continue;
                ResourceBundleData data = new ResourceBundleData();
                data.setId(baseName + "_" + language);
                data.setName(baseName);
                data.setLanguage(language);
                data.setData(content);
                this.saveResourceBundle(data);
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("Error while reading the resource bundle : " + baseName), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResourceBundleContent(String name, String language, String defaultLang, ClassLoader cl) throws Exception {
        block10: {
            String string;
            String fileName = null;
            cl = new PropertiesClassLoader(cl, true);
            fileName = name + "_" + language + ".properties";
            URL url = cl.getResource(fileName);
            if (url == null && defaultLang.equals(language)) {
                url = cl.getResource(name + ".properties");
            }
            if (url == null) break block10;
            InputStream is = url.openStream();
            try {
                byte[] buf = IOUtil.getStreamContentAsBytes((InputStream)is);
                string = new String(buf, "UTF-8");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Exception("Error while reading the file: " + fileName, e);
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return string;
        }
        return null;
    }

    protected final void invalidate(String name) {
        this.cache_.remove((Serializable)((Object)name));
    }

    public ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader cl) {
        if (IdentityResourceBundle.MAGIC_LANGUAGE.equals(locale.getLanguage())) {
            return IdentityResourceBundle.getInstance();
        }
        if (this.isClasspathResource(name)) {
            return ResourceBundleLoader.load(name, locale, cl);
        }
        String id = name + "_" + locale.getLanguage();
        try {
            ResourceBundle rb = (ResourceBundle)this.cache_.get((Serializable)((Object)id));
            if (rb != null) {
                return rb;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ResourceBundle res = null;
            String rootId = name + "_" + this.localeService_.getDefaultLocaleConfig().getLanguage();
            ResourceBundle parent = this.getResourceBundleFromDb(rootId, null, locale);
            if (parent != null) {
                res = this.getResourceBundleFromDb(id, parent, locale);
                if (res == null) {
                    res = parent;
                }
                this.cache_.put((Serializable)((Object)id), (Object)res);
                return res;
            }
        }
        catch (Exception ex) {
            this.log_.error((Object)("Error: " + id), (Throwable)ex);
        }
        return null;
    }

    public ResourceBundle getResourceBundle(String[] name, Locale locale, ClassLoader cl) {
        if (IdentityResourceBundle.MAGIC_LANGUAGE.equals(locale.getLanguage())) {
            return IdentityResourceBundle.getInstance();
        }
        StringBuilder idBuf = new StringBuilder("merge:");
        for (String n : name) {
            idBuf.append(n).append("_");
        }
        idBuf.append(locale);
        String id = idBuf.toString();
        try {
            ResourceBundle res = (ResourceBundle)this.cache_.get((Serializable)((Object)id));
            if (res != null) {
                return res;
            }
            MapResourceBundle outputBundled = new MapResourceBundle(locale);
            for (int i = 0; i < name.length; ++i) {
                ResourceBundle temp = this.getResourceBundle(name[i], locale, cl);
                if (temp != null) {
                    outputBundled.merge(temp);
                    continue;
                }
                this.log_.warn((Object)("Cannot load and merge the bundle: " + name[i]));
            }
            outputBundled.resolveDependencies();
            this.cache_.put((Serializable)((Object)id), (Object)outputBundled);
            return outputBundled;
        }
        catch (Exception ex) {
            this.log_.error((Object)("Cannot load and merge the bundle: " + id), (Throwable)ex);
            return null;
        }
    }

    protected abstract ResourceBundle getResourceBundleFromDb(String var1, ResourceBundle var2, Locale var3) throws Exception;
}

