/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import org.apache.catalina.loader.WebappClassLoader;
import org.jboss.logging.Logger;
import org.jboss.proxy.compiler.IIOPStubCompiler;

public class WebAppClassLoader
extends WebappClassLoader {
    static Logger log = Logger.getLogger(WebAppClassLoader.class);
    private String[] filteredPackages = new String[]{"org.apache.commons.logging"};

    public WebAppClassLoader() {
    }

    public WebAppClassLoader(ClassLoader parent) {
        super(parent);
    }

    public String[] getFilteredPackages() {
        return this.filteredPackages;
    }

    public void setFilteredPackages(String[] pkgs) {
        this.filteredPackages = pkgs;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("findClass(" + name + ") called"));
        }
        if (name.endsWith("_Stub")) {
            int start = name.lastIndexOf(46) + 1;
            if (name.charAt(start) == '_') {
                String pkg = name.substring(0, start);
                String interfaceName = pkg + name.substring(start + 1, name.length() - 5);
                if (interfaceName.startsWith("org.omg.stub.com.sun.")) {
                    interfaceName = interfaceName.substring(13);
                }
                Class intf = super.loadClass(interfaceName);
                if (trace) {
                    log.trace((Object)("loaded class " + interfaceName));
                }
                try {
                    byte[] code = IIOPStubCompiler.compile((Class)intf, (String)name);
                    if (trace) {
                        log.trace((Object)("compiled stub class for " + interfaceName));
                    }
                    Class clz = this.defineClass(name, code, 0, code.length);
                    if (trace) {
                        log.trace((Object)("defined stub class for " + interfaceName));
                    }
                    this.resolveClass(clz);
                    try {
                        clz.newInstance();
                    }
                    catch (Throwable t) {
                        ClassNotFoundException cnfe = new ClassNotFoundException(interfaceName, t);
                        throw cnfe;
                    }
                    if (trace) {
                        log.trace((Object)("resolved stub class for " + interfaceName));
                    }
                    return clz;
                }
                catch (RuntimeException e) {
                    log.debug((Object)("failed finding class " + name), (Throwable)e);
                    return super.findClass(name);
                }
            }
            return super.findClass(name);
        }
        return super.findClass(name);
    }

    protected boolean filter(String name) {
        boolean excludeClass = super.filter(name);
        if (!excludeClass) {
            int length = this.filteredPackages != null ? this.filteredPackages.length : 0;
            for (int n = 0; n < length; ++n) {
                String pkg = this.filteredPackages[n];
                if (!name.startsWith(pkg)) continue;
                excludeClass = true;
                break;
            }
        }
        log.trace((Object)("filter name=" + name + ", exclude=" + excludeClass));
        return excludeClass;
    }
}

