/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;
import EDU.oswego.cs.dl.util.concurrent.WaitableInt;
import EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.PCTestLoop;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;
import EDU.oswego.cs.dl.util.concurrent.misc.TestLoop;
import EDU.oswego.cs.dl.util.concurrent.misc.Threads;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SynchronizationTimer {
    static final int[] nthreadsChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    static final int BLOCK_MODE = 0;
    static final int TIMEOUT_MODE = 1;
    static final int[] syncModes = new int[]{0, 1};
    static final int PRECISION = 10;
    final ThreadInfo[] threadInfo = new ThreadInfo[nthreadsChoices.length];
    static final int headerRows = 1;
    static final int classColumn = 0;
    static final int headerColumns = 1;
    final int tableRows = TestedClass.classes.length + 1;
    final int tableColumns = nthreadsChoices.length + 1;
    final JComponent[][] resultTable_ = new JComponent[this.tableRows][this.tableColumns];
    final SynchronizedInt nextClassIdx_ = new SynchronizedInt(0);
    final SynchronizedInt nextThreadIdx_ = new SynchronizedInt(0);
    ClockDaemon timeDaemon = new ClockDaemon();
    private final SynchronizedRef contention_ = new SynchronizedRef(null);
    private final SynchronizedInt loopsPerTest_ = new SynchronizedInt(0);
    private final SynchronizedBoolean echoToSystemOut = new SynchronizedBoolean(false);
    private final JButton startstop_ = new JButton("Start");
    private WaitableInt testNumber_ = new WaitableInt(1);
    private SynchronizedBoolean running_ = new SynchronizedBoolean(false);
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$Slot;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Times per call in microseconds");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(new SynchronizationTimer().mainPanel());
        frame.pack();
        frame.setVisible(true);
    }

    static String modeToString(int m) {
        String sms = m == 0 ? "block" : (m == 1 ? "timeout" : "No such mode");
        return sms;
    }

    static String biasToString(int b) {
        String sms = b < 0 ? "slower producer" : (b == 0 ? "balanced prod/cons rate" : (b > 0 ? "slower consumer" : "No such bias"));
        return sms;
    }

    static String p2ToString(int n) {
        String suf = "";
        if (n >= 1024) {
            suf = "K";
            if ((n /= 1024) >= 1024) {
                n /= 1024;
                suf = "M";
            }
        }
        return n + suf;
    }

    static String formatTime(long ns, boolean showDecimal) {
        long intpart = ns / 10L;
        long decpart = ns % 10L;
        if (!showDecimal) {
            if (decpart >= 5L) {
                ++intpart;
            }
            return Long.toString(intpart);
        }
        String sint = Long.toString(intpart);
        String sdec = Long.toString(decpart);
        if (decpart == 0L) {
            for (int z = 10; z > 10; z /= 10) {
                sdec = "0" + sdec;
            }
        }
        String ts = sint + "." + sdec;
        return ts;
    }

    boolean threadEnabled(int nthreads) {
        return this.threadInfo[nthreads].getEnabled();
    }

    JPanel resultPanel() {
        JPanel[] colPanel = new JPanel[this.tableColumns];
        for (int col = 0; col < this.tableColumns; ++col) {
            colPanel[col] = new JPanel();
            colPanel[col].setLayout(new GridLayout(this.tableRows, 1));
            if (col == 0) continue;
            colPanel[col].setBackground(Color.white);
        }
        Color hdrbg = colPanel[0].getBackground();
        LineBorder border = new LineBorder(hdrbg);
        Font font = new Font("Dialog", 0, 12);
        Dimension labDim = new Dimension(40, 16);
        Dimension cbDim = new Dimension(154, 16);
        JLabel cornerLab = new JLabel(" Classes      \\      Threads");
        cornerLab.setMinimumSize(cbDim);
        cornerLab.setPreferredSize(cbDim);
        cornerLab.setFont(font);
        this.resultTable_[0][0] = cornerLab;
        colPanel[0].add(cornerLab);
        for (int col = 1; col < this.tableColumns; ++col) {
            final int nthreads = col - 1;
            JCheckBox tcb = new JCheckBox(this.threadInfo[nthreads].name, true);
            tcb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SynchronizationTimer.this.threadInfo[nthreads].toggleEnabled();
                }
            });
            tcb.setMinimumSize(labDim);
            tcb.setPreferredSize(labDim);
            tcb.setFont(font);
            tcb.setBackground(hdrbg);
            this.resultTable_[0][col] = tcb;
            colPanel[col].add(tcb);
        }
        for (int row = 1; row < this.tableRows; ++row) {
            final int cls = row - 1;
            JCheckBox cb = new JCheckBox(TestedClass.classes[cls].name, true);
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TestedClass.classes[cls].toggleEnabled();
                }
            });
            this.resultTable_[row][0] = cb;
            cb.setMinimumSize(cbDim);
            cb.setPreferredSize(cbDim);
            cb.setFont(font);
            colPanel[0].add(cb);
            for (int col = 1; col < this.tableColumns; ++col) {
                int nthreads = col - 1;
                JLabel lab = new JLabel("");
                this.resultTable_[row][col] = lab;
                lab.setMinimumSize(labDim);
                lab.setPreferredSize(labDim);
                lab.setBorder(border);
                lab.setFont(font);
                lab.setBackground(Color.white);
                lab.setForeground(Color.black);
                lab.setHorizontalAlignment(4);
                colPanel[col].add(lab);
            }
        }
        JPanel tblPanel = new JPanel();
        tblPanel.setLayout(new BoxLayout(tblPanel, 0));
        for (int col = 0; col < this.tableColumns; ++col) {
            tblPanel.add(colPanel[col]);
        }
        return tblPanel;
    }

    void setTime(final long ns, int clsIdx, int nthrIdx) {
        int row = clsIdx + 1;
        int col = nthrIdx + 1;
        final JLabel cell = (JLabel)this.resultTable_[row][col];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                cell.setText(SynchronizationTimer.formatTime(ns, true));
            }
        });
    }

    void clearTable() {
        for (int i = 1; i < this.tableRows; ++i) {
            for (int j = 1; j < this.tableColumns; ++j) {
                ((JLabel)this.resultTable_[i][j]).setText("");
            }
        }
    }

    void setChecks(boolean setting) {
        for (int i = 0; i < TestedClass.classes.length; ++i) {
            TestedClass.classes[i].setEnabled(new Boolean(setting));
            ((JCheckBox)this.resultTable_[i + 1][0]).setSelected(setting);
        }
    }

    public SynchronizationTimer() {
        for (int i = 0; i < this.threadInfo.length; ++i) {
            this.threadInfo[i] = new ThreadInfo(nthreadsChoices[i]);
        }
    }

    JPanel mainPanel() {
        new PrintStart();
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new GridLayout(5, 3));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3));
        this.startstop_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SynchronizationTimer.this.running_.get()) {
                    SynchronizationTimer.this.cancel();
                } else {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries());
                    }
                    catch (InterruptedException ex) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        paramPanel.add(this.startstop_);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 2));
        JButton continueButton = new JButton("Continue");
        continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!SynchronizationTimer.this.running_.get()) {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries(SynchronizationTimer.this.nextClassIdx_.get(), SynchronizationTimer.this.nextThreadIdx_.get()));
                    }
                    catch (InterruptedException ex) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        p1.add(continueButton);
        JButton clearButton = new JButton("Clear cells");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SynchronizationTimer.this.clearTable();
            }
        });
        p1.add(clearButton);
        paramPanel.add(p1);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(1, 2));
        JButton setButton = new JButton("All classes");
        setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SynchronizationTimer.this.setChecks(true);
            }
        });
        p3.add(setButton);
        JButton unsetButton = new JButton("No classes");
        unsetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SynchronizationTimer.this.setChecks(false);
            }
        });
        p3.add(unsetButton);
        paramPanel.add(p3);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        JCheckBox consoleBox = new JCheckBox("Console echo");
        consoleBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SynchronizationTimer.this.echoToSystemOut.complement();
            }
        });
        JLabel poolinfo = new JLabel("Active threads:      0");
        p2.add(poolinfo);
        p2.add(consoleBox);
        paramPanel.add(p2);
        paramPanel.add(this.contentionBox());
        paramPanel.add(this.itersBox());
        paramPanel.add(this.cloopBox());
        paramPanel.add(this.barrierBox());
        paramPanel.add(this.exchangeBox());
        paramPanel.add(this.biasBox());
        paramPanel.add(this.capacityBox());
        paramPanel.add(this.timeoutBox());
        paramPanel.add(this.syncModePanel());
        paramPanel.add(this.producerSyncModePanel());
        paramPanel.add(this.consumerSyncModePanel());
        this.startPoolStatus(poolinfo);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel tblPanel = this.resultPanel();
        mainPanel.add(tblPanel);
        mainPanel.add(paramPanel);
        return mainPanel;
    }

    JComboBox syncModePanel() {
        JComboBox<String> syncModeComboBox = new JComboBox<String>();
        for (int j = 0; j < syncModes.length; ++j) {
            String lab = "Locks: " + SynchronizationTimer.modeToString(syncModes[j]);
            syncModeComboBox.addItem(lab);
        }
        syncModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.syncMode.set(syncModes[idx]);
            }
        });
        RNG.syncMode.set(syncModes[0]);
        syncModeComboBox.setSelectedIndex(0);
        return syncModeComboBox;
    }

    JComboBox producerSyncModePanel() {
        JComboBox<String> producerSyncModeComboBox = new JComboBox<String>();
        for (int j = 0; j < syncModes.length; ++j) {
            String lab = "Producers: " + SynchronizationTimer.modeToString(syncModes[j]);
            producerSyncModeComboBox.addItem(lab);
        }
        producerSyncModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.producerMode.set(syncModes[idx]);
            }
        });
        RNG.producerMode.set(syncModes[0]);
        producerSyncModeComboBox.setSelectedIndex(0);
        return producerSyncModeComboBox;
    }

    JComboBox consumerSyncModePanel() {
        JComboBox<String> consumerSyncModeComboBox = new JComboBox<String>();
        for (int j = 0; j < syncModes.length; ++j) {
            String lab = "Consumers: " + SynchronizationTimer.modeToString(syncModes[j]);
            consumerSyncModeComboBox.addItem(lab);
        }
        consumerSyncModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.consumerMode.set(syncModes[idx]);
            }
        });
        RNG.consumerMode.set(syncModes[0]);
        consumerSyncModeComboBox.setSelectedIndex(0);
        return consumerSyncModeComboBox;
    }

    JComboBox contentionBox() {
        final Fraction[] contentionChoices = new Fraction[]{new Fraction(0L, 1L), new Fraction(1L, 16L), new Fraction(1L, 8L), new Fraction(1L, 4L), new Fraction(1L, 2L), new Fraction(1L, 1L)};
        JComboBox<String> contentionComboBox = new JComboBox<String>();
        for (int j = 0; j < contentionChoices.length; ++j) {
            String lab = contentionChoices[j].asDouble() * 100.0 + "% contention/sharing";
            contentionComboBox.addItem(lab);
        }
        contentionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                SynchronizationTimer.this.contention_.set(contentionChoices[idx]);
            }
        });
        this.contention_.set(contentionChoices[3]);
        contentionComboBox.setSelectedIndex(3);
        return contentionComboBox;
    }

    JComboBox itersBox() {
        final int[] loopsPerTestChoices = new int[]{1, 16, 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> precComboBox = new JComboBox<String>();
        for (int j = 0; j < loopsPerTestChoices.length; ++j) {
            String lab = SynchronizationTimer.p2ToString(loopsPerTestChoices[j]) + " calls per thread per test";
            precComboBox.addItem(lab);
        }
        precComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                SynchronizationTimer.this.loopsPerTest_.set(loopsPerTestChoices[idx]);
            }
        });
        this.loopsPerTest_.set(loopsPerTestChoices[8]);
        precComboBox.setSelectedIndex(8);
        return precComboBox;
    }

    JComboBox cloopBox() {
        final int[] computationsPerCallChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
        JComboBox<String> cloopComboBox = new JComboBox<String>();
        for (int j = 0; j < computationsPerCallChoices.length; ++j) {
            String lab = SynchronizationTimer.p2ToString(computationsPerCallChoices[j]) + " computations per call";
            cloopComboBox.addItem(lab);
        }
        cloopComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.computeLoops.set(computationsPerCallChoices[idx]);
            }
        });
        RNG.computeLoops.set(computationsPerCallChoices[3]);
        cloopComboBox.setSelectedIndex(3);
        return cloopComboBox;
    }

    JComboBox barrierBox() {
        final int[] itersPerBarrierChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> barrierComboBox = new JComboBox<String>();
        for (int j = 0; j < itersPerBarrierChoices.length; ++j) {
            String lab = SynchronizationTimer.p2ToString(itersPerBarrierChoices[j]) + " iterations per barrier";
            barrierComboBox.addItem(lab);
        }
        barrierComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.itersPerBarrier.set(itersPerBarrierChoices[idx]);
            }
        });
        RNG.itersPerBarrier.set(itersPerBarrierChoices[13]);
        barrierComboBox.setSelectedIndex(13);
        return barrierComboBox;
    }

    JComboBox exchangeBox() {
        final int[] exchangerChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
        JComboBox<String> exchComboBox = new JComboBox<String>();
        for (int j = 0; j < exchangerChoices.length; ++j) {
            String lab = SynchronizationTimer.p2ToString(exchangerChoices[j]) + " max threads per barrier";
            exchComboBox.addItem(lab);
        }
        exchComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.exchangeParties.set(exchangerChoices[idx]);
            }
        });
        RNG.exchangeParties.set(exchangerChoices[1]);
        exchComboBox.setSelectedIndex(1);
        return exchComboBox;
    }

    JComboBox biasBox() {
        final int[] biasChoices = new int[]{-1, 0, 1};
        JComboBox<String> biasComboBox = new JComboBox<String>();
        for (int j = 0; j < biasChoices.length; ++j) {
            String lab = SynchronizationTimer.biasToString(biasChoices[j]);
            biasComboBox.addItem(lab);
        }
        biasComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.bias.set(biasChoices[idx]);
            }
        });
        RNG.bias.set(biasChoices[1]);
        biasComboBox.setSelectedIndex(1);
        return biasComboBox;
    }

    JComboBox capacityBox() {
        final int[] bufferCapacityChoices = new int[]{1, 4, 64, 256, 1024, 4096, 16384, 65536, 262144, 0x100000};
        JComboBox<String> bcapComboBox = new JComboBox<String>();
        for (int j = 0; j < bufferCapacityChoices.length; ++j) {
            String lab = SynchronizationTimer.p2ToString(bufferCapacityChoices[j]) + " element bounded buffers";
            bcapComboBox.addItem(lab);
        }
        bcapComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                DefaultChannelCapacity.set(bufferCapacityChoices[idx]);
            }
        });
        DefaultChannelCapacity.set(bufferCapacityChoices[3]);
        bcapComboBox.setSelectedIndex(3);
        return bcapComboBox;
    }

    JComboBox timeoutBox() {
        final long[] timeoutChoices = new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 100000L};
        JComboBox<String> timeoutComboBox = new JComboBox<String>();
        for (int j = 0; j < timeoutChoices.length; ++j) {
            String lab = timeoutChoices[j] + " msec timeouts";
            timeoutComboBox.addItem(lab);
        }
        timeoutComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JComboBox src = (JComboBox)evt.getItemSelectable();
                int idx = src.getSelectedIndex();
                RNG.timeout.set(timeoutChoices[idx]);
            }
        });
        RNG.timeout.set(timeoutChoices[3]);
        timeoutComboBox.setSelectedIndex(3);
        return timeoutComboBox;
    }

    void startPoolStatus(final JLabel status) {
        Runnable updater = new Runnable(){
            int lastps = 0;

            public void run() {
                int ps = Threads.activeThreads.get();
                if (this.lastps != ps) {
                    this.lastps = ps;
                    SwingUtilities.invokeLater(new Runnable(this, ps){
                        private final /* synthetic */ int val$ps;
                        private final /* synthetic */ 22 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$ps = val$ps;
                        }

                        public void run() {
                            22.access$400(this.this$1).setText("Active threads: " + this.val$ps);
                        }
                    });
                }
            }

            static /* synthetic */ JLabel access$400(22 x0) {
                return x0.status;
            }
        };
        this.timeDaemon.executePeriodically(250L, updater, false);
    }

    private void runOneTest(Runnable tst) throws InterruptedException {
        int nt = this.testNumber_.get();
        Threads.pool.execute(tst);
        this.testNumber_.whenNotEqual(nt, null);
    }

    private void endOneTest() {
        this.testNumber_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = RNG.constructionLock;
        synchronized (object) {
            try {
                Threads.pool.interruptAll();
            }
            catch (Exception ex) {
                System.out.println("\nException during cancel:\n" + ex);
                return;
            }
        }
    }

    void startTestSeries(Runnable tst) throws InterruptedException {
        this.running_.set(true);
        this.startstop_.setText("Stop");
        Threads.pool.execute(tst);
    }

    void endTestSeries() {
        this.running_.set(false);
        SwingUtilities.invokeLater(new PrintStart());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class OneTest
    implements Runnable {
        final int clsIdx;
        final int nthreadsIdx;

        OneTest(int idx, int t) {
            this.clsIdx = idx;
            this.nthreadsIdx = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Color oldfg;
            JLabel cell;
            boolean wasInterrupted;
            block26: {
                block25: {
                    block24: {
                        boolean clear2;
                        block23: {
                            Thread.currentThread().setPriority(2);
                            wasInterrupted = false;
                            TestedClass entry = TestedClass.classes[this.clsIdx];
                            cell = (JLabel)SynchronizationTimer.this.resultTable_[this.clsIdx + 1][this.nthreadsIdx + 1];
                            oldfg = cell.getForeground();
                            try {
                                try {
                                    if (Thread.interrupted()) {
                                        Object var21_5 = null;
                                        clear2 = wasInterrupted;
                                        break block23;
                                    }
                                    if (!SynchronizationTimer.this.threadEnabled(this.nthreadsIdx)) {
                                        break block24;
                                    }
                                    int nthreads = nthreadsChoices[this.nthreadsIdx];
                                    int iters = SynchronizationTimer.this.loopsPerTest_.get();
                                    Fraction pshr = (Fraction)SynchronizationTimer.this.contention_.get();
                                    if (!entry.isEnabled(nthreads, pshr)) {
                                        break block25;
                                    }
                                    BarrierTimer timer = new BarrierTimer();
                                    CyclicBarrier barrier = new CyclicBarrier(nthreads + 1, timer);
                                    Class cls = entry.cls;
                                    Class chanCls = entry.buffCls;
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(this, cell){
                                            private final /* synthetic */ JLabel val$cell;
                                            private final /* synthetic */ OneTest this$1;
                                            {
                                                this.this$1 = this$1;
                                                this.val$cell = val$cell;
                                            }

                                            public void run() {
                                                this.val$cell.setForeground(Color.blue);
                                                this.val$cell.setText("RUN");
                                                this.val$cell.repaint();
                                            }
                                        });
                                    }
                                    catch (InvocationTargetException ex) {
                                        ex.printStackTrace();
                                        System.exit(-1);
                                    }
                                    Object ex = RNG.constructionLock;
                                    synchronized (ex) {
                                        RNG.reset(nthreads);
                                        if (chanCls == null) {
                                            RNG shared = (RNG)cls.newInstance();
                                            for (int k = 0; k < nthreads; ++k) {
                                                RNG pri = (RNG)cls.newInstance();
                                                TestLoop l = new TestLoop(shared, pri, pshr, iters, barrier);
                                                Threads.pool.execute(l.testLoop());
                                            }
                                        } else {
                                            Channel shared = (Channel)chanCls.newInstance();
                                            if (nthreads == 1) {
                                                ChanRNG single = (ChanRNG)cls.newInstance();
                                                single.setSingle(true);
                                                PCTestLoop l = new PCTestLoop(single.getDelegate(), single, pshr, iters, barrier, shared, shared);
                                                Threads.pool.execute(l.testLoop(true));
                                            } else {
                                                if (nthreads % 2 != 0) {
                                                    throw new Error("Must have even number of threads!");
                                                }
                                                int npairs = nthreads / 2;
                                                for (int k = 0; k < npairs; ++k) {
                                                    ChanRNG t = (ChanRNG)cls.newInstance();
                                                    t.setSingle(false);
                                                    Channel chan = (Channel)chanCls.newInstance();
                                                    PCTestLoop l = new PCTestLoop(t.getDelegate(), t, pshr, iters, barrier, shared, chan);
                                                    Threads.pool.execute(l.testLoop(false));
                                                    Threads.pool.execute(l.testLoop(true));
                                                }
                                            }
                                        }
                                        if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                            System.out.print(entry.name + " " + nthreads + "T " + pshr + "S " + RNG.computeLoops.get() + "I " + RNG.syncMode.get() + "Lm " + RNG.timeout.get() + "TO " + RNG.producerMode.get() + "Pm " + RNG.consumerMode.get() + "Cm " + RNG.bias.get() + "B " + DefaultChannelCapacity.get() + "C " + RNG.exchangeParties.get() + "Xp " + RNG.itersPerBarrier.get() + "Ib : ");
                                        }
                                    }
                                    barrier.barrier();
                                    barrier.barrier();
                                    long tm = timer.getTime();
                                    long totalIters = nthreads * iters;
                                    double dns = (double)tm * 1000.0 * 10.0 / (double)totalIters;
                                    long ns = Math.round(dns);
                                    SynchronizationTimer.this.setTime(ns, this.clsIdx, this.nthreadsIdx);
                                    if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                        System.out.println(SynchronizationTimer.formatTime(ns, true));
                                    }
                                    break block26;
                                }
                                catch (BrokenBarrierException ex) {
                                    wasInterrupted = true;
                                    Object var21_9 = null;
                                    boolean clear2 = wasInterrupted;
                                    SwingUtilities.invokeLater(new Runnable(this, clear2, cell, oldfg){
                                        private final /* synthetic */ boolean val$clear;
                                        private final /* synthetic */ JLabel val$cell;
                                        private final /* synthetic */ Color val$oldfg;
                                        private final /* synthetic */ OneTest this$1;
                                        {
                                            this.this$1 = this$1;
                                            this.val$clear = val$clear;
                                            this.val$cell = val$cell;
                                            this.val$oldfg = val$oldfg;
                                        }

                                        public void run() {
                                            if (this.val$clear) {
                                                this.val$cell.setText("");
                                            }
                                            this.val$cell.setForeground(this.val$oldfg);
                                            this.val$cell.repaint();
                                        }
                                    });
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                                catch (InterruptedException ex) {
                                    wasInterrupted = true;
                                    Thread.currentThread().interrupt();
                                    Object var21_10 = null;
                                    boolean clear2 = wasInterrupted;
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    System.out.println("Construction Exception?");
                                    System.exit(-1);
                                    Object var21_11 = null;
                                    boolean clear2 = wasInterrupted;
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var21_12 = null;
                                boolean clear2 = wasInterrupted;
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                Thread.currentThread().setPriority(5);
                                SynchronizationTimer.this.endOneTest();
                                throw throwable;
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        Thread.currentThread().setPriority(5);
                        SynchronizationTimer.this.endOneTest();
                        return;
                    }
                    Object var21_6 = null;
                    boolean clear2 = wasInterrupted;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    Thread.currentThread().setPriority(5);
                    SynchronizationTimer.this.endOneTest();
                    return;
                }
                Object var21_7 = null;
                boolean clear2 = wasInterrupted;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                Thread.currentThread().setPriority(5);
                SynchronizationTimer.this.endOneTest();
                return;
            }
            Object var21_8 = null;
            boolean clear2 = wasInterrupted;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            Thread.currentThread().setPriority(5);
            SynchronizationTimer.this.endOneTest();
        }
    }

    static class BarrierTimer
    implements Runnable {
        private long startTime_ = 0L;
        private long endTime_ = 0L;

        BarrierTimer() {
        }

        public synchronized long getTime() {
            return this.endTime_ - this.startTime_;
        }

        public synchronized void run() {
            long now = System.currentTimeMillis();
            if (this.startTime_ == 0L) {
                this.startTime_ = now;
            } else {
                this.endTime_ = now;
            }
        }
    }

    class TestSeries
    implements Runnable {
        final int firstclass;
        final int firstnthreads;

        TestSeries() {
            this.firstclass = 0;
            this.firstnthreads = 0;
        }

        TestSeries(int firstc, int firstnt) {
            this.firstclass = firstc;
            this.firstnthreads = firstnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                Thread.currentThread().setPriority(5);
                try {
                    int t = this.firstnthreads;
                    int c = this.firstclass;
                    if (t >= nthreadsChoices.length || c >= TestedClass.classes.length) break block10;
                    while (true) {
                        if (SynchronizationTimer.this.threadEnabled(t)) {
                            TestedClass entry = TestedClass.classes[c];
                            int nthreads = nthreadsChoices[t];
                            int iters = SynchronizationTimer.this.loopsPerTest_.get();
                            Fraction pshr = (Fraction)SynchronizationTimer.this.contention_.get();
                            if (entry.isEnabled(nthreads, pshr)) {
                                SynchronizationTimer.this.runOneTest(new OneTest(c, t));
                            }
                        }
                        if (++c >= TestedClass.classes.length) {
                            c = 0;
                            if (++t >= nthreadsChoices.length) {
                                break;
                            }
                        }
                        SynchronizationTimer.this.nextClassIdx_.set(c);
                        SynchronizationTimer.this.nextThreadIdx_.set(t);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    SynchronizationTimer.this.endTestSeries();
                }
            }
        }
    }

    class PrintStart
    implements Runnable {
        PrintStart() {
        }

        public void run() {
            SynchronizationTimer.this.startstop_.setText("Start");
        }
    }

    static class ThreadInfo {
        final String name;
        final int number;
        Boolean enabled;

        ThreadInfo(int nthr) {
            this.number = nthr;
            this.name = SynchronizationTimer.p2ToString(nthr);
            this.enabled = new Boolean(true);
        }

        synchronized Boolean getEnabled() {
            return this.enabled;
        }

        synchronized void setEnabled(Boolean v) {
            this.enabled = v;
        }

        synchronized void toggleEnabled() {
            this.enabled = new Boolean(this.enabled == false);
        }
    }

    static class TestedClass {
        final String name;
        final Class cls;
        final boolean multipleOK;
        final boolean singleOK;
        final Class buffCls;
        Boolean enabled_ = new Boolean(true);
        static final TestedClass dummy = new TestedClass("", null, false, false);
        static final TestedClass[] classes = new TestedClass[]{new TestedClass("NoSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.NoSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG, false, true), new TestedClass("PublicSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG, true, true), new TestedClass("NestedSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.AllSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG, true, true), new TestedClass("SDelegated", class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SDelegatedRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG, true, true), new TestedClass("SynchLongUsingSet", class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SynchLongRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG, true, true), new TestedClass("SynchLongUsingCommit", class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.AClongRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG, true, true), new TestedClass("Semaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG, true, true), new TestedClass("WaiterPrefSemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.WpSemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG, true, true), new TestedClass("FIFOSemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.FifoRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG, true, true), new TestedClass("PrioritySemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG, true, true), new TestedClass("Mutex", class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.MutexRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG, true, true), new TestedClass("ReentrantLock", class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.RlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG, true, true), new TestedClass("WriterPrefRWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.WpRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG, true, true), new TestedClass("ReaderPrefRWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ReaderPrefRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG, true, true), new TestedClass("FIFORWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.FIFORWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG, true, true), new TestedClass("ReentrantRWL", class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ReentrantRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG, true, true), new TestedClass("LinkedQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.LinkedQueue")) : class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue), new TestedClass("WaitFreeQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue")) : class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue), new TestedClass("BoundedLinkedQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue), new TestedClass("BoundedBuffer", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedBuffer")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer), new TestedClass("CondVarBoundedBuffer", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.CVBuffer")) : class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer), new TestedClass("BoundedPriorityQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue), new TestedClass("Slot", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$Slot == null ? (class$EDU$oswego$cs$dl$util$concurrent$Slot = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.Slot")) : class$EDU$oswego$cs$dl$util$concurrent$Slot), new TestedClass("SynchronousChannel", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, false, class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel == null ? (class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.SynchronousChannel")) : class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel), new TestedClass("DirectExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.DirectExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG, true, true), new TestedClass("SemaphoreLckExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.LockedSemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG, true, true), new TestedClass("QueuedExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.QueuedExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG, true, true), new TestedClass("ThreadedExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ThreadedExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG, true, true), new TestedClass("PooledExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PooledExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG, true, true)};

        synchronized void setEnabled(Boolean b) {
            this.enabled_ = b;
        }

        synchronized Boolean getEnabled() {
            return this.enabled_;
        }

        synchronized void toggleEnabled() {
            boolean enabled = this.enabled_;
            this.enabled_ = new Boolean(!enabled);
        }

        synchronized boolean isEnabled(int nthreads, Fraction shared) {
            boolean enabled = this.enabled_;
            if (!enabled) {
                return false;
            }
            if (!this.singleOK && nthreads <= 1) {
                return false;
            }
            return this.multipleOK || nthreads <= 1 || shared.compareTo(0L) <= 0;
        }

        TestedClass(String n, Class c, boolean m, boolean sok) {
            this.name = n;
            this.cls = c;
            this.multipleOK = m;
            this.singleOK = sok;
            this.buffCls = null;
        }

        TestedClass(String n, Class c, boolean m, boolean sok, Class bc) {
            this.name = n;
            this.cls = c;
            this.multipleOK = m;
            this.singleOK = sok;
            this.buffCls = bc;
        }
    }
}

