/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationProperty
implements Comparable<RegistrationProperty> {
    private Long persistentId;
    private RegistrationPropertyDescription persistentDescription;
    private String persistentLang;
    private String persistentName;
    private String persistentValue;
    private Status status;
    private transient PropertyChangeListener listener;

    @Override
    public int compareTo(RegistrationProperty o) {
        return this.persistentName.compareTo(o.persistentName);
    }

    public RegistrationProperty() {
    }

    public RegistrationProperty(String name, String stringValue, String lang, PropertyChangeListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"Name", (String)"RegistrationProperty");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)lang, (String)"Lang", (String)"RegistrationProperty");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"listener");
        this.persistentName = name;
        this.persistentLang = lang;
        this.listener = listener;
        this.setValue(stringValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegistrationProperty)) {
            return false;
        }
        RegistrationProperty that = (RegistrationProperty)o;
        if (this.persistentId != null ? !this.persistentId.equals(that.persistentId) : that.persistentId != null) {
            return false;
        }
        if (!this.persistentName.equals(that.persistentName)) {
            return false;
        }
        return !(this.persistentValue == null ? that.persistentValue != null : !this.persistentValue.equals(that.persistentValue));
    }

    public int hashCode() {
        int result = this.persistentId != null ? this.persistentId.hashCode() : 0;
        result = 31 * result + this.persistentName.hashCode();
        result = 31 * result + (this.persistentValue != null ? this.persistentValue.hashCode() : 0);
        return result;
    }

    public Long getKey() {
        return this.persistentId;
    }

    public void setKey(Long key) {
        this.persistentId = key;
    }

    public String getName() {
        return this.persistentName;
    }

    public void setName(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"Name", (String)"RegistrationProperty");
        this.persistentName = name;
    }

    public String getValue() {
        return this.persistentValue;
    }

    public RegistrationPropertyDescription getDescription() {
        return this.persistentDescription;
    }

    public void setDescription(RegistrationPropertyDescription description) {
        this.persistentDescription = description;
    }

    public Boolean isInvalid() {
        if (Status.UNCHECKED_VALUE.equals((Object)this.status)) {
            return null;
        }
        return !Status.VALID.equals((Object)this.status);
    }

    public boolean isDeterminedInvalid() {
        return !Status.VALID.equals((Object)this.status) && !Status.UNCHECKED_VALUE.equals((Object)this.status);
    }

    public void setValue(String stringValue) {
        if (this.persistentValue != null && !this.persistentValue.equals(stringValue) || this.persistentValue == null && stringValue != null) {
            String oldValue = this.persistentValue;
            this.persistentValue = stringValue;
            this.status = this.persistentValue == null ? Status.MISSING_VALUE : Status.UNCHECKED_VALUE;
            this.notifyListener(oldValue, this.persistentValue);
        }
    }

    public String getLang() {
        return this.persistentLang;
    }

    public void setLang(String lang) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)lang, (String)"Lang", (String)"RegistrationProperty");
        this.persistentLang = lang;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    private void notifyListener(String oldValue, String newValue) {
        if (this.listener != null) {
            this.listener.propertyValueChanged(this, oldValue, newValue);
        }
    }

    public void setListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public static interface PropertyChangeListener {
        public void propertyValueChanged(RegistrationProperty var1, Object var2, Object var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        INEXISTENT("registration_property_status_inexistent"),
        MISSING("registration_property_status_missing"),
        MISSING_VALUE("registration_property_status_missing_value"),
        UNCHECKED_VALUE("registration_property_status_unchecked_value"),
        INVALID_VALUE("registration_property_status_invalid_value"),
        VALID("registration_property_status_valid");

        private String localizationKey;

        private Status(String localizationKey) {
            this.localizationKey = localizationKey;
        }

        public String getLocalizationKey() {
            return this.localizationKey;
        }
    }
}

