/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import org.gatein.common.net.URLTools;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.portlet.impl.jsr168.PortletUtils;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.producer.AbsoluteURLReplacementGenerator;
import org.gatein.wsrp.producer.RequestProcessor;
import org.gatein.wsrp.producer.WSRPPortletInvocationContext;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.servlet.ServletAccess;
import org.oasis.wsrp.v1.GetMarkup;
import org.oasis.wsrp.v1.InvalidHandle;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.MarkupContext;
import org.oasis.wsrp.v1.MarkupParams;
import org.oasis.wsrp.v1.MissingParameters;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.PortletContext;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.UnsupportedMimeType;
import org.oasis.wsrp.v1.UnsupportedMode;
import org.oasis.wsrp.v1.UnsupportedWindowState;
import org.oasis.wsrp.v1.UserContext;

public class RenderRequestProcessor
extends RequestProcessor {
    private static final String EMPTY = "";
    private final GetMarkup getMarkup;
    private String namespace;

    public RenderRequestProcessor(WSRPProducerImpl producer, GetMarkup getMarkup) throws UnsupportedMimeType, UnsupportedWindowState, InvalidHandle, UnsupportedMode, MissingParameters, InvalidRegistration, OperationFailed {
        super(producer);
        this.getMarkup = getMarkup;
        this.prepareInvocation();
    }

    RegistrationContext getRegistrationContext() {
        return this.getMarkup.getRegistrationContext();
    }

    RuntimeContext getRuntimeContext() {
        return this.getMarkup.getRuntimeContext();
    }

    MarkupParams getMarkupParams() {
        return this.getMarkup.getMarkupParams();
    }

    PortletContext getPortletContext() {
        return this.getMarkup.getPortletContext();
    }

    UserContext getUserContext() {
        return this.getMarkup.getUserContext();
    }

    String getContextName() {
        return "GetMarkup";
    }

    AccessMode getAccessMode() {
        return AccessMode.READ_ONLY;
    }

    PortletInvocation initInvocation(WSRPPortletInvocationContext context) {
        this.namespace = PortletUtils.generateNamespaceFrom((String)context.getWindowContext().getId());
        return new RenderInvocation((PortletInvocationContext)context);
    }

    Object processResponse(PortletInvocationResponse response) {
        FragmentResponse fragment = (FragmentResponse)response;
        String markupString = null;
        byte[] markupBinary = null;
        switch (fragment.getType()) {
            case 1: {
                markupString = this.processFragmentString(fragment.getChars());
                break;
            }
            case 2: {
                markupBinary = fragment.getBytes();
                break;
            }
            case 0: {
                markupString = EMPTY;
            }
        }
        MarkupContext markupContext = markupString != null ? WSRPTypeFactory.createMarkupContext((String)this.markupRequest.getMediaType(), (String)markupString) : WSRPTypeFactory.createMarkupContext((String)this.markupRequest.getMediaTypeWithCharset(), (byte[])markupBinary);
        markupContext.setLocale(this.markupRequest.getLocale());
        markupContext.setRequiresUrlRewriting(Boolean.TRUE);
        markupContext.setPreferredTitle(this.portletDescription.getTitle().getValue());
        int expires = fragment.getCacheControl().getExpirationSecs();
        if (expires != 0) {
            if (expires < 0) {
                expires = -1;
            }
            markupContext.setCacheControl(WSRPTypeFactory.createCacheControl((int)expires, (String)"wsrp:perUser"));
        }
        return WSRPTypeFactory.createMarkupResponse((MarkupContext)markupContext);
    }

    private String processFragmentString(String renderString) {
        String result = renderString.replaceAll(this.namespace, "wsrp_rewrite_");
        result = URLTools.replaceURLsBy((String)result, (URLTools.URLReplacementGenerator)new AbsoluteURLReplacementGenerator(ServletAccess.getRequest()));
        return result;
    }
}

