/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;

public class CacheableUserHandlerImpl
implements UserHandler {
    private final ExoCache userCache;
    private final ExoCache userProfileCache;
    private final ExoCache membershipCache;
    private final UserHandler userHandler;

    public CacheableUserHandlerImpl(OrganizationCacheHandler organizationCacheHandler, UserHandler userHandler) {
        this.userCache = organizationCacheHandler.getUserCache();
        this.userProfileCache = organizationCacheHandler.getUserProfileCache();
        this.membershipCache = organizationCacheHandler.getMembershipCache();
        this.userHandler = userHandler;
    }

    public void addUserEventListener(UserEventListener listener) {
        this.userHandler.addUserEventListener(listener);
    }

    public boolean authenticate(String username, String password) throws Exception {
        boolean authenticated = this.userHandler.authenticate(username, password);
        this.userCache.remove((Serializable)((Object)username));
        return authenticated;
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        this.userHandler.createUser(user, broadcast);
    }

    public User createUserInstance() {
        return this.userHandler.createUserInstance();
    }

    public User createUserInstance(String username) {
        return this.userHandler.createUserInstance(username);
    }

    public User findUserByName(String userName) throws Exception {
        User user = (User)this.userCache.get((Serializable)((Object)userName));
        if (user != null) {
            return user;
        }
        user = this.userHandler.findUserByName(userName);
        if (user != null) {
            this.userCache.put((Serializable)((Object)userName), (Object)user);
        }
        return user;
    }

    public PageList findUsers(Query query) throws Exception {
        return this.userHandler.findUsers(query);
    }

    public PageList findUsersByGroup(String groupId) throws Exception {
        return this.userHandler.findUsersByGroup(groupId);
    }

    public PageList getUserPageList(int pageSize) throws Exception {
        return this.userHandler.getUserPageList(pageSize);
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        User user = this.userHandler.removeUser(userName, broadcast);
        if (user != null) {
            this.userCache.remove((Serializable)((Object)userName));
            this.userProfileCache.remove((Serializable)((Object)userName));
            List memberships = this.membershipCache.getCachedObjects();
            for (Membership membership : memberships) {
                if (!membership.getUserName().equals(userName)) continue;
                this.membershipCache.remove((Serializable)((Object)membership.getId()));
                this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
            }
        }
        return user;
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        this.userHandler.saveUser(user, broadcast);
        this.userCache.put((Serializable)((Object)user.getUserName()), (Object)user);
    }
}

