/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPElementWriter;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;

public final class MessageTrace {
    private static Logger msgLog = Logger.getLogger(MessageTrace.class);

    private MessageTrace() {
    }

    public static void traceMessage(String messagePrefix, MessageAbstraction message) {
        if (msgLog.isTraceEnabled()) {
            if (message instanceof SOAPMessage) {
                try {
                    SOAPEnvelope soapEnv = ((SOAPMessage)message).getSOAPPart().getEnvelope();
                    if (soapEnv != null) {
                        String envStr = SOAPElementWriter.writeElement((SOAPElementImpl)soapEnv, true);
                        msgLog.trace((Object)(messagePrefix + "\n" + envStr));
                    }
                }
                catch (SOAPException ex) {
                    msgLog.error((Object)"Cannot trace SOAPMessage", (Throwable)ex);
                }
            } else if (message instanceof HTTPMessageImpl) {
                HTTPMessageImpl httpMessage = (HTTPMessageImpl)message;
                Element root = httpMessage.getXmlFragment().toElement();
                String xmlString = DOMWriter.printNode(root, true);
                msgLog.trace((Object)(messagePrefix + "\n" + xmlString));
            } else {
                msgLog.warn((Object)("Unsupported message type: " + message));
            }
        }
    }
}

