/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.DOMTypes;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.XSModelTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.wsdl.WSDL11Writer;
import org.jboss.ws.tools.wsdl.WSDLWriterResolver;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;

public class WSDLWriter {
    protected static final Logger log = Logger.getLogger(WSDLWriter.class);
    protected WSDLDefinitions wsdl;
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected String soapPrefix = "soap";
    protected boolean includeSchemaInWSDL = true;

    public WSDLWriter(WSDLDefinitions wsdl) {
        if (wsdl == null) {
            throw new IllegalArgumentException("WSDL definitions is NULL");
        }
        this.wsdl = wsdl;
    }

    public void write(Writer writer, String charset) throws IOException {
        this.write(writer, charset, null);
    }

    public void write(Writer writer, String charset, WSDLWriterResolver resolver) throws IOException {
        String wsdlNamespace = this.wsdl.getWsdlNamespace();
        if (!"http://schemas.xmlsoap.org/wsdl/".equals(wsdlNamespace)) {
            throw new WSException("Unsupported wsdl version: " + wsdlNamespace);
        }
        WSDL11Writer wsdl11Writer = new WSDL11Writer(this.wsdl);
        wsdl11Writer.write(writer, charset, resolver);
    }

    public void write(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version='1.0' encoding='UTF-8'?>");
        this.appendDefinitions(buffer, this.wsdl.getTargetNamespace());
        this.appendTypes(buffer, this.wsdl.getTargetNamespace());
        this.appendInterfaces(buffer, this.wsdl.getTargetNamespace());
        this.appendBindings(buffer, this.wsdl.getTargetNamespace());
        this.appendServices(buffer, this.wsdl.getTargetNamespace());
        buffer.append("</definitions>");
        Element element = DOMUtils.parse(buffer.toString());
        new DOMWriter(writer).setPrettyprint(true).print(element);
    }

    protected void appendDefinitions(StringBuilder buffer, String namespace) {
        buffer.append("<definitions");
        WSDLService[] services = this.wsdl.getServices();
        if (services != null && services.length == 1) {
            WSDLService ser = services[0];
            buffer.append(" name='" + ser.getName().getLocalPart() + "'");
        }
        buffer.append(" targetNamespace='" + namespace + "'");
        buffer.append(" xmlns='" + this.wsdl.getWsdlNamespace() + "'");
        Iterator it = this.wsdl.getRegisteredNamespaceURIs();
        while (it.hasNext()) {
            String namespaceURI = (String)it.next();
            String prefix = this.wsdl.getPrefix(namespaceURI);
            if (prefix.length() <= 0) continue;
            buffer.append(" xmlns:" + prefix + "='" + namespaceURI + "'");
            if (!"soap".equals(prefix)) continue;
            this.soapPrefix = prefix;
        }
        buffer.append(">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendTypes(StringBuilder buffer, String namespace) {
        WSDLTypes wsdlTypes = this.wsdl.getWsdlTypes();
        if (wsdlTypes.getNamespace() != null && !wsdlTypes.getNamespace().equals(namespace)) {
            return;
        }
        if (wsdlTypes instanceof XSModelTypes) {
            buffer.append("<types>");
            JBossXSModel xsM = WSDLUtils.getSchemaModel(wsdlTypes);
            String schema = xsM.serialize();
            buffer.append(schema);
            buffer.append("</types>");
        } else if (wsdlTypes instanceof DOMTypes) {
            WSDLTypes wSDLTypes = wsdlTypes;
            synchronized (wSDLTypes) {
                buffer.append(DOMWriter.printNode(((DOMTypes)wsdlTypes).getElement(), true));
            }
        }
    }

    protected void appendInterfaces(StringBuilder buffer, String namespace) {
    }

    protected void appendBindings(StringBuilder buffer, String namespace) {
    }

    protected void appendServices(StringBuilder buffer, String namespace) {
    }

    protected String getQNameRef(QName qname) {
        String retStr = qname.getLocalPart();
        String prefix = qname.getPrefix();
        String nsURI = qname.getNamespaceURI();
        if (prefix.length() == 0 && nsURI.length() > 0) {
            qname = this.wsdl.registerQName(qname);
            prefix = qname.getPrefix();
        }
        if (prefix.length() > 0) {
            retStr = prefix + ":" + retStr;
        }
        return retStr;
    }

    public WSDLDefinitions getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(WSDLDefinitions wsdl) {
        this.wsdl = wsdl;
    }

    public boolean isIncludeTypesInWSDL() {
        return this.includeSchemaInWSDL;
    }

    public void logException(Exception e) {
        if (log.isTraceEnabled()) {
            log.trace((Object)e);
        }
    }

    public void logMessage(String msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)msg);
        }
    }
}

