/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.login;

import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UIResetPassword
extends UIForm {
    static final String USER_NAME = "username";
    static final String PASSWORD = "password";
    static final String NEW_PASSWORD = "newpassword";
    static final String CONFIRM_NEW_PASSWORD = "confirmnewpassword";
    static User user_;

    public UIResetPassword() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER_NAME, USER_NAME, null).setEditable(false));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PASSWORD, PASSWORD, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_PASSWORD, NEW_PASSWORD, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{6, 30}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONFIRM_NEW_PASSWORD, CONFIRM_NEW_PASSWORD, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{6, 30}));
    }

    public void setData(User user) {
        user_ = user;
        this.getUIStringInput(USER_NAME).setValue((Object)user.getUserName());
    }

    public void reset() {
        UIFormStringInput passwordForm = this.getUIStringInput(PASSWORD);
        passwordForm.reset();
        UIFormStringInput newPasswordForm = this.getUIStringInput(NEW_PASSWORD);
        newPasswordForm.reset();
        UIFormStringInput confirmPasswordForm = this.getUIStringInput(CONFIRM_NEW_PASSWORD);
        confirmPasswordForm.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIResetPassword> {
        public void execute(Event<UIResetPassword> event) throws Exception {
            UIResetPassword uiForm = (UIResetPassword)((Object)event.getSource());
            String password = (String)uiForm.getUIStringInput(UIResetPassword.PASSWORD).getValue();
            String newpassword = (String)uiForm.getUIStringInput(UIResetPassword.NEW_PASSWORD).getValue();
            String confirmnewpassword = (String)uiForm.getUIStringInput(UIResetPassword.CONFIRM_NEW_PASSWORD).getValue();
            WebuiRequestContext request = event.getRequestContext();
            UIApplication uiApp = request.getUIApplication();
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            OrganizationService orgService = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            uiForm.reset();
            boolean isNew = true;
            if (!orgService.getUserHandler().authenticate(user_.getUserName(), password)) {
                uiApp.addMessage(new ApplicationMessage("UIResetPassword.msg.Invalid-account", null));
                isNew = false;
            }
            if (!newpassword.equals(confirmnewpassword)) {
                uiApp.addMessage(new ApplicationMessage("UIResetPassword.msg.password-is-not-match", null));
                isNew = false;
            }
            if (isNew) {
                user_.setPassword(newpassword);
                orgService.getUserHandler().saveUser(user_, true);
                uiMaskWorkspace.setUIComponent(null);
                uiMaskWorkspace.setWindowSize(-1, -1);
                uiApp.addMessage(new ApplicationMessage("UIResetPassword.msg.change-password-successfully", null));
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }
}

