/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.stateless.StatelessClusteredProxy;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.stateless.StatelessHandleImpl;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.RandomRobin;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

public class StatelessClusterProxyFactory
extends BaseStatelessProxyFactory
implements RemoteProxyFactory,
DistributedReplicantManager.ReplicantListener {
    private static final Logger log = Logger.getLogger(StatelessClusterProxyFactory.class);
    private RemoteBinding binding;
    private InvokerLocator locator;
    private DistributedReplicantManager drm;
    private HATarget hatarget;
    private String proxyFamilyName;
    private LoadBalancePolicy lbPolicy;
    private FamilyWrapper wrapper;
    private Object proxy;

    public void setRemoteBinding(RemoteBinding binding) {
        this.binding = binding;
    }

    protected Class[] getInterfaces() {
        Class<?>[] remoteInterfaces = ProxyFactoryHelper.getRemoteInterfaces(this.getContainer());
        Class[] interfaces = new Class[remoteInterfaces.length + 1];
        System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
        interfaces[remoteInterfaces.length] = JBossProxy.class;
        return interfaces;
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getRemoteJndiName(this.getContainer(), this.binding);
    }

    public void start() throws Exception {
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
        this.locator = new InvokerLocator(clientBindUrl);
        Clustered clustered = (Clustered)((Advisor)this.getContainer()).resolveAnnotation(Clustered.class);
        if (clustered == null) {
            throw new RuntimeException("Could not find @Clustered annotation.  Cannot deploy.");
        }
        String partitionName = ((StatelessContainer)this.getContainer()).getPartitionName();
        this.proxyFamilyName = ((StatelessContainer)this.getContainer()).getDeploymentQualifiedName() + this.locator.getProtocol() + partitionName;
        HAPartition partition = (HAPartition)this.getContainer().getInitialContext().lookup("/HAPartition/" + partitionName);
        this.hatarget = new HATarget(partition, this.proxyFamilyName, (Serializable)this.locator, 2);
        ClusteringTargetsRepository.initTarget((String)this.proxyFamilyName, (ArrayList)this.hatarget.getReplicants());
        ((StatelessContainer)this.getContainer()).getClusterFamilies().put(this.proxyFamilyName, this.hatarget);
        this.lbPolicy = clustered.loadBalancePolicy() == null || clustered.loadBalancePolicy().equals(LoadBalancePolicy.class) ? new RandomRobin() : (LoadBalancePolicy)clustered.loadBalancePolicy().newInstance();
        this.wrapper = new FamilyWrapper(this.proxyFamilyName, this.hatarget.getReplicants());
        this.drm = partition.getDistributedReplicantManager();
        this.drm.registerListener(this.proxyFamilyName, (DistributedReplicantManager.ReplicantListener)this);
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.proxy = null;
        this.hatarget.destroy();
        this.drm.unregisterListener(this.proxyFamilyName, (DistributedReplicantManager.ReplicantListener)this);
        ((StatelessContainer)this.getContainer()).getClusterFamilies().remove(this.proxyFamilyName);
    }

    public Object createProxy() {
        String stackName = "ClusteredStatelessSessionClientInterceptors";
        if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
            stackName = this.binding.interceptorStack();
        }
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        String partitionName = ((StatelessContainer)this.getContainer()).getPartitionName();
        this.proxy = this.constructProxy(new StatelessClusteredProxy(this.getContainer(), stack.createInterceptors((Advisor)this.getContainer(), null), this.wrapper, this.lbPolicy, partitionName));
        return this.proxy;
    }

    protected StatelessHandleImpl getHandle() {
        StatelessHandleImpl handle = new StatelessHandleImpl();
        RemoteBinding remoteBinding = (RemoteBinding)((Advisor)this.getContainer()).resolveAnnotation(RemoteBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
        try {
            ArrayList targets = new ArrayList(newReplicants);
            this.wrapper.get().updateClusterInfo(targets, (long)newReplicantsViewId);
            if (this.proxy != null) {
                this.bindProxy(this.proxy);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

