/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.transaction.xa.XAException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionReference;
import org.exoplatform.services.jcr.impl.core.TrackedSession;
import org.exoplatform.services.jcr.impl.core.TrackedXASession;
import org.exoplatform.services.jcr.impl.core.XASessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.transaction.TransactionService;

public class SessionFactory {
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionFactory");
    private ExoContainer container;
    private TransactionService tService;
    private String workspaceName;
    private TransactionableResourceManager txResourceManager = null;

    public SessionFactory(TransactionService tService, WorkspaceEntry config, ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
        this.workspaceName = config.getName();
        this.tService = tService;
        this.txResourceManager = new TransactionableResourceManager();
        boolean tracking = "true".equalsIgnoreCase(System.getProperty("exo.jcr.session.tracking.active", "false"));
        if (tracking) {
            long maxAgeMillis = 0L;
            String maxagevalue = System.getProperty("exo.jcr.jcr.session.tracking.maxage");
            if (maxagevalue != null) {
                try {
                    maxAgeMillis = Long.parseLong(maxagevalue) * 1000L;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (maxAgeMillis <= 0L) {
                maxAgeMillis = 120000L;
            }
            try {
                SessionReference.start(maxAgeMillis);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public SessionFactory(WorkspaceEntry config, ExoContainerContext containerContext) {
        this(null, config, containerContext);
    }

    SessionImpl createSession(ConversationState user) throws RepositoryException, LoginException {
        if (this.tService == null) {
            if (SessionReference.isStarted()) {
                return new TrackedSession(this.workspaceName, user, this.container);
            }
            return new SessionImpl(this.workspaceName, user, this.container);
        }
        XASessionImpl xaSession = SessionReference.isStarted() ? new TrackedXASession(this.workspaceName, user, this.container, this.tService, this.txResourceManager) : new XASessionImpl(this.workspaceName, user, this.container, this.tService, this.txResourceManager);
        try {
            xaSession.enlistResource();
        }
        catch (XAException e) {
            throw new RepositoryException((Throwable)e);
        }
        return xaSession;
    }
}

