/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.RepositoryException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.core.XASession;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.transaction.ExoResource;
import org.exoplatform.services.transaction.TransactionException;
import org.exoplatform.services.transaction.TransactionService;

public class XASessionImpl
extends SessionImpl
implements XASession,
XAResource,
ExoResource {
    private static final Log LOG = ExoLogger.getLogger((String)"jcr.XASessionImpl");
    private final TransactionService tService;
    private final TransactionableResourceManager txResourceManager;
    private int startFlags = 0;
    private int txTimeout;
    private Object payload;

    XASessionImpl(String workspaceName, ConversationState userState, ExoContainer container, TransactionService tService, TransactionableResourceManager txResourceManager) throws RepositoryException {
        super(workspaceName, userState, container);
        this.txTimeout = tService.getDefaultTimeout();
        this.tService = tService;
        this.txResourceManager = txResourceManager;
        this.txResourceManager.add(this);
    }

    public XAResource getXAResource() {
        return this;
    }

    public void delistResource() throws XAException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Delist session: " + this.getSessionInfo() + ", " + this));
            }
            this.tService.delistResource((ExoResource)this);
        }
        catch (RollbackException e) {
            throw new XAException(e.getMessage());
        }
        catch (SystemException e) {
            throw new XAException(e.getMessage());
        }
    }

    public void enlistResource() throws XAException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Enlist session: " + this.getSessionInfo() + ", " + this));
            }
            this.tService.enlistResource((ExoResource)this);
        }
        catch (RollbackException e) {
            throw new XAException(e.getMessage());
        }
        catch (SystemException e) {
            throw new XAException(e.getMessage());
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.txResourceManager.commit(this);
        }
        catch (TransactionException e) {
            throw new XAException(104);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Commit. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End. Xid:" + xid + ", " + flags + ", session: " + this.getSessionInfo() + ", " + this));
        }
        this.startFlags = flags;
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this.txTimeout;
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (resource instanceof XASessionImpl) {
            XASessionImpl session = (XASessionImpl)resource;
            boolean isSame = this.getUserID().equals(session.getUserID());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isSameRM: " + this.getSessionInfo() + " -- " + session.getSessionInfo() + " : " + isSame + ", " + this + " -- " + session + ", Flags:" + this.startFlags));
            }
            return isSame;
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Prepare. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
        return 0;
    }

    public Xid[] recover(int xid) throws XAException {
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        this.txResourceManager.rollback(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rollback. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            this.tService.setTransactionTimeout(seconds);
        }
        catch (SystemException e) {
            throw new XAException(e.getMessage());
        }
        this.txTimeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        this.txResourceManager.start(this);
        this.startFlags = flags;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start. Xid:" + xid + ", " + flags + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public void logout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Logout. Session: " + this.getSessionInfo() + ", " + this));
        }
        this.getTransientNodesManager().getTransactManager().rollback();
        this.txResourceManager.remove(this);
        super.logout();
        try {
            this.delistResource();
            this.startFlags = 0;
        }
        catch (XAException e) {
            LOG.error((Object)("Logut error " + e), (Throwable)e);
        }
    }

    private String getSessionInfo() {
        return this.getUserID() + "@" + this.workspaceName;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }
}

