/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.util.Map;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPPortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPRenderURL
extends WSRPPortletURL
implements RenderURL {
    private StateString navigationalState;

    protected WSRPRenderURL(Mode mode, WindowState windowState, boolean secure, StateString navigationalState) {
        super(mode, windowState, secure);
        this.navigationalState = navigationalState;
    }

    protected WSRPRenderURL() {
    }

    @Override
    protected void dealWithSpecificParams(Map<String, String> params, String originalURL) {
        super.dealWithSpecificParams(params, originalURL);
        String paramValue = this.getRawParameterValueFor(params, "wsrp-navigationalState");
        if (paramValue != null) {
            this.navigationalState = new OpaqueStateString(paramValue);
        }
    }

    @Override
    protected String getURLType() {
        return "render";
    }

    public StateString getNavigationalState() {
        return this.navigationalState;
    }

    public Map<String, String[]> getPublicNavigationalStateChanges() {
        throw new UnsupportedOperationException("getPublicNavigationalStateChanges is not currently supported!");
    }

    @Override
    protected void appendEnd(StringBuffer sb) {
        if (this.navigationalState != null) {
            this.createURLParameter(sb, "wsrp-navigationalState", this.navigationalState.getStringValue());
        }
    }
}

