/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.api.composer;

import java.util.Iterator;
import java.util.LinkedList;
import org.gatein.mop.api.composer.IterationType;
import org.gatein.mop.api.composer.StructureIterator;
import org.gatein.mop.api.workspace.ui.UIComponent;
import org.gatein.mop.api.workspace.ui.UIContainer;

public class ComponentIterator
implements StructureIterator {
    private final UIComponent root;
    private final LinkedList<ContainerVisit> stack;
    private UIComponent current;
    private IterationType type;

    public ComponentIterator(UIComponent root) {
        this.root = root;
        this.stack = new LinkedList();
        this.type = null;
    }

    public UIComponent getComponent() {
        return this.current;
    }

    public IterationType next() {
        if (this.type == null) {
            this.current = this.root;
            this.type = IterationType.START;
        } else if (this.type == IterationType.START) {
            if (this.current instanceof UIContainer) {
                UIContainer container = (UIContainer)this.current;
                Iterator iterator = container.iterator();
                if (iterator.hasNext()) {
                    this.stack.add(new ContainerVisit(container, iterator));
                    this.current = (UIComponent)iterator.next();
                } else {
                    this.type = IterationType.END;
                }
            } else {
                this.type = IterationType.END;
            }
        } else if (this.stack.size() > 0) {
            ContainerVisit visit = this.stack.getLast();
            if (visit.iterator.hasNext()) {
                this.type = IterationType.START;
                this.current = (UIComponent)visit.iterator.next();
            } else {
                this.stack.removeLast();
                this.current = visit.container;
            }
        } else {
            this.current = null;
            return IterationType.DONE;
        }
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerVisit {
        private final UIContainer container;
        private final Iterator<? extends UIComponent> iterator;

        private ContainerVisit(UIContainer container, Iterator<? extends UIComponent> iterator) {
            this.container = container;
            this.iterator = iterator;
        }
    }
}

