/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.Logger;
import org.jboss.security.jacc.DelegatingPolicy;
import org.jboss.util.state.IllegalTransitionException;
import org.jboss.util.state.State;
import org.jboss.util.state.StateMachine;

public class JBossPolicyConfiguration
implements PolicyConfiguration {
    private static Logger log = Logger.getLogger(JBossPolicyConfiguration.class);
    private String contextID;
    private DelegatingPolicy policy;
    private StateMachine configStateMachine;
    private boolean trace;

    protected JBossPolicyConfiguration(String contextID, DelegatingPolicy policy, StateMachine configStateMachine) throws PolicyContextException {
        this.contextID = contextID;
        this.policy = policy;
        this.configStateMachine = configStateMachine;
        if (contextID == null) {
            throw new IllegalArgumentException("contextID cannot be null");
        }
        if (policy == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        if (configStateMachine == null) {
            throw new IllegalArgumentException("configStateMachine cannot be null");
        }
        this.validateState("getPolicyConfiguration");
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)("ctor, contextID=" + contextID));
        }
    }

    void initPolicyConfiguration(boolean remove) throws PolicyContextException {
        this.validateState("getPolicyConfiguration");
        this.policy.initPolicyConfiguration(this.contextID, remove);
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("addToExcludedPolicy, p=" + permission));
        }
        this.validateState("addToExcludedPolicy");
        this.policy.addToExcludedPolicy(this.contextID, permission);
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("addToExcludedPolicy, pc=" + permissions));
        }
        this.validateState("addToExcludedPolicy");
        this.policy.addToExcludedPolicy(this.contextID, permissions);
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("addToRole, roleName=" + roleName + ", p=" + permission));
        }
        this.validateState("addToRole");
        this.policy.addToRole(this.contextID, roleName, permission);
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("addToRole, roleName=" + roleName + ", pc=" + permissions));
        }
        this.validateState("addToRole");
        this.policy.addToRole(this.contextID, roleName, permissions);
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("addToUncheckedPolicy, p=" + permission));
        }
        this.validateState("addToUncheckedPolicy");
        this.policy.addToUncheckedPolicy(this.contextID, permission);
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("addToUncheckedPolicy, pc=" + permissions));
        }
        this.validateState("addToUncheckedPolicy");
        this.policy.addToUncheckedPolicy(this.contextID, permissions);
    }

    public void commit() throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)"commit");
        }
        this.validateState("commit");
        this.policy.commit(this.contextID);
    }

    public void delete() throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)"delete");
        }
        this.validateState("delete");
        this.policy.delete(this.contextID);
    }

    public String getContextID() throws PolicyContextException {
        this.validateState("getContextID");
        return this.contextID;
    }

    public boolean inService() throws PolicyContextException {
        this.validateState("inService");
        State state = this.configStateMachine.getCurrentState();
        boolean inService = state.getName().equals("inService");
        return inService;
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("linkConfiguration, linkTo: " + link.getContextID()));
        }
        this.validateState("linkConfiguration");
        this.policy.linkConfiguration(this.contextID, link);
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)"removeExcludedPolicy");
        }
        this.validateState("removeExcludedPolicy");
        this.policy.removeExcludedPolicy(this.contextID);
    }

    public void removeRole(String roleName) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("removeRole: " + roleName));
        }
        this.validateState("removeRole");
        this.policy.removeRole(this.contextID, roleName);
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)"removeUncheckedPolicy");
        }
        this.validateState("removeUncheckedPolicy");
        this.policy.removeUncheckedPolicy(this.contextID);
    }

    protected void validateState(String action) throws PolicyContextException {
        try {
            this.configStateMachine.nextState(action);
        }
        catch (IllegalTransitionException e) {
            log.debug((Object)"validateState failure", (Throwable)e);
            throw new PolicyContextException("Operation not allowed", (Throwable)e);
        }
    }
}

