/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.rules;

import com.sun.faces.config.beans.RenderKitBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.config.rules.AttributeRule;
import com.sun.faces.config.rules.FeatureRule;
import org.xml.sax.Attributes;

public class RendererRule
extends FeatureRule {
    private static final String CLASS_NAME = "com.sun.faces.config.beans.RendererBean";

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        assert (this.digester.peek() instanceof RenderKitBean) : "Assertion Error: Expected RenderKitBean to be at the top of the stack";
        if (this.digester.getLogger().isDebugEnabled()) {
            this.digester.getLogger().debug("[RendererRule]{" + this.digester.getMatch() + "} Push " + CLASS_NAME);
        }
        Class<?> clazz = this.digester.getClassLoader().loadClass(CLASS_NAME);
        RendererBean cb = (RendererBean)clazz.newInstance();
        this.digester.push(cb);
    }

    public void body(String namespace, String name, String text) throws Exception {
    }

    public void end(String namespace, String name) throws Exception {
        RendererBean top = null;
        try {
            top = (RendererBean)this.digester.pop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Popped object is not a com.sun.faces.config.beans.RendererBean instance");
        }
        RenderKitBean rkb = (RenderKitBean)this.digester.peek();
        RendererBean old = rkb.getRenderer(top.getComponentFamily(), top.getRendererType());
        if (old == null) {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug("[RendererRule]{" + this.digester.getMatch() + "} New(" + top.getComponentFamily() + "," + top.getRendererType() + ")");
            }
            rkb.addRenderer(top);
        } else {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug("[RendererRule]{" + this.digester.getMatch() + "} Merge(" + top.getComponentFamily() + "," + top.getRendererType() + ")");
            }
            RendererRule.mergeRenderer(top, old);
        }
    }

    public void finish() throws Exception {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RendererRule[className=");
        sb.append(CLASS_NAME);
        sb.append("]");
        return sb.toString();
    }

    static void mergeRenderer(RendererBean top, RendererBean old) {
        if (top.getRendererClass() != null) {
            old.setRendererClass(top.getRendererClass());
        }
        if (top.isRendersChildren()) {
            old.setRendersChildren(true);
        }
        if (top.getExcludeAttributes() != null) {
            old.setExcludeAttributes(top.getExcludeAttributes());
        }
        if (top.getTagName() != null) {
            old.setTagName(top.getTagName());
        }
        AttributeRule.mergeAttributes(top, old);
        RendererRule.mergeFeatures(top, old);
    }

    static void mergeRenderers(RenderKitBean top, RenderKitBean old) {
        RendererBean[] rb = top.getRenderers();
        for (int i = 0; i < rb.length; ++i) {
            RendererBean rbo = old.getRenderer(rb[i].getComponentFamily(), rb[i].getRendererType());
            if (rbo == null) {
                old.addRenderer(rb[i]);
                continue;
            }
            RendererRule.mergeRenderer(rb[i], rbo);
        }
    }
}

