/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.util.Util;

public class SequencerFailoverTest
extends TestCase {
    JChannel ch1;
    JChannel ch2;
    JChannel ch3;
    static final String GROUP = "demo-group";
    static final int NUM_MSGS = 50;
    String props = "UDP(mcast_addr=228.8.8.8;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;enable_bundling=true;use_incoming_packet_handler=true;loopback=true):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD(timeout=2000;max_tries=2):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true;view_ack_collection_timeout=2000):SEQUENCER";

    public SequencerFailoverTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.ch1 = new JChannel(this.props);
        this.ch1.connect(GROUP);
        this.ch2 = new JChannel(this.props);
        this.ch2.connect(GROUP);
        this.ch3 = new JChannel(this.props);
        this.ch3.connect(GROUP);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.ch3 != null) {
            this.ch3.close();
            this.ch3 = null;
        }
        if (this.ch2 != null) {
            this.ch2.close();
            this.ch2 = null;
        }
    }

    public void testBroadcastSequence() throws Exception {
        new Thread(){

            public void run() {
                Util.sleepRandom(100L);
                SequencerFailoverTest.this.ch1.shutdown();
                SequencerFailoverTest.this.ch1 = null;
            }
        }.start();
        for (int i = 1; i <= 50; ++i) {
            Util.sleep(300L);
            this.ch2.send(new Message(null, null, new Integer(i)));
            System.out.print("-- messages sent: " + i + "/" + 50 + "\r");
        }
        System.out.println("");
        View view = this.ch2.getView();
        System.out.println("ch2's view is " + view);
        SequencerFailoverTest.assertEquals((int)2, (int)view.getMembers().size());
        for (int i = 10000; i > 0; i -= 1000) {
            Util.sleep(1000L);
            System.out.print("sleeping for " + i / 1000 + " seconds\r");
        }
        System.out.println("-- verifying messages on ch2 and ch3");
        System.out.println("ch2 has " + this.ch2.getNumMessages() + " messages, ch3 has " + this.ch3.getNumMessages() + " messages");
        this.verifyNumberOfMessages(50, this.ch2);
        this.verifyNumberOfMessages(50, this.ch3);
    }

    private void verifyNumberOfMessages(int num_msgs, JChannel ch) throws Exception {
        List msgs = this.getMessages(ch);
        System.out.println("list has " + msgs.size() + " msgs (should have " + 50 + ")");
        SequencerFailoverTest.assertEquals((int)num_msgs, (int)msgs.size());
        int i = 1;
        Iterator it = msgs.iterator();
        while (it.hasNext()) {
            int tmp = (Integer)it.next();
            if (tmp != i) {
                throw new Exception("expected " + i + ", but got " + tmp);
            }
            ++i;
        }
    }

    private List getMessages(JChannel ch) throws Exception {
        LinkedList<Object> retval = new LinkedList<Object>();
        while (ch.getNumMessages() > 0) {
            Object obj = ch.receive(1000L);
            if (!(obj instanceof Message)) continue;
            Message msg = (Message)obj;
            retval.add(msg.getObject());
        }
        return retval;
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{SequencerFailoverTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

