/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.pointcut.CallMatcher;
import org.jboss.aop.pointcut.ConstructionMatcher;
import org.jboss.aop.pointcut.ConstructorCallMatcher;
import org.jboss.aop.pointcut.ExecutionConstructorMatcher;
import org.jboss.aop.pointcut.ExecutionMethodMatcher;
import org.jboss.aop.pointcut.FieldGetMatcher;
import org.jboss.aop.pointcut.FieldSetMatcher;
import org.jboss.aop.pointcut.MethodCallMatcher;
import org.jboss.aop.pointcut.NewExprMatcher;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutStats;
import org.jboss.aop.pointcut.SoftClassMatcher;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;

public class PointcutExpression
implements Pointcut {
    protected String name;
    protected String expr;
    protected ASTStart ast;
    protected PointcutStats stats;

    public PointcutExpression(String name, String expr) throws ParseException {
        this.name = name;
        this.expr = expr;
        this.ast = new PointcutExpressionParser(new StringReader(expr)).Start();
    }

    public void setManager(AspectManager manager) {
        if (this.stats == null) {
            this.stats = new PointcutStats(this.ast, manager);
            this.stats.matches();
        }
    }

    public PointcutStats getStats() {
        return this.stats;
    }

    public String getName() {
        return this.name;
    }

    public String getExpr() {
        return this.expr;
    }

    public boolean softMatch(Advisor advisor) {
        SoftClassMatcher matcher = new SoftClassMatcher(advisor, advisor.getName(), this.ast);
        return matcher.matches();
    }

    public boolean matchesCall(Advisor callingAdvisor, MethodCall methodCall) throws NotFoundException {
        if (this.stats == null || this.stats.isWithin() || this.stats.isWithincode() || this.stats.isCall()) {
            MethodCallMatcher matcher = new MethodCallMatcher(callingAdvisor, methodCall, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesCall(Advisor callingAdvisor, NewExpr methodCall) throws NotFoundException {
        if (this.stats == null || this.stats.isWithin() || this.stats.isWithincode() || this.stats.isCall()) {
            NewExprMatcher matcher = new NewExprMatcher(callingAdvisor, methodCall, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesExecution(Advisor advisor, Method m) {
        return this.matchesExecution(advisor, m, false);
    }

    public boolean matchesExecution(Advisor advisor, Method m, boolean matchOnAdvisor) {
        if (this.stats == null || this.stats.isExecution()) {
            ExecutionMethodMatcher matcher = new ExecutionMethodMatcher(advisor, m, this.ast, matchOnAdvisor);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesExecution(Advisor advisor, Constructor c) {
        if (this.stats == null || this.stats.isExecution()) {
            ExecutionConstructorMatcher matcher = new ExecutionConstructorMatcher(advisor, c, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesConstruction(Advisor advisor, Constructor c) {
        if (this.stats == null || this.stats.isConstruction()) {
            ConstructionMatcher matcher = new ConstructionMatcher(advisor, c, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesGet(Advisor advisor, Field f) {
        if (this.stats == null || this.stats.isGet()) {
            FieldGetMatcher matcher = new FieldGetMatcher(advisor, f, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesSet(Advisor advisor, Field f) {
        if (this.stats == null || this.stats.isSet()) {
            FieldSetMatcher matcher = new FieldSetMatcher(advisor, f, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesExecution(Advisor advisor, CtMethod m) throws NotFoundException {
        try {
            if (this.stats == null || this.stats.isExecution()) {
                ExecutionMethodMatcher matcher = new ExecutionMethodMatcher(advisor, m, this.ast);
                return matcher.matches();
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing " + this.expr, e);
        }
    }

    public boolean matchesExecution(Advisor advisor, CtConstructor c) throws NotFoundException {
        if (this.stats == null || this.stats.isExecution()) {
            ExecutionConstructorMatcher matcher = new ExecutionConstructorMatcher(advisor, c, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesConstruction(Advisor advisor, CtConstructor c) throws NotFoundException {
        if (this.stats == null || this.stats.isConstruction()) {
            ConstructionMatcher matcher = new ConstructionMatcher(advisor, c, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesGet(Advisor advisor, CtField f) throws NotFoundException {
        if (this.stats == null || this.stats.isGet()) {
            FieldGetMatcher matcher = new FieldGetMatcher(advisor, f, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesSet(Advisor advisor, CtField f) throws NotFoundException {
        if (this.stats == null || this.stats.isSet()) {
            FieldSetMatcher matcher = new FieldSetMatcher(advisor, f, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesCall(Advisor advisor, AccessibleObject within, Class calledClass, Method calledMethod) {
        if (this.stats == null || this.stats.isWithin() || this.stats.isWithincode() || this.stats.isCall()) {
            CallMatcher matcher = new CallMatcher(advisor, within, calledClass, calledMethod, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public boolean matchesCall(Advisor advisor, AccessibleObject within, Class calledClass, Constructor calledCon) {
        if (this.stats == null || this.stats.isWithin() || this.stats.isWithincode() || this.stats.isCall()) {
            ConstructorCallMatcher matcher = new ConstructorCallMatcher(advisor, within, calledClass, calledCon, this.ast);
            return matcher.matches();
        }
        return false;
    }

    public String toString() {
        return "Pointcut[name=" + this.name + "; expr=" + this.expr + "]";
    }
}

