/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;

public class ContainerProxyCacheKey
implements Serializable {
    private static final WeakReference[] EMTPY_ARRAY = new WeakReference[0];
    private static final long serialVersionUID = 8758283842273747310L;
    WeakReference clazzRef;
    WeakReference[] addedInterfaces = EMTPY_ARRAY;
    int hashcode = 0;

    public ContainerProxyCacheKey(Class clazz) {
        this.clazzRef = new WeakReference<Class>(clazz);
    }

    public ContainerProxyCacheKey(Class clazz, Class[] addedInterfaces) {
        this.clazzRef = new WeakReference<Class>(clazz);
        this.populateAddedInterfaces(addedInterfaces);
    }

    private void populateAddedInterfaces(Class[] addedIfaces) {
        if (addedIfaces == null) {
            return;
        }
        this.addedInterfaces = new WeakReference[addedIfaces.length];
        for (int i = 0; i < addedIfaces.length; ++i) {
            this.addedInterfaces[i] = new WeakReference<Class>(addedIfaces[i]);
        }
        Arrays.sort(this.addedInterfaces, Alphabetical.singleton);
    }

    public Class getClazz() {
        Class clazz = (Class)this.clazzRef.get();
        if (clazz != null) {
            return clazz;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ContainerProxyCacheKey.class) {
            return false;
        }
        ContainerProxyCacheKey other = (ContainerProxyCacheKey)obj;
        Class thisClass = (Class)this.clazzRef.get();
        Class otherClass = (Class)other.clazzRef.get();
        if (thisClass == null || otherClass == null) {
            return false;
        }
        if (!thisClass.equals(otherClass)) {
            return false;
        }
        if (this.addedInterfaces == null && other.addedInterfaces != null || this.addedInterfaces == null && other.addedInterfaces != null) {
            return false;
        }
        if (this.addedInterfaces != null && other.addedInterfaces != null) {
            if (this.addedInterfaces.length != other.addedInterfaces.length) {
                return false;
            }
            for (int i = 0; i < this.addedInterfaces.length; ++i) {
                Class otherIf;
                Class thisIf = (Class)this.addedInterfaces[i].get();
                if (thisIf.equals(otherIf = (Class)other.addedInterfaces[i].get())) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            Class clazz = (Class)this.clazzRef.get();
            StringBuffer sb = new StringBuffer();
            if (clazz != null) {
                sb.append(clazz.getName());
            }
            if (this.addedInterfaces != null) {
                for (int i = 0; i < this.addedInterfaces.length; ++i) {
                    sb.append(";");
                    sb.append(((Class)this.addedInterfaces[i].get()).getName());
                }
            }
            this.hashcode = sb.toString().hashCode();
        }
        return this.hashcode;
    }

    public String toString() {
        Class clazz = (Class)this.clazzRef.get();
        return clazz + ";" + Arrays.asList(this.addedInterfaces);
    }

    static class Alphabetical
    implements Comparator {
        static Alphabetical singleton = new Alphabetical();

        Alphabetical() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((Class)((WeakReference)o1).get()).getName();
            String name2 = ((Class)((WeakReference)o2).get()).getName();
            return name1.compareTo(name2);
        }
    }
}

