/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import javax.transaction.Synchronization;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.util.WeakIdentityHashMap;

public class PostTransactionWorkQueueSynchronization
implements Synchronization {
    private WorkQueue workQueue;
    private boolean consumed;
    private WeakIdentityHashMap queuePerTransaction;

    public PostTransactionWorkQueueSynchronization(WorkQueue workQueue) {
        this.workQueue = workQueue;
    }

    public PostTransactionWorkQueueSynchronization(WorkQueue workQueue, WeakIdentityHashMap queuePerTransaction) {
        this(workQueue);
        this.queuePerTransaction = queuePerTransaction;
    }

    public void add(Work work) {
        this.workQueue.add(work);
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                this.workQueue.performWork();
            } else {
                this.workQueue.cancelWork();
            }
        }
        finally {
            this.consumed = true;
            if (this.queuePerTransaction != null) {
                this.queuePerTransaction.removeValue(this);
            }
        }
    }
}

