/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.exoplatform.container.CachingContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.jmx.ManageableComponentAdapterFactory;
import org.exoplatform.container.jmx.ManagementContextImpl;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageableContainer
extends CachingContainer {
    private static final ThreadLocal<ManageableComponentAdapterFactory> hack = new ThreadLocal();
    protected ManagementContextImpl managementContext;

    public ManageableContainer(ManagementContextImpl managementContext) {
        super(ManageableContainer.getComponentAdapterFactory(new MX4JComponentAdapterFactory()));
        this.managementContext = managementContext;
        managementContext.container = this;
        this.init(null);
    }

    public ManageableContainer(PicoContainer parent) {
        super(ManageableContainer.getComponentAdapterFactory(new MX4JComponentAdapterFactory()), parent);
        this.init(parent);
    }

    public ManageableContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        super(ManageableContainer.getComponentAdapterFactory(componentAdapterFactory), parent);
        this.init(parent);
    }

    public ManageableContainer(ComponentAdapterFactory componentAdapterFactory) {
        super(ManageableContainer.getComponentAdapterFactory(componentAdapterFactory));
        this.init(null);
    }

    @Managed
    @ManagedName(value="RegisteredComponentNames")
    @ManagedDescription(value="Return the list of the registered component names")
    public Set<String> getRegisteredComponentNames() throws PicoException {
        HashSet<String> names = new HashSet<String>();
        Collection adapters = this.getComponentAdapters();
        for (ComponentAdapter adapter : adapters) {
            Object key = adapter.getComponentKey();
            String name = String.valueOf(key);
            names.add(name);
        }
        return names;
    }

    private static ManageableComponentAdapterFactory getComponentAdapterFactory(ComponentAdapterFactory componentAdapterFactory) {
        ManageableComponentAdapterFactory factory = new ManageableComponentAdapterFactory(componentAdapterFactory);
        hack.set(factory);
        return factory;
    }

    private void init(PicoContainer parent) {
        ManagementContextImpl parentManagementContext;
        ManageableComponentAdapterFactory factory = hack.get();
        factory.container = this;
        hack.set(null);
        if (parent instanceof ManageableContainer && (parentManagementContext = ((ManageableContainer)parent).managementContext) != null) {
            this.managementContext = new ManagementContextImpl(parentManagementContext);
            this.managementContext.container = this;
        }
    }

    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    public final MBeanServer getMBeanServer() {
        return this.managementContext != null ? this.managementContext.server : null;
    }

    @Override
    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        return super.registerComponent(componentAdapter);
    }

    @Override
    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        ComponentAdapter adapter = super.registerComponentInstance(componentKey, componentInstance);
        if (this.managementContext != null) {
            this.managementContext.register(componentInstance);
        }
        return adapter;
    }

    public void printMBeanServer() {
        MBeanServer server = this.getMBeanServer();
        Set<ObjectName> names = server.queryNames(null, null);
        for (ObjectName name : names) {
            try {
                MBeanInfo info = server.getMBeanInfo(name);
                MBeanAttributeInfo[] attrs = info.getAttributes();
                if (attrs == null) continue;
                for (int j = 0; j < attrs.length; ++j) {
                    if (!attrs[j].isReadable()) continue;
                    try {
                        Object o = server.getAttribute(name, attrs[j].getName());
                        continue;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                MBeanOperationInfo[] methods = info.getOperations();
                for (int j = 0; j < methods.length; ++j) {
                    MBeanParameterInfo[] params = methods[j].getSignature();
                    for (int k = 0; k < params.length; ++k) {
                    }
                }
            }
            catch (Exception x) {
            }
        }
    }
}

