/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.webui.config.Application;
import org.exoplatform.webui.config.Component;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.config.EventInterceptor;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.Validator;
import org.exoplatform.webui.config.WebuiConfiguration;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.EventInterceptorConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.config.annotation.ValidatorConfig;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager {
    private Map<String, Component> configs_ = new HashMap<String, Component>();
    private Application application_;

    public ConfigurationManager(InputStream inputStream) throws Exception {
        IBindingFactory bfact = BindingDirectory.getFactory(WebuiConfiguration.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        WebuiConfiguration config = (WebuiConfiguration)uctx.unmarshalDocument(inputStream, null);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (config.getAnnotationClasses() != null) {
            for (String annotationClass : config.getAnnotationClasses()) {
                Component[] components = this.annotationToComponents(cl, annotationClass);
                this.setComponentConfigs(components);
            }
        }
        if (config.getComponents() != null) {
            for (Component component : config.getComponents()) {
                String key = component.getType();
                if (component.getId() != null) {
                    key = key + ":" + component.getId();
                }
                this.configs_.put(key, component);
            }
        }
        this.application_ = config.getApplication();
    }

    void setComponentConfigs(Component[] configs) {
        for (Component component : configs) {
            String key = component.getType();
            if (component.getId() != null) {
                key = key + ":" + component.getId();
            }
            this.configs_.put(key, component);
        }
    }

    public List<Component> getComponentConfig(Class<?> clazz) {
        ArrayList<Component> configs = new ArrayList<Component>();
        Collection<Component> values = this.configs_.values();
        String type = clazz.getName();
        for (Component comp : values) {
            if (!comp.getType().equals(type)) continue;
            configs.add(comp);
        }
        return configs;
    }

    public Component getComponentConfig(Class<?> type, String id) {
        Component config;
        String key = type.getName();
        if (id != null) {
            key = key + ":" + id;
        }
        if ((config = this.configs_.get(key)) != null) {
            return config;
        }
        try {
            Component[] components = this.annotationToComponents(type);
            this.setComponentConfigs(components);
            return this.configs_.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Application getApplication() {
        return this.application_;
    }

    Component[] annotationToComponents(ClassLoader cl, String annClass) throws Exception {
        Class<?> clazz = cl.loadClass(annClass);
        return this.annotationToComponents(clazz);
    }

    Component[] annotationToComponents(Class<?> clazz) throws Exception {
        ComponentConfig annotation = clazz.getAnnotation(ComponentConfig.class);
        if (annotation != null) {
            return new Component[]{this.toComponentConfig(annotation, clazz)};
        }
        ComponentConfigs annotations = clazz.getAnnotation(ComponentConfigs.class);
        if (annotations != null) {
            ComponentConfig[] listAnnotations = annotations.value();
            Component[] componentConfigs = new Component[listAnnotations.length];
            for (int i = 0; i < componentConfigs.length; ++i) {
                componentConfigs[i] = this.toComponentConfig(listAnnotations[i], clazz);
            }
            return componentConfigs;
        }
        return new Component[0];
    }

    private Component toComponentConfig(ComponentConfig annotation, Class<?> clazz) throws Exception {
        Component config = new Component();
        if (annotation.id().length() > 0) {
            config.setId(annotation.id());
        }
        Class type = annotation.type() == Void.TYPE ? clazz : annotation.type();
        config.setType(type.getName());
        if (annotation.template().length() > 0) {
            config.setTemplate(annotation.template());
        }
        if (annotation.lifecycle() != Void.TYPE) {
            config.setLifecycle(annotation.lifecycle().getName());
        }
        if (annotation.decorator().length() > 0) {
            config.setDecorator(annotation.decorator());
        }
        config.setInitParams(this.toInitParams(annotation.initParams()));
        EventConfig[] eventAnnotations = annotation.events();
        ArrayList<Event> events = new ArrayList<Event>();
        for (EventConfig eventAnnotation : eventAnnotations) {
            events.add(this.toEventConfig(eventAnnotation));
        }
        config.setEvents(events);
        EventInterceptorConfig[] eventInterceptorAnnotations = annotation.eventInterceptors();
        ArrayList<EventInterceptor> eventInterceptors = new ArrayList<EventInterceptor>();
        for (EventInterceptorConfig eventAnnotation : eventInterceptorAnnotations) {
            eventInterceptors.add(this.toEventInterceptorConfig(eventAnnotation));
        }
        config.setEventInterceptors(eventInterceptors);
        ValidatorConfig[] validatorAnnotations = annotation.validators();
        ArrayList<Validator> validators = new ArrayList<Validator>();
        for (ValidatorConfig ele : validatorAnnotations) {
            validators.add(this.toValidator(ele));
        }
        config.setValidators(validators);
        return config;
    }

    private Event toEventConfig(EventConfig annotation) throws Exception {
        Event event = new Event();
        event.setExecutionPhase(annotation.phase());
        event.setConfirm(annotation.confirm());
        event.setInitParams(this.toInitParams(annotation.initParams()));
        ArrayList<String> listeners = new ArrayList<String>();
        for (Class clazz : annotation.listeners()) {
            listeners.add(clazz.getName());
        }
        if (annotation.name().length() > 0) {
            event.setName(annotation.name());
        } else if (annotation.listeners().length > 0) {
            String name = annotation.listeners()[0].getSimpleName();
            int idx = name.indexOf("ActionListener");
            if (idx > -1) {
                name = name.substring(0, idx);
            }
            event.setName(name);
        }
        event.setListeners(listeners);
        return event;
    }

    private EventInterceptor toEventInterceptorConfig(EventInterceptorConfig annotation) throws Exception {
        EventInterceptor eventInterceptor = new EventInterceptor();
        eventInterceptor.setType(annotation.type().getName());
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, annotation.interceptors());
        eventInterceptor.setInterceptors(list);
        eventInterceptor.setInitParams(this.toInitParams(annotation.initParams()));
        return eventInterceptor;
    }

    private Validator toValidator(ValidatorConfig annotation) throws Exception {
        Validator validator = new Validator();
        validator.setType(annotation.type().getName());
        validator.setInitParams(this.toInitParams(annotation.initParams()));
        return validator;
    }

    private InitParams toInitParams(ParamConfig[] annotations) {
        if (annotations == null || annotations.length < 1) {
            return null;
        }
        ArrayList<Param> listParam = new ArrayList<Param>();
        for (ParamConfig ele : annotations) {
            Param param = new Param();
            param.setName(ele.name());
            param.setValue(ele.value());
            listParam.add(param);
        }
        InitParams initParams = new InitParams();
        initParams.setParams(listParam);
        return initParams;
    }
}

