/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIContainer
extends UIComponent {
    private List<UIComponent> children;

    public boolean hasChildren() {
        return this.children != null;
    }

    public void setChildren(List<UIComponent> ls) {
        this.children = ls;
    }

    public List<UIComponent> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<UIComponent>(3);
        }
        return this.children;
    }

    public void addChild(UIComponent uicomponent) {
        if (this.children == null) {
            this.children = new ArrayList<UIComponent>(3);
        }
        uicomponent.setParent(this);
        this.children.add(uicomponent);
    }

    public UIComponent removeChildById(String id) {
        if (this.children == null) {
            return null;
        }
        for (UIComponent child : this.children) {
            if (!id.equals(child.getId())) continue;
            child.setParent(null);
            this.children.remove(child);
            return child;
        }
        return null;
    }

    public <T extends UIComponent> T removeChild(Class<T> clazz) {
        if (this.children == null) {
            return null;
        }
        for (UIComponent child : this.children) {
            if (!clazz.isInstance(child)) continue;
            child.setParent(null);
            this.children.remove(child);
            return (T)((UIComponent)clazz.cast(child));
        }
        return null;
    }

    public <T extends UIComponent> T getChildById(String id) {
        if (this.children == null) {
            return null;
        }
        for (UIComponent child : this.children) {
            if (!id.equals(child.getId())) continue;
            return (T)child;
        }
        return null;
    }

    public <T extends UIComponent> T getChild(int idx) {
        if (this.children == null) {
            return null;
        }
        if (this.children.size() <= idx) {
            return null;
        }
        return (T)this.children.get(idx);
    }

    public <T extends UIComponent> T getChild(Class<T> clazz) {
        if (this.children == null) {
            return null;
        }
        for (UIComponent uichild : this.children) {
            if (!clazz.isInstance(uichild)) continue;
            return (T)((UIComponent)clazz.cast(uichild));
        }
        return null;
    }

    public <T extends UIComponent> T replaceChild(String targetChildId, UIComponent newComponent) throws Exception {
        if (this.children == null) {
            throw new Exception("Cannot  find the child : " + targetChildId);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            UIComponent child = this.children.get(i);
            if (!targetChildId.equals(child.getId())) continue;
            child.setParent(null);
            newComponent.setParent(this);
            this.children.set(i, newComponent);
            return (T)child;
        }
        throw new Exception("Cannot  find the child : " + targetChildId);
    }

    public <T extends UIComponent> T replaceChild(String targetChildId, Class<T> type, String configId, String id) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        WebuiApplication app = (WebuiApplication)context.getApplication();
        T comp = app.createUIComponent(type, configId, id, context);
        comp = this.replaceChild(targetChildId, (UIComponent)comp);
        return (T)((UIComponent)type.cast(comp));
    }

    public <T extends UIComponent> T addChild(Class<T> type, String configId, String id) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        WebuiApplication app = (WebuiApplication)context.getApplication();
        T comp = app.createUIComponent(type, configId, id, context);
        this.addChild((UIComponent)comp);
        return comp;
    }

    @Override
    public <T extends UIComponent> T findComponentById(String id) {
        if (this.getId() != null && this.getId().equals(id)) {
            return (T)this;
        }
        if (this.children == null) {
            return null;
        }
        for (UIComponent uichild : this.children) {
            Object found = uichild.findComponentById(id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public <T extends UIComponent> T findFirstComponentOfType(Class<T> type) {
        if (type.isInstance(this)) {
            return (T)((UIComponent)type.cast(this));
        }
        if (this.children == null) {
            return null;
        }
        for (UIComponent uichild : this.children) {
            T found = uichild.findFirstComponentOfType(type);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public <T> void findComponentOfType(List<T> list, Class<T> type) {
        if (type.isInstance(this) && !list.contains(this)) {
            list.add(type.cast(this));
        }
        if (this.children == null) {
            return;
        }
        for (UIComponent uichild : this.children) {
            uichild.findComponentOfType(list, type);
        }
    }

    public void setRenderedChild(String id) {
        List<UIComponent> list = this.getChildren();
        for (UIComponent child : list) {
            if (child.getId().equals(id)) {
                child.setRendered(true);
                continue;
            }
            child.setRendered(false);
        }
    }

    public <T extends UIComponent> void setRenderedChild(Class<T> type) {
        List<UIComponent> list = this.getChildren();
        for (UIComponent child : list) {
            if (type.isInstance(child)) {
                child.setRendered(true);
                continue;
            }
            child.setRendered(false);
        }
    }

    public void setRenderedChildrenOfTypes(Class<?>[] types) {
        List<UIComponent> list = this.getChildren();
        block0: for (UIComponent child : list) {
            child.setRendered(false);
            for (Class<?> type : types) {
                if (!type.isInstance(child)) continue;
                child.setRendered(true);
                continue block0;
            }
        }
    }

    public void renderChild(String id) throws Exception {
        this.renderChild((UIComponent)this.getChildById(id));
    }

    public <T extends UIComponent> void renderChild(Class<T> clazz) throws Exception {
        this.renderChild((UIComponent)this.getChild(clazz));
    }

    public void renderUIComponent(UIComponent uicomponent) throws Exception {
        uicomponent.processRender((WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
    }

    public void renderChild(int index) throws Exception {
        this.renderChild((UIComponent)this.getChild(index));
    }

    public void renderChild(UIComponent child) throws Exception {
        if (child.isRendered()) {
            child.processRender((WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
        }
    }

    public void renderChildren() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.renderChildren(context);
    }

    public void renderChildren(WebuiRequestContext context) throws Exception {
        List<UIComponent> list = this.getChildren();
        for (UIComponent child : list) {
            if (!child.isRendered()) continue;
            child.processRender(context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectTabActionListener
    extends EventListener<UIContainer> {
        @Override
        public void execute(Event<UIContainer> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIContainer uiContainer = event.getSource();
            String renderTab = context.getRequestParameter("objectId");
            if (renderTab == null) {
                return;
            }
            Object uiComp = uiContainer.findComponentById(renderTab);
            if (uiComp != null) {
                for (UIComponent child : uiContainer.getChildren()) {
                    child.setRendered(false);
                }
                ((UIComponent)uiComp).setRendered(true);
            }
        }
    }
}

