/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.referenceable.ObjectRefAddr;

public class SpyConnectionFactory
implements Serializable,
ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable {
    static final long serialVersionUID = 3392566934963731105L;
    protected GenericConnectionFactory factory;

    public SpyConnectionFactory(GenericConnectionFactory factory) {
        this.factory = factory;
    }

    public SpyConnectionFactory(Properties config) {
        this.factory = new GenericConnectionFactory(null, config);
    }

    public Properties getProperties() {
        if (this.factory == null) {
            return null;
        }
        return this.factory.getProperties();
    }

    public Reference getReference() throws NamingException {
        return new Reference("org.jboss.mq.SpyConnectionFactory", new ObjectRefAddr("DCF", this.factory), "org.jboss.mq.referenceable.SpyConnectionFactoryObjectFactory", null);
    }

    public Connection createConnection() throws JMSException {
        return this.internalCreateConnection(0);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.internalCreateConnection(0, userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.internalCreateConnection(1);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.internalCreateConnection(1, userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.internalCreateConnection(2);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.internalCreateConnection(2, userName, password);
    }

    protected Connection internalCreateConnection(int type) throws JMSException {
        try {
            return new SpyConnection(type, this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("Failed to create Connection", e);
        }
    }

    protected Connection internalCreateConnection(int type, String userName, String password) throws JMSException {
        try {
            if (userName == null) {
                throw new SpyJMSException("Username is null");
            }
            if (password == null) {
                throw new SpyJMSException("Password is null");
            }
            return new SpyConnection(type, userName, password, this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("Failed to create Connection", e);
        }
    }
}

