/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS;
import org.jboss.ws.core.jaxws.handler.LogicalMessageContextImpl;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainExecutor {
    private static Logger log = Logger.getLogger(HandlerChainExecutor.class);
    private EndpointMetaData epMetaData;
    protected List<Handler> handlers = new ArrayList<Handler>();
    protected List<Handler> executedHandlers = new ArrayList<Handler>();
    protected int falseIndex = -1;
    protected Boolean isOutbound;

    public HandlerChainExecutor(EndpointMetaData epMetaData, List<Handler> unsortedChain) {
        this.epMetaData = epMetaData;
        ArrayList<Handler> sortedChain = new ArrayList<Handler>();
        for (Handler handler : unsortedChain) {
            if (!(handler instanceof LogicalHandler)) continue;
            sortedChain.add(handler);
        }
        for (Handler handler : unsortedChain) {
            if (handler instanceof LogicalHandler) continue;
            sortedChain.add(handler);
        }
        log.debug((Object)("Create a handler executor: " + sortedChain));
        for (Handler handler : sortedChain) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(MessageContext msgContext) {
        log.debug((Object)"close");
        MessageContextJAXWS context = (MessageContextJAXWS)msgContext;
        for (int index = 1; index <= this.executedHandlers.size(); ++index) {
            Handler currHandler = this.executedHandlers.get(this.executedHandlers.size() - index);
            try {
                context.setCurrentScope(MessageContext.Scope.HANDLER);
                currHandler.close(msgContext);
                continue;
            }
            finally {
                context.setCurrentScope(MessageContext.Scope.APPLICATION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(MessageContext msgContext) {
        this.isOutbound = (Boolean)msgContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (this.isOutbound == null) {
            throw new IllegalStateException("Cannot find property: javax.xml.ws.handler.message.outbound");
        }
        boolean doNext = true;
        if (this.handlers.size() > 0) {
            block11: {
                log.debug((Object)("Enter: handle" + (this.isOutbound != false ? "Out" : "In ") + "BoundMessage"));
                int index = this.getFirstHandler();
                Handler currHandler = null;
                try {
                    String lastMessageTrace = null;
                    while (doNext && index >= 0) {
                        SOAPPart soapPart;
                        currHandler = this.handlers.get(index);
                        if (log.isTraceEnabled() && msgContext instanceof SOAPMessageContext) {
                            soapPart = ((SOAPMessageContext)msgContext).getMessage().getSOAPPart();
                            lastMessageTrace = this.traceSOAPPart("BEFORE handleRequest - " + currHandler, soapPart, lastMessageTrace);
                        }
                        doNext = this.handleMessage(currHandler, msgContext);
                        if (log.isTraceEnabled() && msgContext instanceof SOAPMessageContext) {
                            soapPart = ((SOAPMessageContext)msgContext).getMessage().getSOAPPart();
                            lastMessageTrace = this.traceSOAPPart("AFTER handleRequest - " + currHandler, soapPart, lastMessageTrace);
                        }
                        if (!doNext) continue;
                        index = this.getNextIndex(index);
                    }
                    if (doNext) break block11;
                    this.falseIndex = index;
                }
                catch (RuntimeException ex) {
                    try {
                        doNext = false;
                        this.processHandlerFailure(ex);
                        if (!doNext) {
                            this.falseIndex = index;
                        }
                        log.debug((Object)("Exit: handle" + (this.isOutbound != false ? "Out" : "In ") + "BoundMessage with status: " + doNext));
                    }
                    catch (Throwable throwable) {
                        if (!doNext) {
                            this.falseIndex = index;
                        }
                        log.debug((Object)("Exit: handle" + (this.isOutbound != false ? "Out" : "In ") + "BoundMessage with status: " + doNext));
                        throw throwable;
                    }
                }
            }
            log.debug((Object)("Exit: handle" + (this.isOutbound != false ? "Out" : "In ") + "BoundMessage with status: " + doNext));
        }
        return doNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFault(MessageContext msgContext, Exception ex) {
        this.isOutbound = (Boolean)msgContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (this.isOutbound == null) {
            throw new IllegalStateException("Cannot find property: javax.xml.ws.handler.message.outbound");
        }
        boolean doNext = true;
        if (this.handlers.size() > 0) {
            log.debug((Object)("Enter: handle" + (this.isOutbound != false ? "Out" : "In ") + "BoundFault"));
            if (msgContext instanceof SOAPMessageContext) {
                SOAPMessageContext soapContext = (SOAPMessageContext)msgContext;
                SOAPMessage soapMessage = soapContext.getMessage();
                try {
                    if (soapMessage == null || soapMessage.getSOAPBody().getFault() == null) {
                        soapMessage = SOAPFaultHelperJAXWS.exceptionToFaultMessage(ex);
                        soapContext.setMessage(soapMessage);
                    }
                }
                catch (SOAPException se) {
                    throw new WebServiceException("Cannot convert exception to fault message", (Throwable)ex);
                }
            }
            int index = this.getFirstHandler();
            Handler currHandler = null;
            try {
                String lastMessageTrace = null;
                while (doNext && index >= 0) {
                    SOAPPart soapPart;
                    currHandler = this.handlers.get(index);
                    if (log.isTraceEnabled() && msgContext instanceof SOAPMessageContext) {
                        soapPart = ((SOAPMessageContext)msgContext).getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart("BEFORE handleFault - " + currHandler, soapPart, lastMessageTrace);
                    }
                    doNext = this.handleFault(currHandler, msgContext);
                    if (log.isTraceEnabled() && msgContext instanceof SOAPMessageContext) {
                        soapPart = ((SOAPMessageContext)msgContext).getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart("AFTER handleFault - " + currHandler, soapPart, lastMessageTrace);
                    }
                    index = this.getNextIndex(index);
                }
            }
            catch (RuntimeException rte) {
                try {
                    doNext = false;
                    this.processHandlerFailure(rte);
                    log.debug((Object)("Exit: handle" + (this.isOutbound != false ? "Out" : "In ") + "BoundFault with status: " + doNext));
                }
                catch (Throwable throwable) {
                    log.debug((Object)("Exit: handle" + (this.isOutbound != false ? "Out" : "In ") + "BoundFault with status: " + doNext));
                    throw throwable;
                }
            }
            log.debug((Object)("Exit: handle" + (this.isOutbound != false ? "Out" : "In ") + "BoundFault with status: " + doNext));
        }
        return doNext;
    }

    private int getFirstHandler() {
        int index = this.falseIndex == -1 ? (this.isOutbound != false ? 0 : this.handlers.size() - 1) : this.getNextIndex(this.falseIndex);
        return index;
    }

    private int getNextIndex(int prevIndex) {
        int nextIndex;
        int n = nextIndex = this.isOutbound != false ? prevIndex + 1 : prevIndex - 1;
        if (nextIndex >= this.handlers.size()) {
            nextIndex = -1;
        }
        return nextIndex;
    }

    private void processHandlerFailure(Exception ex) {
        log.error((Object)"Exception during handler processing", (Throwable)ex);
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)ex;
        }
        throw new WebServiceException((Throwable)ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMessage(Handler currHandler, MessageContext msgContext) {
        CommonMessageContext context = (CommonMessageContext)msgContext;
        if (currHandler instanceof LogicalHandler && msgContext instanceof SOAPMessageContextJAXWS) {
            msgContext = new LogicalMessageContextImpl((SOAPMessageContextJAXWS)msgContext);
        }
        if (!this.executedHandlers.contains(currHandler)) {
            this.executedHandlers.add(currHandler);
        }
        try {
            context.put(MessageContextJAXWS.ALLOW_EXPAND_TO_DOM, (Object)Boolean.TRUE);
            context.setCurrentScope(MessageContext.Scope.HANDLER);
            boolean bl = currHandler.handleMessage(msgContext);
            return bl;
        }
        finally {
            context.setCurrentScope(MessageContext.Scope.APPLICATION);
            context.remove(MessageContextJAXWS.ALLOW_EXPAND_TO_DOM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleFault(Handler currHandler, MessageContext msgContext) {
        CommonMessageContext context = (CommonMessageContext)msgContext;
        if (currHandler instanceof LogicalHandler && msgContext instanceof SOAPMessageContextJAXWS) {
            msgContext = new LogicalMessageContextImpl((SOAPMessageContextJAXWS)msgContext);
        }
        if (!this.executedHandlers.contains(currHandler)) {
            this.executedHandlers.add(currHandler);
        }
        try {
            context.put(MessageContextJAXWS.ALLOW_EXPAND_TO_DOM, (Object)Boolean.TRUE);
            context.setCurrentScope(MessageContext.Scope.HANDLER);
            boolean bl = currHandler.handleFault(msgContext);
            return bl;
        }
        finally {
            context.setCurrentScope(MessageContext.Scope.APPLICATION);
            context.remove(MessageContextJAXWS.ALLOW_EXPAND_TO_DOM);
        }
    }

    protected String traceSOAPPart(String logMsg, SOAPPart soapPart, String lastMessageTrace) {
        try {
            SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)soapPart.getEnvelope();
            String envString = DOMWriter.printNode((Node)((Object)soapEnv), (boolean)true);
            if (envString.equals(lastMessageTrace)) {
                log.trace((Object)(logMsg + ": unchanged"));
            } else {
                log.trace((Object)(logMsg + "\n" + envString));
                lastMessageTrace = envString;
            }
            return lastMessageTrace;
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot get SOAPEnvelope", (Throwable)e);
            return null;
        }
    }
}

