/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.impl;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.exoplatform.services.database.impl.AddHibernateMappingPlugin;
import org.exoplatform.services.database.impl.ExoCacheProvider;
import org.exoplatform.services.database.impl.HibernateConfigurationImpl;
import org.exoplatform.services.database.impl.HibernateSettingsFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class HibernateServiceImpl
implements HibernateService,
ComponentRequestLifecycle {
    private ThreadLocal<Session> threadLocal_;
    private static Log log_ = ExoLogger.getLogger(HibernateServiceImpl.class);
    private HibernateConfigurationImpl conf_;
    private SessionFactory sessionFactory_;
    private HashSet<String> mappings_ = new HashSet();

    public HibernateServiceImpl(InitParams initParams, CacheService cacheService) {
        this.threadLocal_ = new ThreadLocal();
        PropertiesParam param = initParams.getPropertiesParam("hibernate.properties");
        HibernateSettingsFactory settingsFactory = new HibernateSettingsFactory(new ExoCacheProvider(cacheService));
        this.conf_ = new HibernateConfigurationImpl(settingsFactory);
        Iterator properties = param.getPropertyIterator();
        while (properties.hasNext()) {
            Property p = (Property)properties.next();
            String name = p.getName();
            String value = p.getValue();
            if (name.equals("hibernate.dialect")) {
                Package pkg = Dialect.class.getPackage();
                String dialect = value.substring(22);
                value = pkg.getName() + "." + dialect;
                log_.info((Object)("Using dialect " + dialect));
            }
            this.conf_.setProperty(name, value);
        }
        String connectionURL = this.conf_.getProperty("hibernate.connection.url");
        if (connectionURL != null) {
            connectionURL = connectionURL.replace("${java.io.tmpdir}", System.getProperty("java.io.tmpdir"));
            this.conf_.setProperty("hibernate.connection.url", connectionURL);
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddHibernateMappingPlugin) {
            AddHibernateMappingPlugin impl = (AddHibernateMappingPlugin)plugin;
            try {
                List<String> annotations;
                List path = impl.getMapping();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (path != null) {
                    for (int i = 0; i < path.size(); ++i) {
                        String relativePath = (String)path.get(i);
                        if (this.mappings_.contains(relativePath)) continue;
                        this.mappings_.add(relativePath);
                        URL url = cl.getResource(relativePath);
                        log_.info((Object)("Adding  Hibernate Mapping: " + relativePath));
                        this.conf_.addURL(url);
                    }
                }
                if ((annotations = impl.getAnnotations()) != null) {
                    for (String annotation : annotations) {
                        Class<?> clazz = cl.loadClass(annotation);
                        this.conf_.addAnnotatedClass(clazz);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ComponentPlugin removePlugin(String name) {
        return null;
    }

    public Collection getPlugins() {
        return null;
    }

    public Configuration getHibernateConfiguration() {
        return this.conf_;
    }

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory_ == null) {
            this.sessionFactory_ = this.conf_.buildSessionFactory();
            new SchemaUpdate((Configuration)this.conf_).execute(false, true);
        }
        return this.sessionFactory_;
    }

    public Session openSession() {
        Session currentSession = this.threadLocal_.get();
        if (currentSession == null) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"open new hibernate session in openSession()");
            }
            currentSession = this.getSessionFactory().openSession();
            this.threadLocal_.set(currentSession);
        }
        return currentSession;
    }

    public Session openNewSession() {
        Session currentSession = this.threadLocal_.get();
        if (currentSession != null) {
            this.closeSession(currentSession);
        }
        currentSession = this.getSessionFactory().openSession();
        this.threadLocal_.set(currentSession);
        return currentSession;
    }

    public void closeSession(Session session) {
        if (session == null) {
            return;
        }
        try {
            session.close();
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"close hibernate session in openSession(Session session)");
            }
        }
        catch (Throwable t) {
            log_.error((Object)("Error closing hibernate session : " + t.getMessage()), t);
        }
        this.threadLocal_.set(null);
    }

    public final void closeSession() {
        Session s = this.threadLocal_.get();
        if (s != null) {
            s.close();
        }
        this.threadLocal_.set(null);
    }

    public Object findExactOne(Session session, String query, String id) throws Exception {
        Object res = session.createQuery(query).setString(0, id).uniqueResult();
        if (res == null) {
            throw new ObjectNotFoundException("Cannot find the object with id: " + id);
        }
        return res;
    }

    public Object findOne(Session session, String query, String id) throws Exception {
        List l = session.createQuery(query).setString(0, id).list();
        if (l.size() == 0) {
            return null;
        }
        if (l.size() > 1) {
            throw new Exception("Expect only one object but found" + l.size());
        }
        return l.get(0);
    }

    public Object findOne(Class clazz, Serializable id) throws Exception {
        Session session = this.openSession();
        Object obj = session.get(clazz, id);
        return obj;
    }

    public Object findOne(ObjectQuery q) throws Exception {
        Session session = this.openSession();
        List l = session.createQuery(q.getHibernateQuery()).list();
        if (l.size() == 0) {
            return null;
        }
        if (l.size() > 1) {
            throw new Exception("Expect only one object but found" + l.size());
        }
        return l.get(0);
    }

    public Object create(Object obj) throws Exception {
        Session session = this.openSession();
        session.save(obj);
        session.flush();
        return obj;
    }

    public Object update(Object obj) throws Exception {
        Session session = this.openSession();
        session.update(obj);
        session.flush();
        return obj;
    }

    public Object save(Object obj) throws Exception {
        Session session = this.openSession();
        session.merge(obj);
        session.flush();
        return obj;
    }

    public Object remove(Object obj) throws Exception {
        Session session = this.openSession();
        session.delete(obj);
        session.flush();
        return obj;
    }

    public Object remove(Class clazz, Serializable id) throws Exception {
        Session session = this.openSession();
        Object obj = session.get(clazz, id);
        session.delete(obj);
        session.flush();
        return obj;
    }

    public Object remove(Session session, Class clazz, Serializable id) throws Exception {
        Object obj = session.get(clazz, id);
        session.delete(obj);
        return obj;
    }

    public void startRequest(ExoContainer container) {
    }

    public void endRequest(ExoContainer container) {
        this.closeSession();
    }
}

