/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class PingRsp
implements Serializable,
Streamable {
    public Address own_addr = null;
    public Address coord_addr = null;
    public boolean is_server = false;
    private static final long serialVersionUID = 3634334590904551586L;

    public PingRsp() {
    }

    public PingRsp(Address own_addr, Address coord_addr, boolean is_server) {
        this.own_addr = own_addr;
        this.coord_addr = coord_addr;
        this.is_server = is_server;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PingRsp)) {
            return false;
        }
        PingRsp other = (PingRsp)obj;
        return this.own_addr != null && other.own_addr != null && this.own_addr.equals(other.own_addr);
    }

    public int hashCode() {
        int retval = 0;
        if (this.own_addr != null) {
            retval += this.own_addr.hashCode();
        }
        if (this.coord_addr != null) {
            retval += this.coord_addr.hashCode();
        }
        if (retval == 0) {
            retval = super.hashCode();
        }
        return retval;
    }

    public boolean isCoord() {
        return this.is_server && this.own_addr != null && this.coord_addr != null && this.own_addr.equals(this.coord_addr);
    }

    public int size() {
        int retval = 3;
        if (this.own_addr != null) {
            ++retval;
            retval += this.own_addr.size();
        }
        if (this.coord_addr != null) {
            ++retval;
            retval += this.coord_addr.size();
        }
        return retval;
    }

    public Address getAddress() {
        return this.own_addr;
    }

    public Address getCoordAddress() {
        return this.coord_addr;
    }

    public boolean isServer() {
        return this.is_server;
    }

    public String toString() {
        return new StringBuffer("[own_addr=").append(this.own_addr).append(", coord_addr=").append(this.coord_addr).append(", is_server=").append(this.is_server).append(']').toString();
    }

    public void writeTo(DataOutputStream outstream) throws IOException {
        Util.writeAddress(this.own_addr, outstream);
        Util.writeAddress(this.coord_addr, outstream);
        outstream.writeBoolean(this.is_server);
    }

    public void readFrom(DataInputStream instream) throws IOException, IllegalAccessException, InstantiationException {
        this.own_addr = Util.readAddress(instream);
        this.coord_addr = Util.readAddress(instream);
        this.is_server = instream.readBoolean();
    }
}

