/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.mux.MuxChannel;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexerConcurrentTest
extends ChannelTestBase {
    private Channel s1;
    private Channel s2;
    private Channel s11;
    private Channel s21;
    JChannelFactory factory;
    JChannelFactory factory2;
    private static final long MIN_TIME = 1000L;
    private static final long MAX_TIME = 5000L;

    public MultiplexerConcurrentTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.factory = new JChannelFactory();
        this.factory.setMultiplexerConfig(MUX_CHANNEL_CONFIG);
        this.factory2 = new JChannelFactory();
        this.factory2.setMultiplexerConfig(MUX_CHANNEL_CONFIG);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.s1 != null) {
            this.s1.close();
        }
        if (this.s2 != null) {
            this.s2.close();
        }
        if (this.s21 != null) {
            this.s21.close();
            this.s21 = null;
        }
        if (this.s11 != null) {
            this.s11.close();
            this.s11 = null;
        }
        if (this.s1 != null) {
            MultiplexerConcurrentTest.assertFalse((boolean)((MuxChannel)this.s1).getChannel().isOpen());
            MultiplexerConcurrentTest.assertFalse((boolean)((MuxChannel)this.s1).getChannel().isConnected());
        }
        if (this.s2 != null) {
            MultiplexerConcurrentTest.assertFalse((boolean)((MuxChannel)this.s2).getChannel().isOpen());
            MultiplexerConcurrentTest.assertFalse((boolean)((MuxChannel)this.s2).getChannel().isConnected());
        }
        this.s2 = null;
        this.s1 = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoMessagesFromSameSenderToSameService() throws Exception {
        MyReceiver receiver = new MyReceiver();
        this.s1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s1");
        this.s1.connect("bla");
        this.s1.setReceiver(receiver);
        this.s1.send(null, null, (Serializable)((Object)"slow"));
        this.s1.send(null, null, (Serializable)((Object)"fast"));
        MyReceiver myReceiver = receiver;
        synchronized (myReceiver) {
            while (!receiver.done()) {
                receiver.wait();
            }
        }
        Map<Long, Message> results = receiver.getMessages();
        System.out.println("results:\n" + this.printMessages(results));
        Iterator<Map.Entry<Long, Message>> it = results.entrySet().iterator();
        Map.Entry<Long, Message> entry = it.next();
        long time = entry.getKey();
        Message msg = entry.getValue();
        String mode = (String)msg.getObject();
        MultiplexerConcurrentTest.assertEquals((String)"the slow message needs to be delivered before the fast one", (String)"slow", (String)mode);
        entry = it.next();
        long time2 = entry.getKey();
        long diff = Math.abs(time2 - time);
        System.out.println("diff=" + diff);
        MultiplexerConcurrentTest.assertTrue((diff >= 5000L && diff < 6000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoMessagesFromSameSenderToDifferentServices() throws Exception {
        MyReceiver receiver = new MyReceiver();
        this.s1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s1");
        this.s1.connect("bla");
        this.s1.setReceiver(receiver);
        this.s2 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s2");
        this.s2.connect("bla");
        this.s2.setReceiver(receiver);
        this.s1.send(null, null, (Serializable)((Object)"slow"));
        Util.sleep(200L);
        this.s2.send(null, null, (Serializable)((Object)"fast"));
        MyReceiver myReceiver = receiver;
        synchronized (myReceiver) {
            while (!receiver.done()) {
                receiver.wait();
            }
        }
        Map<Long, Message> results = receiver.getMessages();
        System.out.println("results:\n" + this.printMessages(results));
        Set<Long> times = results.keySet();
        Iterator<Long> it = times.iterator();
        long time = it.next();
        long time2 = it.next();
        long diff = Math.abs(time2 - time);
        System.out.println("diff=" + diff);
        MultiplexerConcurrentTest.assertTrue((String)"failing as we don't yet have concurrent delivery", (diff < 1000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoMessagesFromDifferentSendersToSameService() throws Exception {
        MyReceiver receiver = new MyReceiver();
        this.s1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s1");
        this.s1.connect("bla");
        this.s1.setReceiver(receiver);
        this.s2 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s1");
        this.s2.connect("bla");
        this.s1.send(null, null, (Serializable)((Object)"slow"));
        Util.sleep(200L);
        this.s2.send(null, null, (Serializable)((Object)"fast"));
        MyReceiver myReceiver = receiver;
        synchronized (myReceiver) {
            while (!receiver.done()) {
                receiver.wait();
            }
        }
        Map<Long, Message> results = receiver.getMessages();
        System.out.println("results:\n" + this.printMessages(results));
        Set<Long> times = results.keySet();
        Iterator<Long> it = times.iterator();
        long time = it.next();
        long time2 = it.next();
        long diff = Math.abs(time2 - time);
        System.out.println("diff=" + diff);
        MultiplexerConcurrentTest.assertTrue((String)"failing as we don't yet have concurrent delivery", (diff < 1000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoMessagesFromDifferentSendersToDifferentServices() throws Exception {
        MyReceiver receiver = new MyReceiver();
        this.s1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s1");
        this.s1.connect("bla");
        this.s1.setReceiver(receiver);
        this.s11 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s2");
        this.s11.connect("bla");
        this.s11.setReceiver(receiver);
        this.s2 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s1");
        this.s2.connect("bla");
        this.s21 = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "s2");
        this.s21.connect("bla");
        this.s1.send(null, null, (Serializable)((Object)"slow"));
        Util.sleep(200L);
        this.s21.send(null, null, (Serializable)((Object)"fast"));
        MyReceiver myReceiver = receiver;
        synchronized (myReceiver) {
            while (!receiver.done()) {
                receiver.wait();
            }
        }
        Map<Long, Message> results = receiver.getMessages();
        System.out.println("results:\n" + this.printMessages(results));
        Set<Long> times = results.keySet();
        Iterator<Long> it = times.iterator();
        long time = it.next();
        long time2 = it.next();
        long diff = Math.abs(time2 - time);
        System.out.println("diff=" + diff);
        MultiplexerConcurrentTest.assertTrue((String)"failing as we don't yet have concurrent delivery", (diff < 1000L ? 1 : 0) != 0);
    }

    String printMessages(Map<Long, Message> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, Message> entry : map.entrySet()) {
            sb.append(new Date(entry.getKey())).append(": ").append(entry.getValue().getObject()).append("\n");
        }
        return sb.toString();
    }

    public static Test suite() {
        return new TestSuite(MultiplexerConcurrentTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MultiplexerConcurrentTest.suite());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        final Map<Long, Message> msgs = new HashMap<Long, Message>();

        private MyReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            String mode = (String)msg.getObject();
            System.out.println("received " + msg + " (" + mode + ")");
            this.msgs.put(System.currentTimeMillis(), msg);
            if (mode.equalsIgnoreCase("slow")) {
                System.out.println("sleeping for 5 secs");
                Util.sleep(5000L);
            }
            MyReceiver myReceiver = this;
            synchronized (myReceiver) {
                if (this.msgs.size() == 2) {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean done() {
            Map<Long, Message> map = this.msgs;
            synchronized (map) {
                return this.msgs.size() == 2;
            }
        }

        public Map<Long, Message> getMessages() {
            return new TreeMap<Long, Message>(this.msgs);
        }
    }
}

