/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import org.apache.lucene.document.Document;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.impl.SessionImpl;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.backend.UpdateWork;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.impl.BatchLuceneWorkQueue;
import org.hibernate.search.backend.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.query.FullTextQueryImpl;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.ContextHelper;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextSessionImpl
implements FullTextSession {
    private final SessionImpl session;
    private PostTransactionWorkQueueSynchronization postTransactionWorkQueueSynch;

    public FullTextSessionImpl(Session session) {
        this.session = (SessionImpl)session;
    }

    @Override
    public Query createFullTextQuery(org.apache.lucene.search.Query luceneQuery, Class ... entities) {
        return new FullTextQueryImpl(luceneQuery, entities, (SessionImplementor)this.session, new ParameterMetadata(null, null));
    }

    @Override
    public void index(Object entity) {
        if (entity == null) {
            return;
        }
        Class<?> clazz = entity.getClass();
        FullTextIndexEventListener listener = ContextHelper.getLuceneEventListener((SessionImplementor)this.session);
        DocumentBuilder<Object> builder = listener.getDocumentBuilders().get(clazz);
        if (builder != null) {
            Serializable id = this.session.getIdentifier(entity);
            Document doc = builder.getDocument(entity, id);
            UpdateWork work = new UpdateWork(id, entity.getClass(), doc);
            this.processWork(work, listener.getDocumentBuilders(), listener.getLockableDirectoryProviders());
        }
    }

    private void processWork(Work work, Map<Class, DocumentBuilder<Object>> documentBuilders, Map<DirectoryProvider, ReentrantLock> lockableDirectoryProviders) {
        if (this.session.isTransactionInProgress()) {
            if (this.postTransactionWorkQueueSynch == null || this.postTransactionWorkQueueSynch.isConsumed()) {
                this.postTransactionWorkQueueSynch = this.createWorkQueueSync(documentBuilders, lockableDirectoryProviders);
                this.session.getTransaction().registerSynchronization((Synchronization)this.postTransactionWorkQueueSynch);
            }
            this.postTransactionWorkQueueSynch.add(work);
        } else {
            PostTransactionWorkQueueSynchronization sync = this.createWorkQueueSync(documentBuilders, lockableDirectoryProviders);
            sync.add(work);
            sync.afterCompletion(3);
        }
    }

    private PostTransactionWorkQueueSynchronization createWorkQueueSync(Map<Class, DocumentBuilder<Object>> documentBuilders, Map<DirectoryProvider, ReentrantLock> lockableDirectoryProviders) {
        BatchLuceneWorkQueue workQueue = new BatchLuceneWorkQueue(documentBuilders, lockableDirectoryProviders);
        return new PostTransactionWorkQueueSynchronization(workQueue);
    }

    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        return this.session.createSQLQuery(sql, returnAlias, returnClass);
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        return this.session.createSQLQuery(sql, returnAliases, returnClasses);
    }

    public int delete(String query) throws HibernateException {
        return this.session.delete(query);
    }

    public int delete(String query, Object value, Type type) throws HibernateException {
        return this.session.delete(query, value, type);
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        return this.session.delete(query, values, types);
    }

    public Collection filter(Object collection, String filter) throws HibernateException {
        return this.session.filter(collection, filter);
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        return this.session.filter(collection, filter, value, type);
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        return this.session.filter(collection, filter, values, types);
    }

    public List find(String query) throws HibernateException {
        return this.session.find(query);
    }

    public List find(String query, Object value, Type type) throws HibernateException {
        return this.session.find(query, value, type);
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        return this.session.find(query, values, types);
    }

    public Iterator iterate(String query) throws HibernateException {
        return this.session.iterate(query);
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        return this.session.iterate(query, value, type);
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        return this.session.iterate(query, values, types);
    }

    public void save(String entityName, Object object, Serializable id) throws HibernateException {
        this.session.save(entityName, object, id);
    }

    public void save(Object object, Serializable id) throws HibernateException {
        this.session.save(object, id);
    }

    public Object saveOrUpdateCopy(String entityName, Object object) throws HibernateException {
        return this.session.saveOrUpdateCopy(entityName, object);
    }

    public Object saveOrUpdateCopy(String entityName, Object object, Serializable id) throws HibernateException {
        return this.session.saveOrUpdateCopy(entityName, object, id);
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        return this.session.saveOrUpdateCopy(object);
    }

    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        return this.session.saveOrUpdateCopy(object, id);
    }

    public void update(String entityName, Object object, Serializable id) throws HibernateException {
        this.session.update(entityName, object, id);
    }

    public void update(Object object, Serializable id) throws HibernateException {
        this.session.update(object, id);
    }

    public Transaction beginTransaction() throws HibernateException {
        return this.session.beginTransaction();
    }

    public void cancelQuery() throws HibernateException {
        this.session.cancelQuery();
    }

    public void clear() {
        if (this.postTransactionWorkQueueSynch != null && !this.postTransactionWorkQueueSynch.isConsumed()) {
            this.postTransactionWorkQueueSynch.afterCompletion(4);
        }
        this.session.clear();
    }

    public Connection close() throws HibernateException {
        return this.session.close();
    }

    public Connection connection() throws HibernateException {
        return this.session.connection();
    }

    public boolean contains(Object object) {
        return this.session.contains(object);
    }

    public Criteria createCriteria(String entityName) {
        return this.session.createCriteria(entityName);
    }

    public Criteria createCriteria(String entityName, String alias) {
        return this.session.createCriteria(entityName, alias);
    }

    public Criteria createCriteria(Class persistentClass) {
        return this.session.createCriteria(persistentClass);
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        return this.session.createCriteria(persistentClass, alias);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        return this.session.createFilter(collection, queryString);
    }

    public Query createQuery(String queryString) throws HibernateException {
        return this.session.createQuery(queryString);
    }

    public SQLQuery createSQLQuery(String queryString) throws HibernateException {
        return this.session.createSQLQuery(queryString);
    }

    public void delete(String entityName, Object object) throws HibernateException {
        this.session.delete(entityName, object);
    }

    public void delete(Object object) throws HibernateException {
        this.session.delete(object);
    }

    public void disableFilter(String filterName) {
        this.session.disableFilter(filterName);
    }

    public Connection disconnect() throws HibernateException {
        return this.session.disconnect();
    }

    public Filter enableFilter(String filterName) {
        return this.session.enableFilter(filterName);
    }

    public void evict(Object object) throws HibernateException {
        this.session.evict(object);
    }

    public void flush() throws HibernateException {
        this.session.flush();
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        return this.session.get(clazz, id);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.get(clazz, id, lockMode);
    }

    public Object get(String entityName, Serializable id) throws HibernateException {
        return this.session.get(entityName, id);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.get(entityName, id, lockMode);
    }

    public CacheMode getCacheMode() {
        return this.session.getCacheMode();
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return this.session.getCurrentLockMode(object);
    }

    public Filter getEnabledFilter(String filterName) {
        return this.session.getEnabledFilter(filterName);
    }

    public EntityMode getEntityMode() {
        return this.session.getEntityMode();
    }

    public String getEntityName(Object object) throws HibernateException {
        return this.session.getEntityName(object);
    }

    public FlushMode getFlushMode() {
        return this.session.getFlushMode();
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.session.getIdentifier(object);
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        return this.session.getNamedQuery(queryName);
    }

    public Session getSession(EntityMode entityMode) {
        return this.session.getSession(entityMode);
    }

    public SessionFactory getSessionFactory() {
        return this.session.getSessionFactory();
    }

    public SessionStatistics getStatistics() {
        return this.session.getStatistics();
    }

    public Transaction getTransaction() {
        return this.session.getTransaction();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public boolean isDirty() throws HibernateException {
        return this.session.isDirty();
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public Object load(String entityName, Serializable id) throws HibernateException {
        return this.session.load(entityName, id);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.load(entityName, id, lockMode);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        this.session.load(object, id);
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        return this.session.load(theClass, id);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.load(theClass, id, lockMode);
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.session.lock(entityName, object, lockMode);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.session.lock(object, lockMode);
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        return this.session.merge(entityName, object);
    }

    public Object merge(Object object) throws HibernateException {
        return this.session.merge(object);
    }

    public void persist(String entityName, Object object) throws HibernateException {
        this.session.persist(entityName, object);
    }

    public void persist(Object object) throws HibernateException {
        this.session.persist(object);
    }

    public void reconnect() throws HibernateException {
        this.session.reconnect();
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.session.reconnect(connection);
    }

    public void refresh(Object object) throws HibernateException {
        this.session.refresh(object);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.session.refresh(object, lockMode);
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.session.replicate(entityName, object, replicationMode);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.session.replicate(object, replicationMode);
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.session.save(entityName, object);
    }

    public Serializable save(Object object) throws HibernateException {
        return this.session.save(object);
    }

    public void saveOrUpdate(String entityName, Object object) throws HibernateException {
        this.session.saveOrUpdate(entityName, object);
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.session.saveOrUpdate(object);
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.session.setCacheMode(cacheMode);
    }

    public void setFlushMode(FlushMode flushMode) {
        this.session.setFlushMode(flushMode);
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        this.session.setReadOnly(entity, readOnly);
    }

    public void update(String entityName, Object object) throws HibernateException {
        this.session.update(entityName, object);
    }

    public void update(Object object) throws HibernateException {
        this.session.update(object);
    }
}

