/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ResourceLoaderAdapter
implements UnifiedVirtualFile {
    private URL resourceURL;
    private ClassLoader loader;

    public ResourceLoaderAdapter() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ResourceLoaderAdapter(ClassLoader loader) {
        this.loader = loader;
    }

    private ResourceLoaderAdapter(ClassLoader loader, URL resourceURL) {
        this.resourceURL = resourceURL;
        this.loader = loader;
    }

    public UnifiedVirtualFile findChild(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null) {
            try {
                resourceURL = new URL(resourcePath);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (resourceURL == null) {
                try {
                    File file = new File(resourcePath);
                    if (file.exists()) {
                        resourceURL = file.toURL();
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (resourceURL == null) {
                try {
                    resourceURL = this.loader.getResource(resourcePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (resourceURL == null) {
            throw new IOException("Cannot get URL for: " + resourcePath);
        }
        return new ResourceLoaderAdapter(this.loader, resourceURL);
    }

    public URL toURL() {
        if (null == this.resourceURL) {
            throw new IllegalStateException("UnifiedVirtualFile not initialized");
        }
        return this.resourceURL;
    }
}

