/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.navigation.UINavigationNodeSelector;
import org.exoplatform.portal.webui.page.UIPageNodeForm2;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/navigation/UINavigationManagement.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddRootNodeActionListener.class})})
public class UINavigationManagement
extends UIContainer {
    private String owner;
    private String ownerType;

    public UINavigationManagement() throws Exception {
        this.addChild(UINavigationNodeSelector.class, null, null);
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public <T extends UIComponent> T setRendered(boolean b) {
        return (T)super.setRendered(b);
    }

    public void loadView(Event<? extends UIComponent> event) throws Exception {
        UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)this.getChild(UINavigationNodeSelector.class);
        UITree uiTree = (UITree)uiNodeSelector.getChild(UITree.class);
        uiTree.createEvent("ChangeNode", event.getExecutionPhase(), event.getRequestContext()).broadcast();
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRootNodeActionListener
    extends EventListener<UINavigationManagement> {
        public void execute(Event<UINavigationManagement> event) throws Exception {
            UINavigationManagement uiManagement = (UINavigationManagement)((Object)event.getSource());
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiManagement.getChild(UINavigationNodeSelector.class);
            UIPopupWindow uiManagementPopup = (UIPopupWindow)uiNodeSelector.getAncestorOfType(UIPopupWindow.class);
            UIPageNodeForm2 uiNodeForm = (UIPageNodeForm2)uiManagementPopup.createUIComponent(UIPageNodeForm2.class, null, null);
            uiNodeForm.setValues(null);
            uiManagementPopup.setUIComponent((UIComponent)uiNodeForm);
            PageNavigation nav = uiNodeSelector.getSelectedNavigation();
            uiNodeForm.setSelectedParent(nav);
            uiNodeForm.setOwner(nav.getOwnerId());
            uiNodeForm.setOwnerType(nav.getOwnerType());
            uiManagementPopup.setWindowSize(800, 500);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiManagementPopup.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UINavigationManagement> {
        /*
         * Enabled aggressive block sorting
         */
        public void execute(Event<UINavigationManagement> event) throws Exception {
            PageNavigation navigation;
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UINavigationManagement uiManagement = (UINavigationManagement)((Object)event.getSource());
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiManagement.getChild(UINavigationNodeSelector.class);
            UserPortalConfigService portalConfigService = (UserPortalConfigService)uiManagement.getApplicationComponent(UserPortalConfigService.class);
            PageNavigation persistNavigation = portalConfigService.getPageNavigation((navigation = uiNodeSelector.getSelectedNavigation()).getOwnerType(), navigation.getOwnerId());
            if (persistNavigation == null) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UINavigationManagement.msg.NavigationNotExistAnymore", null));
                UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getParent();
                uiPopup.setShow(false);
                UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                prContext.setFullRender(true);
                return;
            }
            if (navigation.getOwnerType() == "portal") {
                UserPortalConfig portalConfig = portalConfigService.getUserPortalConfig(navigation.getOwnerId(), prContext.getRemoteUser());
                if (portalConfig == null) {
                    UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                    uiApp.addMessage(new ApplicationMessage("UIPortalForm.msg.notExistAnymore", null));
                    UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getParent();
                    uiPopup.setShow(false);
                    UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
                    UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                    prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                    prContext.setFullRender(true);
                    return;
                }
                portalConfigService.update(navigation);
            } else {
                portalConfigService.update(navigation);
            }
            UIPortal uiPortal = Util.getUIPortal();
            this.setNavigation(uiPortal.getNavigations(), navigation);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getParent();
            uiPopup.setShow(false);
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            prContext.setFullRender(true);
        }

        private void setNavigation(List<PageNavigation> navs, PageNavigation nav) {
            for (int i = 0; i < navs.size(); ++i) {
                if (navs.get(i).getId() != nav.getId()) continue;
                navs.set(i, nav);
                return;
            }
        }
    }
}

