/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.Recoverable;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.pm.Tx;

public class TxManager
implements Recoverable {
    private static final Logger log = Logger.getLogger((Class)TxManager.class);
    PersistenceManager persistenceManager;
    ConcurrentHashMap globalToLocal = new ConcurrentHashMap();
    ConcurrentHashMap prepared = new ConcurrentHashMap();
    static /* synthetic */ Class class$org$jboss$mq$pm$TxManager$GlobalXID;

    public TxManager(PersistenceManager pm) {
        this.persistenceManager = pm;
    }

    public final Tx getPrepared(ConnectionToken dc, Object xid) throws JMSException {
        GlobalXID gxid = new GlobalXID(dc, xid);
        Tx txid = (Tx)this.globalToLocal.get((Object)gxid);
        if (txid == null) {
            throw new SpyJMSException("Transaction does not exist from: " + dc.getClientID() + " xid=" + xid);
        }
        return txid;
    }

    public final Tx createTx() throws JMSException {
        Tx txId = this.persistenceManager.createPersistentTx();
        return txId;
    }

    public final void commitTx(Tx txId) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Commit branch=" + txId.longValue()));
        }
        txId.commit(this.persistenceManager);
    }

    public final void commitTx(ConnectionToken dc, Object xid) throws JMSException {
        boolean trace = log.isTraceEnabled();
        GlobalXID gxid = new GlobalXID(dc, xid);
        Tx txid = (Tx)this.globalToLocal.get((Object)gxid);
        if (txid == null) {
            PreparedInfo preparedInfo = (PreparedInfo)this.prepared.get(xid);
            if (preparedInfo == null) {
                throw new SpyJMSException("Transaction does not exist from: " + dc.getClientID() + " xid=" + xid);
            }
            Set txids = preparedInfo.getTxids();
            Iterator i = txids.iterator();
            while (i.hasNext()) {
                txid = (Tx)i.next();
                if (trace) {
                    log.trace((Object)("Commit xid=" + xid + " branch=" + txid.longValue()));
                }
                txid.commit(this.persistenceManager);
            }
            this.prepared.remove(xid);
        } else {
            if (trace) {
                log.trace((Object)("Commit xid=" + xid + " branch=" + txid.longValue()));
            }
            txid.commit(this.persistenceManager);
        }
    }

    public void addPostCommitTask(Tx txId, Runnable task) throws JMSException {
        if (txId == null) {
            task.run();
            return;
        }
        txId.addPostCommitTask(task);
    }

    public void rollbackTx(Tx txId) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Rollback branch=" + txId.longValue()));
        }
        txId.rollback(this.persistenceManager);
    }

    public final void rollbackTx(ConnectionToken dc, Object xid) throws JMSException {
        boolean trace = log.isTraceEnabled();
        GlobalXID gxid = new GlobalXID(dc, xid);
        Tx txid = (Tx)this.globalToLocal.get((Object)gxid);
        if (txid == null) {
            PreparedInfo preparedInfo = (PreparedInfo)this.prepared.get(xid);
            if (preparedInfo == null) {
                throw new SpyJMSException("Transaction does not exist from: " + dc.getClientID() + " xid=" + xid);
            }
            Set txids = preparedInfo.getTxids();
            Iterator i = txids.iterator();
            while (i.hasNext()) {
                txid = (Tx)i.next();
                if (trace) {
                    log.trace((Object)("Rolling back xid=" + xid + " branch=" + txid.longValue()));
                }
                txid.rollback(this.persistenceManager);
            }
            this.prepared.remove(xid);
        } else {
            if (trace) {
                log.trace((Object)("Rolling back xid=" + xid + " branch=" + txid.longValue()));
            }
            txid.rollback(this.persistenceManager);
        }
    }

    public void addPostRollbackTask(Tx txId, Runnable task) throws JMSException {
        if (txId == null) {
            return;
        }
        txId.addPostRollbackTask(task);
    }

    public Tx createTx(ConnectionToken dc, Object xid) throws JMSException {
        GlobalXID gxid = new GlobalXID(dc, xid);
        if (this.globalToLocal.containsKey((Object)gxid)) {
            throw new SpyJMSException("Duplicate transaction from: " + dc.getClientID() + " xid=" + xid);
        }
        Tx txId = this.createTx();
        if (xid != null && xid instanceof Xid) {
            txId.setXid((Xid)xid);
        }
        this.globalToLocal.put((Object)gxid, (Object)txId);
        txId.addPostCommitTask(gxid);
        txId.addPostRollbackTask(gxid);
        return txId;
    }

    public void restoreTx(Tx txId) throws JMSException {
        this.addPreparedTx(txId, txId.getXid(), true);
    }

    void addPreparedTx(Tx txId, Xid xid, boolean inDoubt) throws JMSException {
        PreparedInfo preparedInfo = (PreparedInfo)this.prepared.get((Object)xid);
        if (preparedInfo == null) {
            preparedInfo = new PreparedInfo(xid, false);
            this.prepared.put((Object)xid, (Object)preparedInfo);
        }
        preparedInfo.add(txId);
        if (inDoubt) {
            preparedInfo.setInDoubt(true);
        }
    }

    public void markPrepared(ConnectionToken dc, Object xid, Tx txId) throws JMSException {
        try {
            if (xid instanceof Xid) {
                this.addPreparedTx(txId, (Xid)xid, false);
            }
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Error marking transaction as prepared xid=" + xid + " tx=" + txId, t);
        }
    }

    public Xid[] recover(ConnectionToken dc, int flags) throws Exception {
        Set preparedXids = this.prepared.keySet();
        Xid[] xids = preparedXids.toArray(new Xid[preparedXids.size()]);
        return xids;
    }

    public Map getPreparedTransactions() {
        return this.prepared;
    }

    public static class PreparedInfo {
        private Xid xid;
        private boolean inDoubt;
        private Set txids = new CopyOnWriteArraySet();

        public PreparedInfo(Xid xid, boolean inDoubt) {
            this.xid = xid;
            this.inDoubt = inDoubt;
        }

        public boolean isInDoubt() {
            return this.inDoubt;
        }

        public void setInDoubt(boolean inDoubt) {
            this.inDoubt = inDoubt;
        }

        public Xid getXid() {
            return this.xid;
        }

        public Set getTxids() {
            return this.txids;
        }

        public void add(Tx txid) {
            this.txids.add(txid);
        }

        public void remove(Tx txid) {
            this.txids.remove(txid);
        }

        public boolean isEmpty() {
            return this.txids.isEmpty();
        }
    }

    class GlobalXID
    implements Runnable {
        ConnectionToken dc;
        Object xid;

        GlobalXID(ConnectionToken dc, Object xid) {
            this.dc = dc;
            this.xid = xid;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != (class$org$jboss$mq$pm$TxManager$GlobalXID == null ? (class$org$jboss$mq$pm$TxManager$GlobalXID = TxManager.class$("org.jboss.mq.pm.TxManager$GlobalXID")) : class$org$jboss$mq$pm$TxManager$GlobalXID)) {
                return false;
            }
            return ((GlobalXID)obj).xid.equals(this.xid) && ((GlobalXID)obj).dc.equals(this.dc);
        }

        public int hashCode() {
            return this.xid.hashCode();
        }

        public void run() {
            PreparedInfo preparedInfo;
            Tx txId = (Tx)TxManager.this.globalToLocal.remove((Object)this);
            if (txId != null && (preparedInfo = (PreparedInfo)TxManager.this.prepared.get(this.xid)) != null) {
                preparedInfo.remove(txId);
                if (preparedInfo.isEmpty()) {
                    TxManager.this.prepared.remove(this.xid);
                }
            }
        }
    }
}

