/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;

public class JavassistToReflect {
    public static String getParameterClassArrayString(String arrayName, CtBehavior behavior) throws NotFoundException {
        CtClass[] params = behavior.getParameterTypes();
        return JavassistToReflect.getParameterClassArrayString(params, arrayName);
    }

    public static String getParameterClassArrayString(CtClass[] params, String arrayName) throws NotFoundException {
        StringBuffer arr = new StringBuffer(" new java.lang.Class[" + params.length + "];");
        for (int i = 0; i < params.length; ++i) {
            arr.append(arrayName + "[" + i + "] = ");
            if (params[i].isArray()) {
                arr.append(JavassistToReflect.getClassObjectString(params[i], true));
            } else {
                arr.append(JavassistToReflect.getClassObjectString(params[i]));
            }
            arr.append(";");
        }
        return arr.toString();
    }

    public static String getClassObjectString(CtClass clazz) {
        return JavassistToReflect.getClassObjectString(clazz, false);
    }

    public static String getClassObjectString(CtClass clazz, boolean isArray) {
        if (!isArray) {
            if (clazz.isPrimitive()) {
                return JavassistToReflect.getClassName(clazz);
            }
            if (AspectManager.debugClasses) {
                return "Thread.currentThread().getContextClassLoader().loadClass(\"" + JavassistToReflect.getClassName(clazz) + "\")";
            }
            return JavassistToReflect.getClassName(clazz) + ".class";
        }
        if (AspectManager.debugClasses) {
            return "new " + JavassistToReflect.getArrayClassName(clazz) + "[0].getClass()";
        }
        return JavassistToReflect.getArrayClassName(clazz) + "[].class";
    }

    public static String getArrayClassName(CtClass clazz) {
        String name = clazz.getName();
        int ind = name.indexOf("[");
        return name.substring(0, ind);
    }

    public static String getClassName(CtClass clazz) {
        if (!clazz.isPrimitive()) {
            return clazz.getName();
        }
        if (clazz == CtClass.booleanType) {
            return "java.lang.Boolean.TYPE";
        }
        if (clazz == CtClass.byteType) {
            return "java.lang.Byte.TYPE";
        }
        if (clazz == CtClass.charType) {
            return "java.lang.Character.TYPE";
        }
        if (clazz == CtClass.doubleType) {
            return "java.lang.Double.TYPE";
        }
        if (clazz == CtClass.floatType) {
            return "java.lang.Float.TYPE";
        }
        if (clazz == CtClass.intType) {
            return "java.lang.Integer.TYPE";
        }
        if (clazz == CtClass.longType) {
            return "java.lang.Long.TYPE";
        }
        if (clazz == CtClass.shortType) {
            return "java.lang.Short.TYPE";
        }
        throw new RuntimeException("Unsupported type " + clazz.getName());
    }

    public static String castInvocationValueToTypeString(CtClass type) {
        return JavassistToReflect.castInvocationValueToTypeString(type, "value");
    }

    public static String castInvocationValueToTypeString(CtClass type, String valueName) {
        String cast = null;
        if (type.isPrimitive()) {
            if (type.equals(CtClass.booleanType)) {
                cast = "((Boolean)" + valueName + ").booleanValue();";
            } else if (type.equals(CtClass.byteType)) {
                cast = "((Byte)" + valueName + ").byteValue();";
            } else if (type.equals(CtClass.charType)) {
                cast = "((Character)" + valueName + ").charValue();";
            } else if (type.equals(CtClass.doubleType)) {
                cast = "((Double)" + valueName + ").doubleValue();";
            } else if (type.equals(CtClass.floatType)) {
                cast = "((Float)" + valueName + ").floatValue();";
            } else if (type.equals(CtClass.intType)) {
                cast = "((Integer)" + valueName + ").intValue();";
            } else if (type.equals(CtClass.longType)) {
                cast = "((Long)" + valueName + ").longValue();";
            } else if (type.equals(CtClass.shortType)) {
                cast = "((Short)" + valueName + ").shortValue();";
            }
        } else {
            cast = type.isArray() ? "(" + type.getName() + ")" + valueName + ";" : "(" + type.getName() + ")" + valueName + ";";
        }
        return cast;
    }
}

