/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.jcr;

import javax.jcr.Session;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ks.common.jcr.JCRTask;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRSessionManager
implements SessionManager {
    private static final ThreadLocal<Session> currentSession = new ThreadLocal();
    String workspaceName = "portal-system";
    String repositoryName = "repository";

    public JCRSessionManager(String repository, String workspace) {
        this.workspaceName = workspace;
        this.repositoryName = repository;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    public Session getCurrentSession() {
        return currentSession.get();
    }

    public static Session currentSession() {
        return currentSession.get();
    }

    @Override
    public Session getSession(SessionProvider sessionProvider) {
        Session session = null;
        try {
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getRepository(this.repositoryName);
            session = sessionProvider.getSession(this.workspaceName, repository);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return session;
    }

    @Override
    public Session openSession() {
        Session session = currentSession.get();
        if (session != null) {
            throw new IllegalStateException("A session is already opened.");
        }
        session = this.createSession();
        currentSession.set(session);
        return session;
    }

    private Session openOrReuseSession() {
        Session session = currentSession.get();
        if (session == null) {
            session = this.createSession();
            currentSession.set(session);
        }
        return session;
    }

    @Override
    public Session createSession() {
        Session session = null;
        try {
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getRepository(this.repositoryName);
            session = repository.getSystemSession(this.workspaceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return session;
    }

    @Override
    public boolean closeSession() {
        return this.closeSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeSession(boolean save) {
        Session session = currentSession.get();
        if (session == null) {
            return false;
        }
        currentSession.set(null);
        try {
            if (save) {
                session.save();
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            session.logout();
        }
        return true;
    }

    @Override
    public <T> T executeAndSave(JCRTask<T> jcrTask) {
        try {
            this.openOrReuseSession();
            T t = jcrTask.execute(this.getCurrentSession());
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(true);
        }
    }

    @Override
    public <T> T execute(JCRTask<T> jcrTask) {
        try {
            this.openOrReuseSession();
            T t = jcrTask.execute(this.getCurrentSession());
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(true);
        }
    }
}

