/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.reflect.AnnotationIntrospector;
import org.exoplatform.container.jmx.PropertyInfo;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesInfo {
    private Map<String, PropertyInfo> properties;

    public PropertiesInfo(Map<String, PropertyInfo> properties) {
        this.properties = properties;
    }

    public static PropertiesInfo resolve(Class clazz, Class<? extends Annotation> annotationClass) {
        Annotation tpl2 = AnnotationIntrospector.resolveClassAnnotations((Class)clazz, annotationClass);
        Property[] blah = null;
        if (tpl2 instanceof NamingContext) {
            blah = ((NamingContext)tpl2).value();
        } else if (tpl2 instanceof NameTemplate) {
            blah = ((NameTemplate)tpl2).value();
        }
        if (blah != null) {
            HashMap<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
            for (Property property : blah) {
                PropertyInfo propertyInfo = new PropertyInfo(clazz, property);
                properties.put(propertyInfo.getKey(), propertyInfo);
            }
            return new PropertiesInfo(properties);
        }
        return null;
    }

    public Collection<PropertyInfo> getProperties() {
        return this.properties.values();
    }

    public Map<String, String> resolve(Object instance) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (PropertyInfo propertyInfo : this.properties.values()) {
            String key = propertyInfo.getKey();
            String value = propertyInfo.resolveValue(instance);
            props.put(key, value);
        }
        return props;
    }
}

