/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class LongValue
extends BaseValue {
    public static final int TYPE = 3;

    public LongValue(long l) throws IOException {
        super(3, new TransientValueData(l));
    }

    LongValue(TransientValueData data) throws IOException {
        super(3, data);
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        Long longNumber = new Long(this.getInternalString());
        if (longNumber != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(longNumber));
            return cal;
        }
        throw new ValueFormatException("empty value");
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to boolean failed: inconvertible types");
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        Long longNumber = new Long(this.getInternalString());
        if (longNumber != null) {
            return longNumber.doubleValue();
        }
        throw new ValueFormatException("empty value");
    }
}

