/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class EditableValueData
extends TransientValueData {
    protected final int maxIOBuffSize = this.calcMaxIOSize();

    public EditableValueData(byte[] bytes, int orderNumber, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory) throws IOException {
        super(orderNumber, bytes, null, null, fileCleaner, maxBufferSize, tempDirectory, true);
        this.spooled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditableValueData(File spoolFile, int orderNumber, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory) throws IOException {
        super(orderNumber, null, null, null, fileCleaner, maxBufferSize, tempDirectory, true);
        File sf = null;
        AbstractInterruptibleChannel sch = null;
        try {
            sf = File.createTempFile("jcrvdedit", null, tempDirectory);
            sch = new RandomAccessFile(sf, "rw").getChannel();
            FileChannel sourceCh = new FileInputStream(spoolFile).getChannel();
            try {
                ((FileChannel)sch).transferFrom(sourceCh, 0L, sourceCh.size());
            }
            finally {
                sourceCh.close();
            }
        }
        catch (IOException e) {
            try {
                sch.close();
                sf.delete();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw new IOException("init error " + e.getMessage()){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        this.data = null;
        this.spoolFile = sf;
        this.spoolChannel = sch;
        this.spooled = true;
    }

    protected int calcMaxIOSize() {
        return this.maxBufferSize < 1024 ? 1024 : (this.maxBufferSize < 256000 ? this.maxBufferSize : 256000);
    }

    protected int calcBuffSize(long length) {
        int buffSize = (int)(length > (long)this.maxIOBuffSize ? (long)this.maxIOBuffSize : length / 4L);
        buffSize = buffSize < 1024 ? 256 : buffSize;
        return buffSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientValueData createTransientCopy() throws RepositoryException {
        TransientValueData transientValueData;
        if (this.isByteArray()) {
            byte[] newBytes = new byte[this.data.length];
            System.arraycopy(this.data, 0, newBytes, 0, newBytes.length);
            return new TransientValueData(newBytes, this.orderNumber);
        }
        this.spoolChannel.force(false);
        InputStream thisStream = this.getAsStream();
        try {
            TransientValueData copy = new TransientValueData(this.orderNumber, null, thisStream, null, this.fileCleaner, this.maxBufferSize, this.tempDirectory, true);
            copy.spoolInputStream();
            transientValueData = copy;
        }
        catch (Throwable throwable) {
            try {
                thisStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RepositoryException("Create transient copy error. " + e, (Throwable)e);
            }
        }
        thisStream.close();
        return transientValueData;
    }

    public void update(InputStream stream, long length, long position) throws IOException {
        if (position < 0L) {
            throw new IOException("Position must be higher or equals 0. But given " + position);
        }
        if (length < 0L) {
            throw new IOException("Length must be higher or equals 0. But given " + length);
        }
        if (this.isByteArray()) {
            long newSize;
            long updateSize = position + length;
            long l = newSize = updateSize > (long)this.data.length ? updateSize : (long)this.data.length;
            if (newSize <= (long)this.maxBufferSize && newSize <= Integer.MAX_VALUE || this.maxBufferSize <= 0 || this.tempDirectory == null) {
                byte[] newBytes = new byte[(int)newSize];
                int newIndex = 0;
                newIndex = (int)position;
                if (newIndex > 0) {
                    System.arraycopy(this.data, 0, newBytes, 0, newIndex < this.data.length ? newIndex : this.data.length);
                }
                int i = -1;
                boolean doRead = true;
                byte[] buff = new byte[this.calcBuffSize(length)];
                while (doRead && (i = stream.read(buff)) >= 0) {
                    if (newIndex + i > newBytes.length) {
                        i = newBytes.length - newIndex;
                        doRead = false;
                    }
                    System.arraycopy(buff, 0, newBytes, newIndex, i);
                    newIndex += i;
                }
                if (newIndex < this.data.length) {
                    System.arraycopy(this.data, newIndex, newBytes, newIndex, this.data.length - newIndex);
                }
                this.data = newBytes;
                this.spoolFile = null;
                this.spoolChannel = null;
            } else {
                File chf = null;
                AbstractInterruptibleChannel chch = null;
                long newIndex = 0L;
                try {
                    chf = File.createTempFile("jcrvdedit", null, this.tempDirectory);
                    chch = new RandomAccessFile(chf, "rw").getChannel();
                    MappedByteBuffer bb = ((FileChannel)chch).map(FileChannel.MapMode.READ_WRITE, position + length, 0L);
                    bb.force();
                    bb = null;
                    ReadableByteChannel bch = Channels.newChannel(new ByteArrayInputStream(this.data));
                    newIndex = (int)position;
                    if (newIndex > 0L) {
                        ((FileChannel)chch).transferFrom(bch, 0L, newIndex < (long)this.data.length ? newIndex : (long)this.data.length);
                        bch.close();
                    }
                    ReadableByteChannel sch = Channels.newChannel(stream);
                    ((FileChannel)chch).transferFrom(sch, newIndex, length);
                    sch.close();
                    if ((newIndex += length) < (long)this.data.length) {
                        ((FileChannel)chch).transferFrom(bch, newIndex, (long)this.data.length - newIndex);
                    }
                    bch.close();
                }
                catch (IOException e) {
                    try {
                        chch.close();
                        chf.delete();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    throw new IOException("update error " + e.getMessage()){

                        public Throwable getCause() {
                            return e;
                        }
                    };
                }
                this.spoolFile = chf;
                this.spoolChannel = chch;
                this.data = null;
            }
        } else {
            MappedByteBuffer bb = this.spoolChannel.map(FileChannel.MapMode.READ_WRITE, position, length);
            ReadableByteChannel ch = Channels.newChannel(stream);
            ch.read(bb);
            ch.close();
            bb.force();
        }
    }

    public void setLength(long size) throws IOException {
        if (size < 0L) {
            throw new IOException("Size must be higher or equals 0. But given " + size);
        }
        if (this.isByteArray()) {
            if (size < (long)this.maxBufferSize || this.maxBufferSize <= 0 || this.tempDirectory == null) {
                byte[] newBytes;
                System.arraycopy(this.data, 0, newBytes, 0, this.data.length < (newBytes = new byte[(int)size]).length ? this.data.length : newBytes.length);
                this.data = newBytes;
            } else {
                File chf = null;
                AbstractInterruptibleChannel chch = null;
                try {
                    chf = File.createTempFile("jcrvdedit", null, this.tempDirectory);
                    chch = new RandomAccessFile(chf, "rw").getChannel();
                    ReadableByteChannel bch = Channels.newChannel(new ByteArrayInputStream(this.data));
                    ((FileChannel)chch).transferFrom(bch, 0L, this.data.length);
                    bch.close();
                    if (((FileChannel)chch).size() < size) {
                        MappedByteBuffer bb = ((FileChannel)chch).map(FileChannel.MapMode.READ_WRITE, size, 0L);
                        bb.force();
                    }
                }
                catch (IOException e) {
                    try {
                        chch.close();
                        chf.delete();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    throw new IOException("setLength(" + size + ") error. " + e.getMessage()){

                        public Throwable getCause() {
                            return e;
                        }
                    };
                }
                this.spoolFile = chf;
                this.spoolChannel = chch;
                this.data = null;
            }
        } else if (size < (long)this.maxBufferSize) {
            ByteBuffer bb = ByteBuffer.allocate((int)size);
            this.spoolChannel.force(false);
            this.spoolChannel.position(0L);
            this.spoolChannel.read(bb);
            byte[] tmpb = null;
            if (bb.hasArray()) {
                tmpb = bb.array();
            } else {
                tmpb = new byte[bb.capacity()];
                bb.get(tmpb);
            }
            this.spoolChannel.close();
            if (!this.spoolFile.delete()) {
                if (this.fileCleaner != null) {
                    log.info((Object)("Could not remove file. Add to fileCleaner " + this.spoolFile));
                    this.fileCleaner.addFile(this.spoolFile);
                } else {
                    log.warn((Object)("Could not remove temporary file on switch to bytes, fileCleaner not found. " + this.spoolFile.getAbsolutePath()));
                }
            }
            this.data = tmpb;
            this.spoolChannel = null;
            this.spoolFile = null;
        } else if (this.spoolChannel.size() < size) {
            MappedByteBuffer bb = this.spoolChannel.map(FileChannel.MapMode.READ_WRITE, size, 0L);
            bb.force();
        } else {
            this.spoolChannel.truncate(size);
        }
    }
}

