/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import javax.ejb.RemoveException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.logging.Logger;
import org.jboss.metadata.ConfigurationMetaData;

public final class JDBCRemoveEntityCommand {
    private final JDBCStoreManager manager;
    private final JDBCEntityBridge entity;
    private final Logger log;
    private final String removeEntitySQL;
    private final boolean syncOnCommitOnly;
    private boolean batchCascadeDelete;

    public JDBCRemoveEntityCommand(JDBCStoreManager manager) throws DeploymentException {
        this.manager = manager;
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ").append(this.entity.getQualifiedTableName()).append(" WHERE ");
        SQLUtil.getWhereClause(this.entity.getPrimaryKeyFields(), sql);
        this.removeEntitySQL = sql.toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Remove SQL: " + this.removeEntitySQL));
        }
        ConfigurationMetaData containerConfig = manager.getContainer().getBeanMetaData().getContainerConfiguration();
        this.syncOnCommitOnly = containerConfig.getSyncOnCommitOnly();
        JDBCCMRFieldBridge[] cmrFields = (JDBCCMRFieldBridge[])this.entity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            if (!cmrFields[i].isBatchCascadeDelete()) continue;
            this.batchCascadeDelete = true;
            break;
        }
    }

    public void execute(EntityEnterpriseContext ctx) throws RemoveException, RemoteException {
        if (this.entity.isRemoved(ctx)) {
            throw new IllegalStateException("Instance was already removed: id=" + ctx.getId());
        }
        this.entity.setIsBeingRemoved(ctx);
        Object[] oldRelationsRef = new Object[1];
        boolean needsSync = this.entity.removeFromRelations(ctx, oldRelationsRef);
        if (!this.syncOnCommitOnly && needsSync) {
            EntityContainer.synchronizeEntitiesWithinTransaction(ctx.getTransaction());
        }
        if (!this.batchCascadeDelete) {
            if (!this.entity.isScheduledForBatchCascadeDelete(ctx)) {
                this.executeDeleteSQL(ctx);
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Instance is scheduled for cascade delete. id=" + ctx.getId()));
            }
        }
        if (oldRelationsRef[0] != null) {
            Map oldRelations = (Map)oldRelationsRef[0];
            this.entity.cascadeDelete(ctx, oldRelations);
        }
        if (this.batchCascadeDelete) {
            if (!this.entity.isScheduledForBatchCascadeDelete(ctx)) {
                this.executeDeleteSQL(ctx);
            } else if (this.log.isTraceEnabled()) {
                this.log.debug((Object)("Instance is scheduled for cascade delete. id=" + ctx.getId()));
            }
        }
        this.entity.setRemoved(ctx);
        this.manager.getReadAheadCache().removeCachedData(ctx.getId());
    }

    private void executeDeleteSQL(EntityEnterpriseContext ctx) throws RemoveException {
        Object key = ctx.getId();
        Connection con = null;
        PreparedStatement ps = null;
        int rowsAffected = 0;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Executing SQL: " + this.removeEntitySQL));
            }
            con = this.entity.getDataSource().getConnection();
            ps = con.prepareStatement(this.removeEntitySQL);
            this.entity.setPrimaryKeyParameters(ps, 1, key);
            rowsAffected = ps.executeUpdate();
        }
        catch (Exception e) {
            try {
                this.log.error((Object)("Could not remove " + key), (Throwable)e);
                throw new RemoveException("Could not remove " + key + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        if (rowsAffected == 0) {
            this.log.error((Object)("Could not remove entity " + key));
            throw new RemoveException("Could not remove entity");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Remove: Rows affected = " + rowsAffected));
        }
    }
}

