/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier;

import java.net.URL;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.event.VerificationEventGeneratorSupport;
import org.jboss.verifier.event.VerificationListener;
import org.jboss.verifier.strategy.EJBVerifier11;
import org.jboss.verifier.strategy.EJBVerifier20;
import org.jboss.verifier.strategy.EJBVerifier21;
import org.jboss.verifier.strategy.VerificationContext;
import org.jboss.verifier.strategy.VerificationStrategy;

public class BeanVerifier
implements VerificationContext {
    private ApplicationMetaData ejbMetaData;
    private ClassLoader ejbClassLoader;
    private URL ejbURL;
    private VerificationStrategy verifier;
    private boolean success = true;
    private static Logger log = Logger.getLogger(BeanVerifier.class);
    private VerificationEventGeneratorSupport events = new VerificationEventGeneratorSupport();
    private static final String UNRECOGNIZED_VERSION = "Unknown version string";

    public void verify(URL url, ApplicationMetaData metaData) {
        this.verify(url, metaData, null);
    }

    public void verify(URL url, ApplicationMetaData metaData, ClassLoader cl) {
        this.ejbURL = url;
        this.ejbMetaData = metaData;
        this.ejbClassLoader = cl;
        if (metaData.isEJB1x()) {
            this.setVerifier("Enterprise JavaBeans v1.1, Final Release");
        } else if (metaData.isEJB21()) {
            this.setVerifier("Enterprise JavaBeans V2.1, Final Release");
        } else {
            this.setVerifier("Enterprise JavaBeans V2.0, Final Release");
        }
        Iterator beans = this.ejbMetaData.getEnterpriseBeans();
        while (beans.hasNext()) {
            BeanMetaData bean = (BeanMetaData)beans.next();
            if (bean.isEntity()) {
                EntityMetaData entityBean = (EntityMetaData)bean;
                if (metaData.isEJB2x() && entityBean.isCMP1x()) {
                    boolean storedSuccess = this.success;
                    this.verifier.checkEntity(entityBean);
                    if (this.success != storedSuccess) {
                        log.warn((Object)("The CMP 1.x EJB '" + entityBean.getEjbName() + "' generated some verification warnings. The Deployer " + "will ignore these warnings but you should check " + "your EJB to be on the safe side of things."));
                    }
                    this.success = storedSuccess;
                    continue;
                }
                this.verifier.checkEntity(entityBean);
                continue;
            }
            if (bean.isSession()) {
                this.verifier.checkSession((SessionMetaData)bean);
                continue;
            }
            this.verifier.checkMessageBean((MessageDrivenMetaData)bean);
        }
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void addVerificationListener(VerificationListener listener) {
        this.events.addVerificationListener(listener);
    }

    public void removeVerificationListener(VerificationListener listener) {
        this.events.removeVerificationListener(listener);
    }

    public void fireBeanChecked(VerificationEvent event) {
        this.events.fireBeanChecked(event);
    }

    public void fireSpecViolation(VerificationEvent event) {
        this.success = false;
        this.events.fireSpecViolation(event);
    }

    public ApplicationMetaData getApplicationMetaData() {
        return this.ejbMetaData;
    }

    public URL getJarLocation() {
        return this.ejbURL;
    }

    public ClassLoader getClassLoader() {
        return this.ejbClassLoader;
    }

    public String getEJBVersion() {
        return "Enterprise JavaBeans v1.1, Final Release";
    }

    protected void setVerifier(String version) {
        if ("Enterprise JavaBeans v1.1, Final Release".equals(version)) {
            this.verifier = new EJBVerifier11(this);
        } else if ("Enterprise JavaBeans V2.0, Final Release".equals(version)) {
            this.verifier = new EJBVerifier20(this);
        } else if ("Enterprise JavaBeans V2.1, Final Release".equals(version)) {
            this.verifier = new EJBVerifier21(this);
        } else {
            throw new IllegalArgumentException("Unknown version string: " + version);
        }
    }

    protected VerificationStrategy getVerifier() {
        return this.verifier;
    }
}

