/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypedMap<EK, EV, IK, IV>
implements Map<EK, EV> {
    private KeySet keySet;
    private TypedEntrySet entrySet;
    private ValueCollection values;

    private static <I> boolean safeEquals(I left, I right, Converter<?, I> converter) {
        return left != null && right != null && converter.equals(left, right);
    }

    public abstract Converter<EK, IK> getKeyConverter();

    public abstract Converter<EV, IV> getValueConverter();

    protected abstract Map<IK, IV> getDelegate();

    @Override
    public final int size() {
        return this.getDelegate().size();
    }

    @Override
    public final void clear() {
        this.getDelegate().clear();
    }

    @Override
    public final boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        Object ek = key;
        Object ik = ((Converter)this.getKeyConverter()).keyUnwrapper.transform(ek);
        return this.getDelegate().containsKey(ik);
    }

    @Override
    public final Set<EK> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EV put(EK ek, EV ev) {
        Map<IK, IV> map = this.getDelegate();
        Object ik = ((Converter)this.getKeyConverter()).keyUnwrapper.transform(ek);
        boolean contains = map.containsKey(ik);
        Object iv = ((Converter)this.getValueConverter()).valueUnwrapper.transform(ev);
        iv = map.put(ik, iv);
        if (contains) {
            boolean rollback = true;
            try {
                ev = ((Converter)this.getValueConverter()).valueWrapper.transform(iv);
                rollback = false;
            }
            finally {
                if (rollback) {
                    map.put(ik, iv);
                }
            }
        } else {
            ev = null;
        }
        return ev;
    }

    @Override
    public final EV get(Object key) {
        Object ek = key;
        Object ik = ((Converter)this.getKeyConverter()).keyUnwrapper.transform(ek);
        Map<IK, IV> map = this.getDelegate();
        IV iv = map.get(ik);
        EV ev = null;
        if (iv != null || map.containsKey(ik)) {
            ev = (EV)((Converter)this.getValueConverter()).valueWrapper.transform(iv);
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EV remove(Object key) {
        Object ek = key;
        Object ik = ((Converter)this.getKeyConverter()).keyUnwrapper.transform(ek);
        Map<IK, IV> map = this.getDelegate();
        if (this.getDelegate().containsKey(ik)) {
            IV iv = map.remove(ik);
            boolean rollback = true;
            try {
                Object ev = ((Converter)this.getValueConverter()).valueWrapper.transform(iv);
                rollback = false;
                Object Out = ev;
                return (EV)Out;
            }
            finally {
                if (rollback) {
                    map.put(ik, iv);
                }
            }
        }
        return null;
    }

    @Override
    public final boolean containsValue(Object value) {
        Object ev = value;
        Object iv = ((Converter)this.getValueConverter()).valueUnwrapper.transform(ev);
        return this.getDelegate().containsValue(iv);
    }

    @Override
    public final Set<Map.Entry<EK, EV>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new TypedEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public final void putAll(Map<? extends EK, ? extends EV> em) {
        Map<IK, IV> im = this.convert(em);
        this.getDelegate().putAll(im);
    }

    @Override
    public final Collection<EV> values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            Map that = (Map)o;
            Map<IK, IV> delegate = this.getDelegate();
            if (that.size() != delegate.size()) {
                return false;
            }
            for (Map.Entry thatEntry : that.entrySet()) {
                Object thatKey = thatEntry.getKey();
                Object thatValue = thatEntry.getValue();
                try {
                    Object ik = ((Converter)this.getKeyConverter()).keyUnwrapper.transform(thatKey);
                    Object iv = ((Converter)this.getValueConverter()).valueUnwrapper.transform(thatValue);
                    IV internalValue = delegate.get(ik);
                    if (AbstractTypedMap.safeEquals(internalValue, iv, this.getValueConverter())) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                catch (ClassCastException e) {
                    return false;
                }
                catch (NullPointerException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    protected final Map<IK, IV> convert(Map<? extends EK, ? extends EV> t) throws IllegalArgumentException, NullPointerException, ClassCastException {
        if (t == null) {
            throw new NullPointerException("No null map can be accepted");
        }
        HashMap u = new HashMap(t.size());
        for (Map.Entry<EK, EV> entry : t.entrySet()) {
            Object ik = ((Converter)this.getKeyConverter()).keyUnwrapper.transform(entry.getKey());
            Object iv = ((Converter)this.getValueConverter()).valueUnwrapper.transform(entry.getValue());
            u.put(ik, iv);
        }
        return u;
    }

    public final void replace(Map<EK, EV> map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        Map<IK, IV> tmp = this.convert(map);
        Map<IK, IV> delegate = this.getDelegate();
        delegate.clear();
        delegate.putAll(tmp);
    }

    public final void validate() throws ClassCastException, NullPointerException, IllegalArgumentException {
        for (Map.Entry<IK, IV> entry : this.getDelegate().entrySet()) {
            ((Converter)this.getKeyConverter()).keyWrapper.transform(entry.getKey());
            ((Converter)this.getValueConverter()).valueWrapper.transform(entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypedEntrySet
    extends TypedCollection<Map.Entry<EK, EV>, Map.Entry<IK, IV>>
    implements Set<Map.Entry<EK, EV>> {
        private TypedEntrySet() {
            super(AbstractTypedMap.this.getDelegate().entrySet(), new EntryUnwrapper(), new EntryWrapper());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueCollection
    extends TypedCollection<EV, IV> {
        public ValueCollection() {
            super(AbstractTypedMap.this.getDelegate().values(), AbstractTypedMap.this.getValueConverter().valueUnwrapper, AbstractTypedMap.this.getValueConverter().valueWrapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends TypedCollection<EK, IK>
    implements Set<EK> {
        public KeySet() {
            super(AbstractTypedMap.this.getDelegate().keySet(), AbstractTypedMap.this.getKeyConverter().keyUnwrapper, AbstractTypedMap.this.getKeyConverter().keyWrapper);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Set) {
                Set that = (Set)obj;
                if (this.size() != that.size()) {
                    return false;
                }
                for (Object o : that) {
                    try {
                        if (this.contains(o)) continue;
                        return false;
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                    catch (ClassCastException e) {
                        return false;
                    }
                    catch (NullPointerException e) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (Object o : this) {
                if (o == null) continue;
                hashCode += o.hashCode();
            }
            return hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryUnwrapper
    extends Transformer<Map.Entry<IK, IV>, Map.Entry<EK, EV>> {
        private EntryUnwrapper() {
        }

        @Override
        protected Map.Entry<IK, IV> transform(Map.Entry<EK, EV> internalEntry) {
            return new InternalEntry(internalEntry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryWrapper
    extends Transformer<Map.Entry<EK, EV>, Map.Entry<IK, IV>> {
        private EntryWrapper() {
        }

        @Override
        protected Map.Entry<EK, EV> transform(Map.Entry<IK, IV> externalEntry) {
            return new ExternalEntry(externalEntry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalEntry
    extends TypedEntry<IK, IV, EK, EV> {
        private InternalEntry(Map.Entry<EK, EV> delegate) {
            super(delegate);
        }

        @Override
        protected Transformer<IK, EK> getKeyWrapper() {
            return AbstractTypedMap.this.getKeyConverter().keyUnwrapper;
        }

        @Override
        protected Transformer<IV, EV> getValueWrapper() {
            return AbstractTypedMap.this.getValueConverter().valueUnwrapper;
        }

        @Override
        protected Transformer<EV, IV> getValueUnwrapper() {
            return AbstractTypedMap.this.getValueConverter().valueWrapper;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalEntry
    extends TypedEntry<EK, EV, IK, IV> {
        private ExternalEntry(Map.Entry<IK, IV> delegate) {
            super(delegate);
        }

        @Override
        protected Transformer<EK, IK> getKeyWrapper() {
            return AbstractTypedMap.this.getKeyConverter().keyWrapper;
        }

        @Override
        protected Transformer<EV, IV> getValueWrapper() {
            return AbstractTypedMap.this.getValueConverter().valueWrapper;
        }

        @Override
        protected Transformer<IV, EV> getValueUnwrapper() {
            return AbstractTypedMap.this.getValueConverter().valueUnwrapper;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TypedEntry<EK, EV, IK, IV>
    implements Map.Entry<EK, EV> {
        private final Map.Entry<IK, IV> delegate;

        protected TypedEntry(Map.Entry<IK, IV> delegate) {
            this.delegate = delegate;
        }

        protected abstract Transformer<EK, IK> getKeyWrapper();

        protected abstract Transformer<EV, IV> getValueWrapper();

        protected abstract Transformer<IV, EV> getValueUnwrapper();

        @Override
        public EK getKey() {
            return this.getKeyWrapper().transform(this.delegate.getKey());
        }

        @Override
        public EV getValue() {
            return this.getValueWrapper().transform(this.delegate.getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EV setValue(EV value) {
            IV iv = this.getValueUnwrapper().transform(value);
            IV oldIV = this.delegate.setValue(iv);
            boolean rollback = true;
            try {
                EV ev = this.getValueWrapper().transform(oldIV);
                rollback = false;
                EV EV = ev;
                return EV;
            }
            finally {
                if (rollback) {
                    this.delegate.setValue(oldIV);
                }
            }
        }

        @Override
        public int hashCode() {
            return this.delegate.getKey().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypedCollection<E, I>
    extends AbstractCollection<E> {
        private final Collection<I> delegate;
        private final Transformer<I, E> unwrapper;
        private final Transformer<E, I> wrapper;

        private TypedCollection(Collection<I> delegate, Transformer<I, E> unwrapper, Transformer<E, I> wrapper) {
            this.delegate = delegate;
            this.unwrapper = unwrapper;
            this.wrapper = wrapper;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            Object e = o;
            I i = this.unwrapper.transform(e);
            return this.delegate.contains(i);
        }

        @Override
        public boolean addAll(Collection<? extends E> ek) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            Object e = o;
            I i = this.unwrapper.transform(e);
            return this.delegate.remove(i);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ArrayList<I> tmp = new ArrayList<I>(c.size());
            Iterator<?> i$ = c.iterator();
            while (i$.hasNext()) {
                Object o;
                Object e = o = i$.next();
                I i = this.unwrapper.transform(e);
                tmp.add(i);
            }
            return this.delegate.removeAll(tmp);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ArrayList<I> tmp = new ArrayList<I>(c.size());
            Iterator<?> i$ = c.iterator();
            while (i$.hasNext()) {
                Object o;
                Object e = o = i$.next();
                I i = this.unwrapper.transform(e);
                tmp.add(i);
            }
            return this.delegate.retainAll(tmp);
        }

        @Override
        public Iterator<E> iterator() {
            return new TypedIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class TypedIterator
        implements Iterator<E> {
            private final Iterator<I> delegate;

            public TypedIterator() {
                this.delegate = TypedCollection.this.delegate.iterator();
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public E next() {
                Object i = this.delegate.next();
                return TypedCollection.this.wrapper.transform(i);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Converter<E, I> {
        private static final Converter identity = new Converter(){

            protected Object getInternal(Object external) throws IllegalArgumentException, ClassCastException {
                return external;
            }

            protected Object getExternal(Object internal) throws IllegalArgumentException, ClassCastException {
                return internal;
            }

            protected boolean equals(Object left, Object right) {
                return left.equals(right);
            }
        };
        private final Transformer<I, E> keyUnwrapper = new Transformer<I, E>(){

            @Override
            protected I transform(E e) {
                if (e == null) {
                    throw new NullPointerException("No null input accepted");
                }
                Object i = Converter.this.getInternal(e);
                if (i == null) {
                    throw new IllegalArgumentException("The provided input " + e + " was converted to a null output");
                }
                return i;
            }
        };
        private final Transformer<E, I> keyWrapper = new Transformer<E, I>(){

            @Override
            protected E transform(I i) {
                if (i == null) {
                    throw new IllegalStateException("No null input accepted");
                }
                Object e = Converter.this.getExternal(i);
                if (e == null) {
                    throw new IllegalStateException("The provided input " + i + " was converted to a null output");
                }
                return e;
            }
        };
        private final Transformer<I, E> valueUnwrapper = new Transformer<I, E>(){

            @Override
            protected I transform(E e) {
                return Converter.this.getInternal(e);
            }
        };
        private final Transformer<E, I> valueWrapper = new Transformer<E, I>(){

            @Override
            protected E transform(I i) {
                return Converter.this.getExternal(i);
            }
        };

        public static <T> Converter<T, T> identityConverter() {
            return identity;
        }

        protected abstract I getInternal(E var1) throws IllegalArgumentException, ClassCastException;

        protected abstract E getExternal(I var1) throws IllegalArgumentException, ClassCastException;

        protected abstract boolean equals(I var1, I var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Transformer<Out, In> {
        private Transformer() {
        }

        protected abstract Out transform(In var1);
    }
}

