/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.account;

import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.ResourceValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAccountProfiles
extends UIForm {
    public UIAccountProfiles() throws Exception {
        String username = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        User useraccount = service.getUserHandler().findUserByName(username);
        UIFormStringInput userName = new UIFormStringInput("userName", "userName", username);
        userName.setEditable(false);
        this.addUIFormInput((UIFormInput)userName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(ResourceValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._\\-\\d]+$", "ResourceValidator.msg.Invalid-char"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("firstName", "firstName", useraccount.getFirstName()).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._'\\- \\d]+$", "FirstCharacterNameValidator.msg"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("lastName", "lastName", useraccount.getLastName()).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._'\\- \\d]+$", "FirstCharacterNameValidator.msg"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("email", "email", useraccount.getEmail()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIAccountProfiles> {
        public void execute(Event<UIAccountProfiles> event) throws Exception {
            UIAccountProfiles uiForm = (UIAccountProfiles)((Object)event.getSource());
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            String userName = (String)uiForm.getUIStringInput("userName").getValue();
            User user = service.getUserHandler().findUserByName(userName);
            String oldEmail = user.getEmail();
            String newEmail = (String)uiForm.getUIStringInput("email").getValue();
            Query query = new Query();
            query.setEmail(newEmail);
            if (service.getUserHandler().findUsers(query).getAll().size() > 0 && !oldEmail.equals(newEmail)) {
                user.setEmail(oldEmail);
                Object[] args = new Object[]{userName};
                uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.email-exist", args));
                return;
            }
            user.setFirstName((String)uiForm.getUIStringInput("firstName").getValue());
            user.setLastName((String)uiForm.getUIStringInput("lastName").getValue());
            user.setEmail(newEmail);
            uiApp.addMessage(new ApplicationMessage("UIAccountProfiles.msg.update.success", null));
            service.getUserHandler().saveUser(user, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResetActionListener
    extends EventListener<UIAccountProfiles> {
        public void execute(Event<UIAccountProfiles> event) throws Exception {
            UIAccountProfiles uiForm = (UIAccountProfiles)((Object)event.getSource());
            String userName = (String)uiForm.getUIStringInput("userName").getValue();
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            User user = service.getUserHandler().findUserByName(userName);
            uiForm.getUIStringInput("firstName").setValue((Object)user.getFirstName());
            uiForm.getUIStringInput("lastName").setValue((Object)user.getLastName());
            uiForm.getUIStringInput("email").setValue((Object)user.getEmail());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }
}

