/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.navigation.UINavigationManagement;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageNodeForm2;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/navigation/UINavigationNodeSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})}), @ComponentConfig(id="NavigationNodePopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={AddNodeActionListener.class}), @EventConfig(listeners={EditPageNodeActionListener.class}), @EventConfig(listeners={EditSelectedNodeActionListener.class}), @EventConfig(listeners={CopyNodeActionListener.class}), @EventConfig(listeners={CutNodeActionListener.class}), @EventConfig(listeners={CloneNodeActionListener.class}), @EventConfig(listeners={PasteNodeActionListener.class}), @EventConfig(listeners={MoveUpActionListener.class}), @EventConfig(listeners={MoveDownActionListener.class}), @EventConfig(listeners={DeleteNodeActionListener.class}, confirm="UIPageNodeSelector.deleteNavigation")}), @ComponentConfig(id="UINavigationNodeSelectorPopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={AddNodeActionListener.class}), @EventConfig(listeners={PasteNodeActionListener.class})})})
public class UINavigationNodeSelector
extends UIContainer {
    private List<PageNavigation> navigations;
    private SelectedNode selectedNode;
    private SelectedNode copyNode;
    private List<PageNavigation> deleteNavigations = new ArrayList<PageNavigation>();

    public UINavigationNodeSelector() throws Exception {
        UIRightClickPopupMenu rightClickPopup = (UIRightClickPopupMenu)((UIRightClickPopupMenu)this.addChild(UIRightClickPopupMenu.class, "UINavigationNodeSelectorPopupMenu", null)).setRendered(true);
        rightClickPopup.setActions(new String[]{"AddNode", "PasteNode"});
        UITree uiTree = (UITree)this.addChild(UITree.class, null, "TreeNodeSelector");
        uiTree.setIcon("DefaultPageIcon");
        uiTree.setSelectedIcon("DefaultPageIcon");
        uiTree.setBeanIdField("uri");
        uiTree.setBeanLabelField("resolvedLabel");
        uiTree.setBeanIconField("icon");
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.createUIComponent(UIRightClickPopupMenu.class, "NavigationNodePopupMenu", null);
        uiPopupMenu.setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CloneNode", "CutNode", "DeleteNode", "MoveUp", "MoveDown"});
        uiTree.setUIRightClickPopupMenu(uiPopupMenu);
    }

    public List<PageNavigation> getNavigations() {
        return this.navigations;
    }

    public void initNavigations(List<PageNavigation> navis) throws Exception {
        this.navigations = navis;
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.refreshNavigation(requestContext.getLocale());
        this.updateUI();
        this.selectNavigation();
    }

    public void loadNavigationByNavId(Integer navId, List<PageNavigation> navigations) throws Exception {
        this.navigations = navigations;
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.refreshNavigation(requestContext.getLocale());
        this.selectNavigation(navId);
    }

    private void updateUI() {
        if (this.navigations == null || this.navigations.size() < 1) {
            ((UITree)this.getChild(UITree.class)).setSibbling(null);
            return;
        }
    }

    private void selectNavigation() {
        if (this.navigations == null || this.navigations.size() < 1) {
            return;
        }
        if (this.selectedNode == null) {
            PageNavigation navigation = this.navigations.get(0);
            this.selectedNode = new SelectedNode(navigation, null, null);
            if (navigation.getNodes().size() > 0) {
                this.selectedNode.setNode((PageNode)navigation.getNodes().get(0));
            }
        }
        this.selectNavigation(this.selectedNode.getPageNavigation().getId());
        if (this.selectedNode.getNode() != null) {
            this.selectPageNodeByUri(this.selectedNode.getNode().getUri());
        }
    }

    public void selectNavigation(int id) {
        for (int i = 0; i < this.navigations.size(); ++i) {
            if (this.navigations.get(i).getId() != id) continue;
            this.selectedNode = new SelectedNode(this.navigations.get(i), null, null);
            this.selectPageNodeByUri(null);
            UITree uiTree = (UITree)this.getChild(UITree.class);
            uiTree.setSibbling((List)this.navigations.get(i).getNodes());
        }
    }

    public void refreshNavigation(Locale locale) {
        LocaleConfig localeConfig = ((LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class)).getLocaleConfig(locale.getLanguage());
        for (PageNavigation nav : this.navigations) {
            if (nav.getOwnerType().equals("user")) continue;
            String ownerId = nav.getOwnerId();
            if (nav.getOwnerType().equals("group")) {
                ownerId = ownerId.substring(1);
            }
            ResourceBundle res = localeConfig.getNavigationResourceBundle(nav.getOwnerType(), ownerId);
            for (PageNode node : nav.getNodes()) {
                this.resolveLabel(res, node);
            }
        }
    }

    private void resolveLabel(ResourceBundle res, PageNode node) {
        node.setResolvedLabel(res);
        if (node.getChildren() == null) {
            return;
        }
        for (PageNode childNode : node.getChildren()) {
            this.resolveLabel(res, childNode);
        }
    }

    public void selectPageNodeByUri(String uri) {
        if (this.selectedNode == null) {
            return;
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        List sibbling = tree.getSibbling();
        tree.setSibbling(null);
        tree.setParentSelected(null);
        this.selectedNode.setNode(this.searchPageNodeByUri(this.selectedNode.getPageNavigation(), uri));
        if (this.selectedNode.getNode() != null) {
            tree.setSelected((Object)this.selectedNode.getNode());
            tree.setChildren(this.selectedNode.getNode().getChildren());
            return;
        }
        tree.setSelected(null);
        tree.setChildren(null);
        tree.setSibbling(sibbling);
    }

    public PageNode searchPageNodeByUri(PageNavigation pageNav, String uri) {
        if (pageNav == null || uri == null) {
            return null;
        }
        ArrayList pageNodes = pageNav.getNodes();
        UITree uiTree = (UITree)this.getChild(UITree.class);
        for (PageNode ele : pageNodes) {
            PageNode returnPageNode = this.searchPageNodeByUri(ele, uri, uiTree);
            if (returnPageNode == null) continue;
            if (uiTree.getSibbling() == null) {
                uiTree.setSibbling((List)pageNodes);
            }
            return returnPageNode;
        }
        return null;
    }

    private PageNode searchPageNodeByUri(PageNode pageNode, String uri, UITree tree) {
        if (pageNode.getUri().equals(uri)) {
            return pageNode;
        }
        List children = pageNode.getChildren();
        if (children == null) {
            return null;
        }
        for (PageNode ele : children) {
            PageNode returnPageNode = this.searchPageNodeByUri(ele, uri, tree);
            if (returnPageNode == null) continue;
            if (tree.getSibbling() == null) {
                tree.setSibbling(children);
            }
            if (tree.getParentSelected() == null) {
                tree.setParentSelected((Object)pageNode);
            }
            this.selectedNode.setParentNode(pageNode);
            return returnPageNode;
        }
        return null;
    }

    public List<PageNavigation> getPageNavigations() {
        if (this.navigations == null) {
            this.navigations = new ArrayList<PageNavigation>();
        }
        return this.navigations;
    }

    public void addPageNavigation(PageNavigation navigation) {
        if (this.navigations == null) {
            this.navigations = new ArrayList<PageNavigation>();
        }
        this.navigations.add(navigation);
        this.updateUI();
    }

    public void deletePageNavigation(PageNavigation navigation) {
        if (this.navigations == null || this.navigations.size() < 1) {
            return;
        }
        this.navigations.remove(navigation);
        this.deleteNavigations.add(navigation);
        this.selectedNode = null;
        this.selectNavigation();
        this.updateUI();
    }

    public PageNavigation getPageNavigation(int id) {
        for (PageNavigation ele : this.getPageNavigations()) {
            if (ele.getId() != id) continue;
            return ele;
        }
        return null;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.getChild(UIRightClickPopupMenu.class);
        if (uiPopupMenu != null) {
            if (this.navigations == null || this.navigations.size() < 1) {
                uiPopupMenu.setRendered(false);
            } else {
                uiPopupMenu.setRendered(true);
            }
        }
        super.processRender(context);
    }

    public SelectedNode getCopyNode() {
        return this.copyNode;
    }

    public void setCopyNode(SelectedNode copyNode) {
        this.copyNode = copyNode;
    }

    public SelectedNode getSelectedNode() {
        return this.selectedNode;
    }

    public PageNavigation getSelectedNavigation() {
        return this.selectedNode == null ? null : this.selectedNode.getPageNavigation();
    }

    public PageNode getSelectedPageNode() {
        return this.selectedNode == null ? null : this.selectedNode.getNode();
    }

    public String getUpLevelUri() {
        return this.selectedNode.getParentNode().getUri();
    }

    public List<PageNavigation> getDeleteNavigations() {
        return this.deleteNavigations;
    }

    public static class SelectedNode {
        private PageNavigation nav;
        private PageNode parentNode;
        private PageNode node;
        private boolean deleteNode = false;
        private boolean cloneNode = false;

        public SelectedNode(PageNavigation nav, PageNode parentNode, PageNode node) {
            this.nav = nav;
            this.parentNode = parentNode;
            this.node = node;
        }

        public PageNavigation getPageNavigation() {
            return this.nav;
        }

        public void setPageNavigation(PageNavigation nav) {
            this.nav = nav;
        }

        public PageNode getParentNode() {
            return this.parentNode;
        }

        public void setParentNode(PageNode parentNode) {
            this.parentNode = parentNode;
        }

        public PageNode getNode() {
            return this.node;
        }

        public void setNode(PageNode node) {
            this.node = node;
        }

        public boolean isDeleteNode() {
            return this.deleteNode;
        }

        public void setDeleteNode(boolean deleteNode) {
            this.deleteNode = deleteNode;
        }

        public boolean isCloneNode() {
            return this.cloneNode;
        }

        public void setCloneNode(boolean b) {
            this.cloneNode = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            WebuiRequestContext pcontext = event.getRequestContext();
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UINavigationNodeSelector.class);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiNodeSelector);
            PageNavigation nav = uiNodeSelector.getSelectedNavigation();
            if (nav == null) {
                return;
            }
            PageNode[] pageNodes = PageNavigationUtils.searchPageNodesByUri(nav, uri);
            if (pageNodes == null) {
                return;
            }
            if (pageNodes[0] == null) {
                nav.getNodes().remove(pageNodes[1]);
                return;
            }
            pageNodes[0].getChildren().remove(pageNodes[1]);
            uiNodeSelector.selectPageNodeByUri(pageNodes[0].getUri());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveDownActionListener
    extends MoveUpActionListener {
        @Override
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            super.moveNode(event, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveUpActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            this.moveNode(event, -1);
        }

        protected void moveNode(Event<UIRightClickPopupMenu> event, int i) {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UINavigationNodeSelector.class);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiNodeSelector.getParent());
            PageNavigation nav = uiNodeSelector.getSelectedNavigation();
            PageNode targetNode = PageNavigationUtils.searchPageNodeByUri(nav, uri);
            Object parentNode = PageNavigationUtils.searchParentNode(nav, uri);
            List<PageNode> children = new ArrayList();
            if (parentNode instanceof PageNavigation) {
                children = ((PageNavigation)parentNode).getNodes();
            } else if (parentNode instanceof PageNode) {
                children = ((PageNode)parentNode).getChildren();
            }
            int k = children.indexOf(targetNode);
            if (k < 0) {
                return;
            }
            if (k == 0 && i == -1) {
                return;
            }
            if (k == children.size() - 1 && i == 1) {
                return;
            }
            children.remove(k);
            children.add(k + i, targetNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PasteNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            String targetUri = event.getRequestContext().getRequestParameter("objectId");
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiPopupMenu.getAncestorOfType(UINavigationNodeSelector.class);
            UINavigationManagement uiManagement = (UINavigationManagement)uiNodeSelector.getParent();
            Class[] childrenToRender = new Class[]{UINavigationNodeSelector.class};
            uiManagement.setRenderedChildrenOfTypes(childrenToRender);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagement);
            SelectedNode selectedNode = uiNodeSelector.getCopyNode();
            if (selectedNode == null) {
                return;
            }
            PageNode newNode = selectedNode.getNode().clone();
            PageNavigation targetNav = uiNodeSelector.getSelectedNavigation();
            PageNode targetNode = PageNavigationUtils.searchPageNodeByUri(targetNav, targetUri);
            if (targetNode != null && newNode.getUri().equals(targetNode.getUri())) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.paste.sameSrcAndDes", null));
                return;
            }
            if (this.isExistChild(targetNode, newNode) || targetNode == null && this.isExitChild(targetNav, newNode)) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.paste.sameName", null));
                return;
            }
            if (selectedNode.isDeleteNode()) {
                if (selectedNode.getParentNode() != null) {
                    selectedNode.getParentNode().getChildren().remove(selectedNode.getNode());
                } else {
                    selectedNode.getPageNavigation().getNodes().remove(selectedNode.getNode());
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNodeSelector);
            uiNodeSelector.setCopyNode(null);
            UITree uitree = (UITree)uiNodeSelector.getChild(UITree.class);
            UIRightClickPopupMenu popup = uitree.getUIRightClickPopupMenu();
            popup.setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CutNode", "CloneNode", "DeleteNode", "MoveUp", "MoveDown"});
            UserPortalConfigService service = (UserPortalConfigService)uiPopupMenu.getApplicationComponent(UserPortalConfigService.class);
            if (targetNode == null) {
                newNode.setUri(newNode.getName());
                targetNav.addNode(newNode);
                if (selectedNode.isCloneNode()) {
                    this.clonePageFromNode(newNode, targetNav.getOwnerType(), targetNav.getOwnerId(), service);
                }
                return;
            }
            this.setNewUri(targetNode, newNode);
            targetNode.getChildren().add(newNode);
            if (selectedNode.isCloneNode()) {
                this.clonePageFromNode(newNode, targetNav.getOwnerType(), targetNav.getOwnerId(), service);
            }
            uiNodeSelector.selectPageNodeByUri(targetNode.getUri());
        }

        private void clonePageFromNode(PageNode node, String ownerType, String ownerId, UserPortalConfigService service) throws Exception {
            List children;
            Page page;
            String pageId = node.getPageReference();
            if (pageId != null && (page = service.getPage(pageId)) != null) {
                String newName = "page" + node.hashCode();
                page = service.renewPage(pageId, newName, ownerType, ownerId);
                node.setPageReference(page.getPageId());
            }
            if ((children = node.getChildren()) == null || children.size() < 1) {
                return;
            }
            for (PageNode ele : children) {
                this.clonePageFromNode(ele, ownerType, ownerId, service);
            }
        }

        private void setNewUri(PageNode parent, PageNode child) {
            String newUri = parent != null ? parent.getUri() + "/" + child.getName() : child.getName();
            child.setUri(newUri);
            List children = child.getChildren();
            if (children != null) {
                for (PageNode node : children) {
                    this.setNewUri(child, node);
                }
            }
        }

        private boolean isExistChild(PageNode parent, PageNode child) {
            if (parent == null) {
                return false;
            }
            List nodes = parent.getChildren();
            if (nodes == null) {
                parent.setChildren(new ArrayList());
                return false;
            }
            for (PageNode node : nodes) {
                if (!node.getName().equals(child.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean isExitChild(PageNavigation nav, PageNode child) {
            ArrayList nodes = nav.getNodes();
            if (nodes.size() == 0) {
                return false;
            }
            for (PageNode node : nodes) {
                if (!node.getName().equals(child.getName())) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloneNodeActionListener
    extends CopyNodeActionListener {
        @Override
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            super.execute(event);
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UINavigationNodeSelector.class);
            uiNodeSelector.getCopyNode().setCloneNode(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CutNodeActionListener
    extends CopyNodeActionListener {
        @Override
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            super.execute(event);
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UINavigationNodeSelector.class);
            if (uiNodeSelector.getCopyNode() == null) {
                return;
            }
            uiNodeSelector.getCopyNode().setDeleteNode(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UINavigationNodeSelector.class);
            UINavigationManagement uiManagement = (UINavigationManagement)uiNodeSelector.getParent();
            Class[] childrenToRender = new Class[]{UINavigationNodeSelector.class};
            uiManagement.setRenderedChildrenOfTypes(childrenToRender);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagement);
            PageNavigation nav = uiNodeSelector.getSelectedNavigation();
            if (nav == null) {
                return;
            }
            PageNode[] pageNodes = PageNavigationUtils.searchPageNodesByUri(nav, uri);
            if (pageNodes == null) {
                return;
            }
            SelectedNode selectedNode = new SelectedNode(nav, pageNodes[0], pageNodes[1]);
            selectedNode.setDeleteNode(false);
            uiNodeSelector.setCopyNode(selectedNode);
            ((UIRightClickPopupMenu)event.getSource()).setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CloneNode", "CutNode", "PasteNode", "DeleteNode", "MoveUp", "MoveDown"});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditSelectedNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            UserACL userACL;
            Page node;
            WebuiRequestContext ctx = event.getRequestContext();
            UIRightClickPopupMenu popupMenu = (UIRightClickPopupMenu)event.getSource();
            UIApplication uiApp = ctx.getUIApplication();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)popupMenu.getAncestorOfType(UINavigationNodeSelector.class);
            PageNavigation selectedNav = uiNodeSelector.getSelectedNavigation();
            Object obj = PageNavigationUtils.searchParentNode(selectedNav, uri);
            PageNode selectedNode = PageNavigationUtils.searchPageNodeByUri(selectedNav, uri);
            String pageId = selectedNode.getPageReference();
            UserPortalConfigService service = (UserPortalConfigService)uiApp.getApplicationComponent(UserPortalConfigService.class);
            Page page = node = pageId != null ? service.getPage(pageId) : null;
            if (node != null && !(userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class)).hasPermission(node)) {
                uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.UserNotPermission", (Object[])new String[]{pageId}, 1));
                return;
            }
            UIPopupWindow uiManagementPopup = (UIPopupWindow)uiNodeSelector.getAncestorOfType(UIPopupWindow.class);
            UIPageNodeForm2 uiNodeForm = (UIPageNodeForm2)uiApp.createUIComponent(UIPageNodeForm2.class, null, null);
            uiManagementPopup.setUIComponent((UIComponent)uiNodeForm);
            uiNodeForm.setOwner(uiNodeSelector.getSelectedNavigation().getOwnerId());
            uiNodeForm.setOwnerType(uiNodeSelector.getSelectedNavigation().getOwnerType());
            uiNodeForm.setValues(selectedNode);
            uiNodeForm.setSelectedParent(obj);
            uiManagementPopup.setWindowSize(800, 500);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiManagementPopup.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditPageNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            UIPage uiPage;
            Page selectPage;
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiPopupMenu.getAncestorOfType(UINavigationNodeSelector.class);
            PageNode selectedPageNode = null;
            ArrayList pageNodes = uiNodeSelector.getSelectedNavigation().getNodes();
            if (uri != null && uri.trim().length() > 0) {
                PageNode pageNode;
                Iterator i$ = pageNodes.iterator();
                while (i$.hasNext() && (selectedPageNode = PageNavigationUtils.searchPageNodeByUri(pageNode = (PageNode)i$.next(), uri)) == null) {
                }
            }
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            if (selectedPageNode.getPageReference() == null) {
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.notAvailable", null));
                return;
            }
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)((UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class)).setRendered(true);
            UserPortalConfigService userService = (UserPortalConfigService)uiToolPanel.getApplicationComponent(UserPortalConfigService.class);
            String pageId = selectedPageNode.getPageReference();
            Page page = selectPage = pageId != null ? userService.getPage(pageId) : null;
            if (selectPage != null) {
                UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
                if (!userACL.hasEditPermission(selectPage)) {
                    uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.UserNotPermission", (Object[])new String[]{pageId}, 1));
                    return;
                }
                uiApp.setModeState(1);
                uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
                UIPortalComposer portalComposer = (UIPortalComposer)((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(true);
                portalComposer.setShowControl(true);
                portalComposer.setEditted(false);
                portalComposer.setCollapse(false);
                portalComposer.setId("UIPageEditor");
                portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
                uiToolPanel.setShowMaskLayer(false);
                uiToolPanel.setWorkingComponent(UIPage.class, null);
                uiPage = (UIPage)uiToolPanel.getUIComponent();
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                selectPage.setModifier(context.getRemoteUser());
                if (selectPage.getTitle() == null) {
                    selectPage.setTitle(selectedPageNode.getLabel());
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.notAvailable", null));
                return;
            }
            PortalDataMapper.toUIPage(uiPage, selectPage);
            Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            Util.getPortalRequestContext().setFullRender(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)uiPopupMenu.getAncestorOfType(UINavigationNodeSelector.class);
            UIPopupWindow uiManagementPopup = (UIPopupWindow)uiNodeSelector.getAncestorOfType(UIPopupWindow.class);
            UIPageNodeForm2 uiNodeForm = (UIPageNodeForm2)uiManagementPopup.createUIComponent(UIPageNodeForm2.class, null, null);
            uiNodeForm.setValues(null);
            uiManagementPopup.setUIComponent((UIComponent)uiNodeForm);
            PageNavigation parent = null;
            ArrayList pageNodes = uiNodeSelector.getSelectedNavigation().getNodes();
            if (uri != null && uri.trim().length() > 0) {
                PageNode pageNode;
                Iterator i$ = pageNodes.iterator();
                while (i$.hasNext() && (parent = PageNavigationUtils.searchPageNodeByUri(pageNode = (PageNode)i$.next(), uri)) == null) {
                }
            }
            if (parent == null) {
                parent = uiNodeSelector.getSelectedNavigation();
            }
            uiNodeForm.setSelectedParent(parent);
            uiNodeForm.setOwner(uiNodeSelector.getSelectedNavigation().getOwnerId());
            uiNodeForm.setOwnerType(uiNodeSelector.getSelectedNavigation().getOwnerType());
            uiManagementPopup.setWindowSize(800, 500);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiManagementPopup.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UINavigationNodeSelector uiNodeSelector = (UINavigationNodeSelector)((UITree)event.getSource()).getParent();
            uiNodeSelector.selectPageNodeByUri(uri);
            UINavigationManagement nodeManager = (UINavigationManagement)uiNodeSelector.getParent();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)nodeManager);
            UIContainer uiParent = (UIContainer)uiNodeSelector.getParent();
            Class[] childrenToRender = new Class[]{UINavigationNodeSelector.class};
            uiParent.setRenderedChildrenOfTypes(childrenToRender);
        }
    }
}

