/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.WindowState;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveChildActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (uiPage.isModifiable()) {
                uiPage.removeChildById(id);
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                UserPortalConfigService configService = (UserPortalConfigService)uiPage.getApplicationComponent(UserPortalConfigService.class);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                configService.update(page);
                pcontext.setFullRender(false);
                pcontext.setResponseComplete(true);
                pcontext.getWriter().write("OK");
            } else {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPage.msg.EditPermission.null", null));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteGadgetActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            WebuiRequestContext pContext = event.getRequestContext();
            String id = pContext.getRequestParameter("objectId");
            UIPage uiPage = (UIPage)((Object)event.getSource());
            ArrayList uiWidgets = new ArrayList();
            uiPage.findComponentOfType(uiWidgets, UIGadget.class);
            for (UIGadget uiWidget : uiWidgets) {
                if (!uiWidget.getId().equals(id)) continue;
                uiPage.getChildren().remove((Object)uiWidget);
                String userName = pContext.getRemoteUser();
                if (userName == null || userName.trim().length() > 0) {
                    // empty if block
                }
                if (!uiPage.isModifiable()) break;
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                UserPortalConfigService configService = (UserPortalConfigService)uiPage.getApplicationComponent(UserPortalConfigService.class);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                configService.update(page);
                break;
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.setFullRender(false);
            pcontext.setResponseComplete(true);
            pcontext.getWriter().write("OK");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangePageNodeActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            String selectedUri;
            int idx;
            PageNodeEvent pnevent = (PageNodeEvent)event;
            UIPortal uiPortal = (UIPortal)((Object)pnevent.getSource());
            UIPageBody uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            if (uiPortalApp.getModeState() != 0) {
                UserPortalConfigService configService = (UserPortalConfigService)uiPortalApp.getApplicationComponent(UserPortalConfigService.class);
                String remoteUser = Util.getPortalRequestContext().getRemoteUser();
                UserPortalConfig portalConfig = configService.getUserPortalConfig(Util.getPortalRequestContext().getPortalOwner(), remoteUser);
                uiPortal.getChildren().clear();
                PortalDataMapper.toUIPortal(uiPortal, portalConfig);
                uiPortalApp.setModeState(0);
                uiPortal.broadcast(event, event.getExecutionPhase());
                return;
            }
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            uiWorkingWS.setRenderedChild("UIViewWS");
            pcontext.setFullRender(true);
            String currentUri = uiPortal.getSelectedNode() == null ? null : uiPortal.getSelectedNode().getUri();
            PageNavigation currentNav = uiPortal.getSelectedNavigation();
            uiPortal.setSelectedNavigation(null);
            uiPortal.setSelectedNode(null);
            ArrayList<PageNode> selectedPaths_ = new ArrayList<PageNode>(5);
            List<PageNavigation> navigations = uiPortal.getNavigations();
            String uri = pnevent.getTargetNodeUri();
            if (uri == null || (uri = uri.trim()).length() < 1) {
                return;
            }
            if (uri.length() == 1 && uri.charAt(0) == '/') {
                for (PageNavigation nav : navigations) {
                    for (PageNode child : nav.getNodes()) {
                        String selectedUri2;
                        if (PageNavigationUtils.filter(child, pcontext.getRemoteUser()) == null) continue;
                        selectedPaths_.add(child);
                        uiPortal.setSelectedNode(child);
                        uiPortal.setSelectedPaths(selectedPaths_);
                        String string = selectedUri2 = uiPortal.getSelectedNode() == null ? null : uiPortal.getSelectedNode().getUri();
                        if (!currentUri.equals(selectedUri2)) {
                            this.updateLayout(uiPortal, currentNav, uiPortal.getSelectedNavigation(), uiPortalApp);
                            uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
                            if (uiPageBody.getMaximizedUIComponent() != null) {
                                UIPortlet currentPortlet = (UIPortlet)uiPageBody.getMaximizedUIComponent();
                                currentPortlet.setCurrentWindowState(WindowState.NORMAL);
                                uiPageBody.setMaximizedUIComponent(null);
                            }
                        }
                        uiPageBody.setPageBody(uiPortal.getSelectedNode(), uiPortal);
                        return;
                    }
                }
            }
            if (uri.charAt(0) == '/') {
                uri = uri.substring(1);
            }
            if ((idx = uri.lastIndexOf("::")) < 0) {
                String selectedUri3;
                PageNode selectedNode = null;
                for (PageNavigation nav : navigations) {
                    PageNode tempNode;
                    String[] nodeNames = uri.split("/");
                    int i = 0;
                    selectedNode = tempNode = nav.getNode(nodeNames[i]);
                    while (tempNode != null && ++i < nodeNames.length) {
                        selectedNode = tempNode;
                        selectedPaths_.add(selectedNode);
                        tempNode = tempNode.getChild(nodeNames[i]);
                    }
                    if (tempNode != null) {
                        selectedNode = tempNode;
                        selectedPaths_.add(selectedNode);
                    }
                    if (selectedNode == null) continue;
                    uiPortal.setSelectedNavigation(nav);
                    break;
                }
                if (selectedNode == null) {
                    block4: for (PageNavigation nav : navigations) {
                        for (PageNode child : nav.getNodes()) {
                            if (PageNavigationUtils.filter(child, pcontext.getRemoteUser()) == null) continue;
                            selectedNode = child;
                            break block4;
                        }
                    }
                }
                uiPortal.setSelectedNode(selectedNode);
                if (selectedNode == null) {
                    selectedPaths_.add(uiPortal.getSelectedNode());
                }
                uiPortal.setSelectedPaths(selectedPaths_);
                String string = selectedUri3 = uiPortal.getSelectedNode() == null ? null : uiPortal.getSelectedNode().getUri();
                if (currentUri != null && !currentUri.equals(selectedUri3)) {
                    this.updateLayout(uiPortal, currentNav, uiPortal.getSelectedNavigation(), uiPortalApp);
                    uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
                    if (uiPageBody.getMaximizedUIComponent() != null) {
                        UIPortlet currentPortlet = (UIPortlet)uiPageBody.getMaximizedUIComponent();
                        currentPortlet.setCurrentWindowState(WindowState.NORMAL);
                        uiPageBody.setMaximizedUIComponent(null);
                    }
                }
                uiPageBody.setPageBody(uiPortal.getSelectedNode(), uiPortal);
                return;
            }
            String navId = uri.substring(0, idx);
            uri = uri.substring(idx + 2, uri.length());
            PageNavigation nav = null;
            for (PageNavigation ele : navigations) {
                if (ele.getId() != Integer.parseInt(navId)) continue;
                nav = ele;
                break;
            }
            if (nav != null) {
                PageNode tempNode;
                String[] nodeNames = uri.split("/");
                int i = 0;
                PageNode selecttedNode = tempNode = nav.getNode(nodeNames[i]);
                while (tempNode != null && ++i < nodeNames.length) {
                    selecttedNode = tempNode;
                    selectedPaths_.add(selecttedNode);
                    tempNode = tempNode.getChild(nodeNames[i]);
                }
                if (tempNode != null) {
                    selecttedNode = tempNode;
                    selectedPaths_.add(selecttedNode);
                }
                uiPortal.setSelectedNode(selecttedNode);
                uiPortal.setSelectedNavigation(nav);
            }
            pcontext.getJavascriptManager().addCustomizedOnLoadScript((CharSequence)("document.title='" + uiPortal.getSelectedNode().getResolvedLabel().replaceAll("'", "\\\\'") + "';"));
            uiPortal.setSelectedPaths(selectedPaths_);
            String string = selectedUri = uiPortal.getSelectedNode() == null ? null : uiPortal.getSelectedNode().getUri();
            if (!currentUri.equals(selectedUri) && uiPageBody.getMaximizedUIComponent() != null) {
                UIPortlet currentPortlet = (UIPortlet)uiPageBody.getMaximizedUIComponent();
                currentPortlet.setCurrentWindowState(WindowState.NORMAL);
                uiPageBody.setMaximizedUIComponent(null);
            }
            uiPageBody.setPageBody(uiPortal.getSelectedNode(), uiPortal);
        }

        private void updateLayout(UIPortal uiPortal, PageNavigation formerNav, PageNavigation newNav, UIPortalApplication uiPortalApp) throws Exception {
            if (formerNav == null || newNav == null) {
                return;
            }
            String newOwnerType = newNav.getOwnerType();
            String newOwnerId = newNav.getOwnerId();
            String formerOwnerType = formerNav.getOwnerType();
            String formerOwnerId = formerNav.getOwnerId();
            if (newOwnerId.equals(formerOwnerId) && formerOwnerType.equals(newOwnerType)) {
                return;
            }
            DataStorage storage = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
            PortalConfig pConfig = storage.getPortalConfig(newOwnerType, newOwnerId);
            Container container = pConfig.getPortalLayout();
            if (container != null) {
                UserPortalConfig portalConfig = uiPortalApp.getUserPortalConfig();
                portalConfig.setPortal(pConfig);
                this.rebuildUIPortal(uiPortal, portalConfig);
            }
        }

        private void rebuildUIPortal(UIPortal uiPortal, UserPortalConfig portalConfig) throws Exception {
            PageNode backupSelectedNode = uiPortal.getSelectedNode();
            PageNavigation backupSelectedNavigation = uiPortal.getSelectedNavigation();
            List<PageNode> backupSelectedPaths = uiPortal.getSelectedPaths();
            uiPortal.getChildren().clear();
            PortalDataMapper.toUIPortal(uiPortal, portalConfig);
            uiPortal.setSelectedNode(backupSelectedNode);
            uiPortal.setSelectedNavigation(backupSelectedNavigation);
            uiPortal.setSelectedPaths(backupSelectedPaths);
        }
    }
}

