/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.commons.utils.PropertiesLoader;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class PropertyConfigurator
implements Startable {
    private final Log log = ExoLogger.getExoLogger(PropertyConfigurator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyConfigurator(InitParams params, ConfigurationManager confManager) {
        String systemPath;
        PropertiesParam propertiesParam = params.getPropertiesParam("properties");
        if (propertiesParam != null) {
            this.log.debug((Object)"Going to initialize properties from init param");
            Iterator<Property> i = propertiesParam.getPropertyIterator();
            while (i.hasNext()) {
                Property property = i.next();
                String name = property.getName();
                String value = property.getValue();
                this.log.debug((Object)("Adding property from init param " + name + " = " + value));
                PropertyManager.setProperty((String)name, (String)value);
            }
        }
        String path = null;
        ValueParam pathParam = params.getValueParam("properties.url");
        if (pathParam != null) {
            this.log.debug((Object)("Using file path " + path + " found from configuration"));
            path = pathParam.getValue();
        }
        if ((systemPath = PropertyManager.getProperty((String)"exo.properties.url")) != null) {
            this.log.debug((Object)("Using file path " + path + " found from system properties"));
            path = systemPath;
        }
        if (path != null) {
            this.log.debug((Object)("Found property file path " + path));
            InputStream in = null;
            try {
                URL url = confManager.getURL(path);
                if (url != null) {
                    in = url.openStream();
                }
                if (in != null) {
                    LinkedHashMap props = null;
                    String fileName = url.getFile();
                    if (Tools.endsWithIgnoreCase((String)path, (String)".properties")) {
                        this.log.debug((Object)("Attempt to load property file " + path));
                        props = PropertiesLoader.load((InputStream)in);
                    } else if (Tools.endsWithIgnoreCase((String)fileName, (String)".xml")) {
                        this.log.debug((Object)("Attempt to load property file " + path + " with XML format"));
                        props = PropertiesLoader.loadFromXML((InputStream)in);
                    } else {
                        this.log.debug((Object)("Will not load property file" + path + " because its format is not recognized"));
                    }
                    if (props != null) {
                        for (Map.Entry entry : props.entrySet()) {
                            String propertyName = (String)entry.getKey();
                            String propertyValue = (String)entry.getValue();
                            propertyValue = Deserializer.resolveString(propertyValue);
                            PropertyManager.setProperty((String)propertyName, (String)propertyValue);
                        }
                    }
                } else {
                    this.log.error((Object)("Could not load property file " + path));
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Cannot load property file " + path), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

