/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIPopupMessages.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPopupMessages
extends UIPopupWindow {
    private List<ApplicationMessage> errors_ = new ArrayList<ApplicationMessage>();
    private List<ApplicationMessage> warnings_ = new ArrayList<ApplicationMessage>();
    private List<ApplicationMessage> infos_ = new ArrayList<ApplicationMessage>();

    public UIPopupMessages() {
        this.setShow(true);
    }

    public List<ApplicationMessage> getErrors() {
        return this.errors_;
    }

    public void setErrors(List<ApplicationMessage> errors_) {
        this.errors_ = errors_;
    }

    public List<ApplicationMessage> getInfos() {
        return this.infos_;
    }

    public void setInfos(List<ApplicationMessage> infos_) {
        this.infos_ = infos_;
    }

    public List<ApplicationMessage> getWarnings() {
        return this.warnings_;
    }

    public void setWarnings(List<ApplicationMessage> warnings_) {
        this.warnings_ = warnings_;
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public void addMessage(ApplicationMessage msg) {
        switch (msg.getType()) {
            case 0: {
                this.errors_.add(msg);
                break;
            }
            case 1: {
                this.warnings_.add(msg);
                break;
            }
            default: {
                this.infos_.add(msg);
            }
        }
    }

    public boolean hasMessage() {
        return this.errors_.size() > 0 || this.warnings_.size() > 0 || this.infos_.size() > 0;
    }

    public void clearMessages() {
        this.errors_.clear();
        this.warnings_.clear();
        this.infos_.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPopupMessages> {
        @Override
        public void execute(Event<UIPopupMessages> event) throws Exception {
            UIPopupMessages uiPopupMessage = event.getSource();
            uiPopupMessage.clearMessages();
            WebuiRequestContext context = event.getRequestContext();
            if (uiPopupMessage.getParent() == null) {
                context.addUIComponentToUpdateByAjax(uiPopupMessage);
                return;
            }
            if (!uiPopupMessage.isShow()) {
                return;
            }
            Object uiParent = uiPopupMessage.getParent();
            context.addUIComponentToUpdateByAjax((UIComponent)uiParent);
            Event<UIComponent> pEvent = ((UIComponent)uiParent).createEvent("ClosePopup", event.getExecutionPhase(), event.getRequestContext());
            if (pEvent != null) {
                pEvent.broadcast();
            }
        }
    }
}

