/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIFormInputBase<T>
extends UIContainer
implements UIFormInput<T> {
    public static final boolean ENABLE = true;
    public static final boolean DISABLE = false;
    protected String name;
    private String label;
    protected String bindingField;
    protected List<Validator> validators;
    protected T defaultValue_;
    protected T value_;
    protected Class<T> typeValue_;
    protected boolean enable_ = true;
    protected boolean readonly_ = false;

    public UIFormInputBase(String name, String bindingField, Class<T> typeValue) {
        this.name = name;
        this.bindingField = bindingField;
        this.typeValue_ = typeValue;
        this.setId(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getBindingField() {
        return this.bindingField;
    }

    public void setBindingField(String s) {
        this.bindingField = s;
    }

    public T getDefaultValue() {
        return this.defaultValue_;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue_ = defaultValue;
    }

    @Override
    public T getValue() {
        return this.value_;
    }

    @Override
    public UIFormInput setValue(T value) {
        this.value_ = value;
        return this;
    }

    @Override
    public Class<T> getTypeValue() {
        return this.typeValue_;
    }

    @Override
    public void reset() {
        this.value_ = this.defaultValue_;
    }

    public boolean isEnable() {
        return this.enable_;
    }

    public UIFormInputBase<T> setEnable(boolean enable) {
        this.enable_ = enable;
        return this;
    }

    public boolean isEditable() {
        return !this.readonly_;
    }

    public UIFormInputBase<T> setEditable(boolean editable) {
        this.readonly_ = !editable;
        return this;
    }

    public boolean isValid() {
        return this.isRendered() && this.isEditable() && this.isEnable();
    }

    @Override
    public <E extends Validator> UIFormInputBase<T> addValidator(Class<E> clazz, Object ... params) throws Exception {
        if (this.validators == null) {
            this.validators = new ArrayList<Validator>(3);
        }
        if (params.length > 0) {
            Class[] classes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classes[i] = params[i].getClass();
            }
            Constructor<E> constructor = clazz.getConstructor(classes);
            this.validators.add((Validator)constructor.newInstance(params));
            return this;
        }
        this.validators.add((Validator)clazz.newInstance());
        return this;
    }

    @Override
    public List<Validator> getValidators() {
        return this.validators;
    }

    @Override
    public final void processDecode(WebuiRequestContext context) throws Exception {
        UIForm uiForm = this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        Event<UIComponent> event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public boolean isMandatory() {
        if (this.validators == null) {
            return false;
        }
        for (Validator validator : this.validators) {
            if (!(validator instanceof MandatoryValidator)) continue;
            return true;
        }
        return false;
    }

    public abstract void decode(Object var1, WebuiRequestContext var2) throws Exception;

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

