/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.CharEncoder;
import org.exoplatform.commons.utils.CharsetCharEncoder;
import org.exoplatform.commons.utils.CharsetTextEncoder;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.TableCharEncoder;
import org.exoplatform.commons.utils.TextEncoder;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.portal.application.Image;
import org.exoplatform.portal.application.ImageType;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ResourceRequestFilter
extends AbstractFilter {
    protected static Log log = ExoLogger.getLogger((String)"portal:ResourceRequestFilter");
    private FilterConfig cfg;
    private ImageType[] imageTypes = ImageType.values();
    private ConcurrentMap<String, FutureTask<Image>> mirroredImageCache = new ConcurrentHashMap<String, FutureTask<Image>>();
    private ExoCache cssCache = new ConcurrentFIFOExoCache(50);
    private static final TextEncoder encoder = new CharsetTextEncoder((CharEncoder)new TableCharEncoder(CharsetCharEncoder.getUTF8()));

    public void afterInit(FilterConfig filterConfig) {
        this.cfg = filterConfig;
        log.info((Object)("Cache eXo Resource at client: " + !PropertyManager.isDevelopping()));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        final String uri = URLDecoder.decode(httpRequest.getRequestURI(), "UTF-8");
        final HttpServletResponse httpResponse = (HttpServletResponse)response;
        ExoContainer portalContainer = this.getContainer();
        SkinService skinService = (SkinService)portalContainer.getComponentInstanceOfType(SkinService.class);
        if (uri.endsWith(".css")) {
            ServletOutputStream out = response.getOutputStream();
            final Appendable app = new Appendable((OutputStream)out){
                final /* synthetic */ OutputStream val$out;
                {
                    this.val$out = outputStream;
                }

                public Appendable append(CharSequence csq) throws IOException {
                    String s = (String)csq;
                    byte[] bytes = null;
                    try {
                        bytes = (byte[])ResourceRequestFilter.this.cssCache.get((Serializable)((Object)s));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (bytes == null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(s.length() * 2);
                        encoder.encode(s, 0, s.length(), (OutputStream)baos);
                        baos.flush();
                        bytes = baos.toByteArray();
                        try {
                            ResourceRequestFilter.this.cssCache.put((Serializable)((Object)s), (Object)bytes);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        this.val$out.write(bytes);
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    return this;
                }

                public Appendable append(CharSequence csq, int start, int end) throws IOException {
                    throw new UnsupportedOperationException("Should no be called");
                }

                public Appendable append(char c) throws IOException {
                    encoder.encode(c, this.val$out);
                    return this;
                }
            };
            ResourceRenderer renderer = new ResourceRenderer(){

                public Appendable getAppendable() {
                    return app;
                }

                public void setExpiration(long seconds) {
                    if (seconds > 0L) {
                        httpResponse.addHeader("Cache-Control", "max-age=" + seconds + ",s-maxage=" + seconds);
                    } else {
                        httpResponse.setHeader("Cache-Control", "no-cache");
                    }
                }
            };
            try {
                skinService.renderCSS(renderer, uri);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Use a merged CSS: " + uri));
                }
            }
            catch (Exception e) {
                log.error((Object)("Could not render css " + uri), (Throwable)e);
                httpResponse.setStatus(404);
            }
        } else {
            int len = uri.length();
            if (len >= 7 && uri.charAt(len - 7) == '-' && uri.charAt(len - 6) == 'r' && uri.charAt(len - 5) == 't') {
                for (final ImageType imageType : this.imageTypes) {
                    FutureTask<Image> tmp;
                    if (!imageType.matches(uri)) continue;
                    final String resource = uri.substring(httpRequest.getContextPath().length(), len - 7) + uri.substring(len - 4);
                    FutureTask<Image> futureImg = (FutureTask<Image>)this.mirroredImageCache.get(resource);
                    if (futureImg == null && (futureImg = this.mirroredImageCache.putIfAbsent(resource, tmp = new FutureTask<Image>(new Callable<Image>(){

                        @Override
                        public Image call() throws Exception {
                            InputStream in = ResourceRequestFilter.this.cfg.getServletContext().getResourceAsStream(resource);
                            if (in == null) {
                                return null;
                            }
                            BufferedImage img = ImageIO.read(in);
                            log.debug((Object)("Read image " + uri + " (" + img.getWidth() + "," + img.getHeight() + ")"));
                            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                            tx.translate(-img.getWidth(null), 0.0);
                            AffineTransformOp op = new AffineTransformOp(tx, 1);
                            img = op.filter(img, null);
                            log.debug((Object)("Mirrored image " + uri + " (" + img.getWidth() + "," + img.getHeight() + ")"));
                            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                            ImageIO.write((RenderedImage)img, imageType.getFormat(), baos);
                            baos.close();
                            return new Image(imageType, baos.toByteArray());
                        }
                    }))) == null) {
                        futureImg = tmp;
                        futureImg.run();
                    }
                    try {
                        Image img = (Image)futureImg.get();
                        if (img != null) {
                            httpResponse.setContentType(img.type.getMimeType());
                            httpResponse.setContentLength(img.bytes.length);
                            ServletOutputStream out = httpResponse.getOutputStream();
                            out.write(img.bytes);
                            out.close();
                        } else {
                            this.mirroredImageCache.remove(resource);
                            httpResponse.setStatus(404);
                        }
                        return;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        this.mirroredImageCache.remove(resource);
                    }
                }
            }
            if (!PropertyManager.isDevelopping()) {
                httpResponse.addHeader("Cache-Control", "max-age=2592000,s-maxage=2592000");
            } else {
                if (uri.endsWith(".jstmpl") || uri.endsWith(".js")) {
                    httpResponse.setHeader("Cache-Control", "no-cache");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Load Resource: " + uri));
                }
            }
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

