/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.exoplatform.portal.webui.application.EventsWrapper;
import org.exoplatform.portal.webui.application.ExoPortletInstanceContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.application.UIPortletForm;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPortletActionListener {
    public static final String PORTLET_EVENTS = "PortletEvents";
    protected static Log log = ExoLogger.getLogger((String)"portal:UIPortletActionListener");

    public static void setNextState(UIPortlet uiPortlet, WindowState state) {
        if (state != null) {
            UIPage uiPage = (UIPage)uiPortlet.getAncestorOfType(UIPage.class);
            if (state == WindowState.MAXIMIZED) {
                uiPortlet.setCurrentWindowState(WindowState.MAXIMIZED);
                if (uiPage != null) {
                    uiPage.setMaximizedUIPortlet(uiPortlet);
                }
            } else if (state == WindowState.MINIMIZED) {
                uiPortlet.setCurrentWindowState(WindowState.MINIMIZED);
                if (uiPage != null) {
                    uiPage.setMaximizedUIPortlet(null);
                }
            } else {
                uiPortlet.setCurrentWindowState(WindowState.NORMAL);
                if (uiPage != null) {
                    uiPage.setMaximizedUIPortlet(null);
                }
            }
        }
    }

    public static void setNextMode(UIPortlet uiPortlet, PortletMode portletMode) {
        if (portletMode != null) {
            if (portletMode.equals((Object)PortletMode.HELP)) {
                uiPortlet.setCurrentPortletMode(PortletMode.HELP);
            } else if (portletMode.equals((Object)PortletMode.EDIT)) {
                uiPortlet.setCurrentPortletMode(PortletMode.EDIT);
            } else {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
        }
    }

    public static <S, C extends Serializable, I> List<javax.portlet.Event> processEvent(UIPortlet<S, C> uiPortlet, javax.portlet.Event event) {
        log.info((Object)("Process Event: " + event.getName() + " for portlet: " + uiPortlet.getState()));
        try {
            PortalRequestContext context = (PortalRequestContext)WebuiRequestContext.getCurrentInstance();
            EventInvocation eventInvocation = uiPortlet.create(EventInvocation.class, context);
            eventInvocation.setName(event.getQName());
            eventInvocation.setPayload(event.getValue());
            PortletInvocationResponse piResponse = uiPortlet.invoke((PortletInvocation)eventInvocation);
            ExoPortletInstanceContext instanceCtx = (ExoPortletInstanceContext)eventInvocation.getInstanceContext();
            if (instanceCtx.getModifiedContext() != null) {
                StatefulPortletContext updatedCtx = (StatefulPortletContext)instanceCtx.getModifiedContext();
                Serializable portletState = updatedCtx.getState();
                uiPortlet.update(portletState);
            }
            if (!(piResponse instanceof UpdateNavigationalStateResponse)) {
                if (piResponse instanceof ErrorResponse) {
                    ErrorResponse errorResponse = (ErrorResponse)piResponse;
                    throw (Exception)errorResponse.getCause();
                }
                throw new Exception("Unexpected response type [" + piResponse + "]. Expected a UpdateNavigationResponse or an ErrorResponse.");
            }
            UpdateNavigationalStateResponse navResponse = (UpdateNavigationalStateResponse)piResponse;
            WindowState state = new WindowState(UIPortletActionListener.getWindowStateOrDefault(navResponse));
            UIPortletActionListener.setNextState(uiPortlet, state);
            PortletMode mode = new PortletMode(UIPortletActionListener.getPortletModeOrDefault(navResponse));
            UIPortletActionListener.setNextMode(uiPortlet, mode);
            List nsEvents = navResponse.getEvents();
            ArrayList<javax.portlet.Event> events = new ArrayList<javax.portlet.Event>(nsEvents.size());
            if (nsEvents != null && !nsEvents.isEmpty()) {
                for (UpdateNavigationalStateResponse.Event nsEvent : nsEvents) {
                    class PortletEvent
                    implements javax.portlet.Event {
                        QName qName;
                        Serializable value;

                        public PortletEvent(QName qName, Serializable value) {
                            this.qName = qName;
                            this.value = value;
                        }

                        public String getName() {
                            return this.qName.getLocalPart();
                        }

                        public QName getQName() {
                            return this.qName;
                        }

                        public Serializable getValue() {
                            return this.value;
                        }
                    }
                    PortletEvent portletEvent = new PortletEvent(nsEvent.getName(), nsEvent.getPayload());
                    events.add(portletEvent);
                }
            }
            return events;
        }
        catch (Exception e) {
            log.error((Object)("Problem while processesing event for the portlet: " + uiPortlet.getState()), (Throwable)e);
            return null;
        }
    }

    private static String getPortletModeOrDefault(UpdateNavigationalStateResponse navResponse) {
        Mode mode = navResponse.getMode();
        if (mode == null) {
            mode = Mode.VIEW;
        }
        return mode.toString();
    }

    private static String getWindowStateOrDefault(UpdateNavigationalStateResponse navResponse) {
        org.gatein.pc.api.WindowState state = navResponse.getWindowState();
        if (state == null) {
            state = org.gatein.pc.api.WindowState.NORMAL;
        }
        return state.toString();
    }

    public static void setupPublicRenderParams(UIPortlet uiPortlet, Map<String, String[]> requestParams) {
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        for (String key : requestParams.keySet()) {
            if (!uiPortlet.supportsPublicParam(key)) continue;
            publicParams.put(key, requestParams.get(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditPortletActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUpdated(true);
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            UIPortletForm uiPortletForm = uiMaskWS.createUIComponent(UIPortletForm.class, null, null);
            uiPortletForm.setValues(uiPortlet);
            uiMaskWS.setWindowSize(800, -1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangePortletModeActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            String portletMode = event.getRequestContext().getRequestParameter("portal:portletMode");
            if (portletMode == null) {
                portletMode = event.getRequestContext().getRequestParameter("objectId");
            }
            log.info((Object)("Change portlet mode of " + uiPortlet.getPortletContext().getId() + " to " + portletMode));
            if (portletMode.equals(PortletMode.HELP.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.HELP);
            } else if (portletMode.equals(PortletMode.EDIT.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.EDIT);
            } else {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortlet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeWindowStateActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet maxPortlet;
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortlet.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
            String windowState = event.getRequestContext().getRequestParameter("portal:windowState");
            if (windowState == null) {
                windowState = event.getRequestContext().getRequestParameter("objectId").trim();
            }
            UIPageBody uiPageBody = (UIPageBody)uiPortlet.getAncestorOfType(UIPageBody.class);
            UIPage uiPage = (UIPage)uiPortlet.getAncestorOfType(UIPage.class);
            if (windowState.equals(WindowState.MAXIMIZED.toString())) {
                if (uiPageBody != null) {
                    uiPortlet.setCurrentWindowState(WindowState.MAXIMIZED);
                    if (uiPage != null && uiPage.isShowMaxWindow()) {
                        uiPage.setMaximizedUIPortlet(uiPortlet);
                    }
                    uiPageBody.setMaximizedUIComponent(uiPortlet);
                } else {
                    uiPortlet.setCurrentWindowState(WindowState.NORMAL);
                }
                return;
            }
            if (uiPageBody != null && (maxPortlet = (UIPortlet)uiPageBody.getMaximizedUIComponent()) == uiPortlet) {
                uiPageBody.setMaximizedUIComponent(null);
            }
            if (uiPage != null && (maxPortlet = uiPage.getMaximizedUIPortlet()) == uiPortlet) {
                uiPage.setMaximizedUIPortlet(null);
            }
            if (windowState.equals(WindowState.MINIMIZED.toString())) {
                uiPortlet.setCurrentWindowState(WindowState.MINIMIZED);
                return;
            }
            uiPortlet.setCurrentWindowState(WindowState.NORMAL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenderActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            uiPortlet.setNavigationalState(null);
            HttpServletRequest request = (HttpServletRequest)event.getRequestContext().getRequest();
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, request.getParameterMap());
            String navState = ((PortalRequestContext)event.getRequestContext()).getRequestParameter("navigationalstate");
            uiPortlet.setNavigationalState(ParametersStateString.create((String)navState));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessEventsActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            PortalRequestContext context = (PortalRequestContext)event.getRequestContext();
            ArrayList portletInstancesInPage = new ArrayList();
            UIPortalApplication uiPortal = (UIPortalApplication)context.getUIApplication();
            uiPortal.findComponentOfType(portletInstancesInPage, UIPortlet.class);
            EventsWrapper eventsWrapper = (EventsWrapper)event.getRequestContext().getAttribute(UIPortletActionListener.PORTLET_EVENTS);
            List<javax.portlet.Event> events = eventsWrapper.getEvents();
            while (events.size() > 0) {
                javax.portlet.Event nativeEvent = events.remove(0);
                QName eventName = nativeEvent.getQName();
                for (UIPortlet uiPortletInPage : portletInstancesInPage) {
                    if (!uiPortletInPage.supportsProcessingEvent(eventName) || eventsWrapper.isInvokedTooManyTimes(uiPortletInPage)) continue;
                    List<javax.portlet.Event> newEvents = UIPortletActionListener.processEvent(uiPortletInPage, nativeEvent);
                    eventsWrapper.increaseCounter(uiPortletInPage);
                    if (context.useAjax()) {
                        log.info((Object)"Events were generated inside the scope of an AJAX call, hence will only refresh the targeted portlets");
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortletInPage);
                    } else {
                        log.info((Object)"Events were generated outside the scope of an AJAX call, hence will make a full render of the page");
                        context.setFullRender(true);
                    }
                    if (newEvents == null || newEvents.isEmpty()) continue;
                    log.info((Object)("The portlet: " + uiPortletInPage.getPortletContext().getId() + " processEvent() method has generated new events itself"));
                    events.addAll(newEvents);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServeResourceActionListener<S, C extends Serializable, I>
    extends EventListener<UIPortlet<S, C>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIPortlet<S, C>> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            log.info((Object)("Serve Resource for portlet: " + uiPortlet.getPortletContext()));
            try {
                String contentType;
                PortalRequestContext context = (PortalRequestContext)event.getRequestContext();
                HttpServletResponse response = context.getResponse();
                ResourceInvocation resourceInvocation = uiPortlet.create(ResourceInvocation.class, context);
                PortletInvocationResponse portletResponse = uiPortlet.invoke((PortletInvocation)resourceInvocation);
                if (!(portletResponse instanceof ContentResponse)) {
                    if (portletResponse instanceof ErrorResponse) {
                        ErrorResponse errorResponse = (ErrorResponse)portletResponse;
                        throw (Exception)errorResponse.getCause();
                    }
                    throw new Exception("Unexpected response type [" + portletResponse + "]. Expected a ContentResponse or an ErrorResponse.");
                }
                ContentResponse piResponse = (ContentResponse)portletResponse;
                if (piResponse.getProperties() != null && piResponse.getProperties().getTransportHeaders() != null) {
                    MultiValuedPropertyMap transportHeaders = piResponse.getProperties().getTransportHeaders();
                    HashMap<String, String> headers = new HashMap<String, String>();
                    for (String key : transportHeaders.keySet()) {
                        for (String value : transportHeaders.getValues(key)) {
                            headers.put(key, value);
                        }
                    }
                    context.setHeaders(headers);
                }
                if ((contentType = piResponse.getContentType()) == null) {
                    return;
                }
                log.info((Object)("Try to get a resource of type: " + contentType + " for the portlet: " + uiPortlet.getPortletContext()));
                if (contentType.startsWith("text")) {
                    context.getResponse().setContentType(contentType);
                    context.getWriter().write(piResponse.getContent());
                } else {
                    response.setContentType(contentType);
                    ServletOutputStream stream = response.getOutputStream();
                    stream.write(piResponse.getBytes());
                }
                context.getResponse().flushBuffer();
            }
            catch (Exception e) {
                log.error((Object)("Problem while serving resource for the portlet: " + uiPortlet.getPortletContext().getId()), (Throwable)e);
            }
            finally {
                event.getRequestContext().setResponseComplete(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessActionActionListener<S, C extends Serializable, I>
    extends EventListener<UIPortlet<S, C>> {
        public void execute(Event<UIPortlet<S, C>> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            PortalRequestContext prcontext = (PortalRequestContext)event.getRequestContext();
            HttpServletRequest request = prcontext.getRequest();
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, request.getParameterMap());
            ActionInvocation actionInvocation = uiPortlet.create(ActionInvocation.class, prcontext);
            if (actionInvocation == null) {
                return;
            }
            PortletInvocationResponse portletResponse = uiPortlet.invoke((PortletInvocation)actionInvocation);
            ExoPortletInstanceContext instanceCtx = (ExoPortletInstanceContext)actionInvocation.getInstanceContext();
            if (instanceCtx.getModifiedContext() != null) {
                StatefulPortletContext updatedCtx = (StatefulPortletContext)instanceCtx.getModifiedContext();
                Serializable portletState = updatedCtx.getState();
                uiPortlet.update(portletState);
            } else {
                PortletContext clonedContext = instanceCtx.getClonedContext();
                if (clonedContext != null) {
                    WSRP wsrp = new WSRP();
                    wsrp.setPortletId(clonedContext.getId());
                    if (clonedContext instanceof StatefulPortletContext) {
                        StatefulPortletContext statefulPortletContext = (StatefulPortletContext)clonedContext;
                        wsrp.setState((byte[])statefulPortletContext.getState());
                    }
                    uiPortlet.update(wsrp);
                }
            }
            if (!(portletResponse instanceof UpdateNavigationalStateResponse)) {
                if (portletResponse instanceof ErrorResponse) {
                    ErrorResponse errorResponse = (ErrorResponse)portletResponse;
                    throw (Exception)errorResponse.getCause();
                }
                throw new Exception("Unexpected response type [" + portletResponse + "]. Expected a UpdateNavigationResponse or an ErrorResponse.");
            }
            UpdateNavigationalStateResponse navStateResponse = (UpdateNavigationalStateResponse)portletResponse;
            WindowState state = new WindowState(UIPortletActionListener.getWindowStateOrDefault(navStateResponse));
            UIPortletActionListener.setNextState(uiPortlet, state);
            PortletMode mode = new PortletMode(UIPortletActionListener.getPortletModeOrDefault(navStateResponse));
            UIPortletActionListener.setNextMode(uiPortlet, mode);
            StateString navigationalState = navStateResponse.getNavigationalState();
            uiPortlet.setNavigationalState(navigationalState);
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, navStateResponse.getPublicNavigationalStateUpdates());
            List nsEvents = navStateResponse.getEvents();
            ArrayList<javax.portlet.Event> events = new ArrayList<javax.portlet.Event>(nsEvents.size());
            if (nsEvents != null && !nsEvents.isEmpty()) {
                for (UpdateNavigationalStateResponse.Event nsEvent : nsEvents) {
                    if (!uiPortlet.supportsPublishingEvent(nsEvent.getName())) continue;
                    class PortletEvent
                    implements javax.portlet.Event {
                        QName qName;
                        Serializable value;

                        public PortletEvent(QName qName, Serializable value) {
                            this.qName = qName;
                            this.value = value;
                        }

                        public String getName() {
                            return this.qName.getLocalPart();
                        }

                        public QName getQName() {
                            return this.qName;
                        }

                        public Serializable getValue() {
                            return this.value;
                        }
                    }
                    PortletEvent portletEvent = new PortletEvent(nsEvent.getName(), nsEvent.getPayload());
                    events.add(portletEvent);
                }
            }
            if (events != null) {
                prcontext.setAttribute(UIPortletActionListener.PORTLET_EVENTS, new EventsWrapper(events));
                uiPortlet.createEvent("ProcessEvents", Event.Phase.PROCESS, prcontext).broadcast();
            }
        }
    }
}

