/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.jcr.MergeException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataMergeVisitor
extends ItemDataTraversingVisitor {
    protected static int NONE = -1;
    protected static int LEAVE = 0;
    protected static int FAIL = 1;
    protected static int UPDATE = 2;
    protected static Log log = ExoLogger.getLogger((String)"jcr.ItemDataMergeVisitor");
    protected final SessionImpl mergeSession;
    protected final SessionImpl corrSession;
    protected final Map<String, String> failed;
    protected final boolean bestEffort;
    protected final Stack<ContextParent> parents = new Stack();
    protected final SessionChangesLog changes;

    public ItemDataMergeVisitor(SessionImpl mergeSession, SessionImpl corrSession, Map<String, String> failed, boolean bestEffort) {
        super(mergeSession.getTransientNodesManager().getTransactManager());
        this.corrSession = corrSession;
        this.mergeSession = mergeSession;
        this.bestEffort = bestEffort;
        this.failed = failed;
        this.changes = new SessionChangesLog(mergeSession.getId());
    }

    @Override
    protected void entering(NodeData mergeNode, int level) throws RepositoryException {
        if (level == 0) {
            this.doMerge((TransientNodeData)mergeNode);
        } else if (this.parents.size() > 0) {
            ContextParent context = this.parents.peek();
            if (context.getResult() == UPDATE) {
                if (context.getCorrChildNodes().remove(mergeNode)) {
                    this.doMerge((TransientNodeData)mergeNode);
                } else {
                    this.changes.add(new ItemState(((TransientNodeData)mergeNode).clone(), 4, true, context.getParent().getQPath(), true));
                }
            } else if (context.getResult() == LEAVE) {
                this.doMerge((TransientNodeData)mergeNode);
            } else {
                log.warn((Object)("Result is undefined for merge node " + mergeNode.getQPath().getAsString()));
            }
        } else {
            log.warn((Object)("Has no parent for merge node " + mergeNode.getQPath().getAsString()));
        }
    }

    @Override
    protected void entering(PropertyData mergeProperty, int level) throws RepositoryException {
    }

    @Override
    protected void leaving(PropertyData mergeProperty, int level) throws RepositoryException {
    }

    @Override
    protected void leaving(NodeData mergeNode, int level) throws RepositoryException {
        ContextParent context;
        if (this.parents.size() > 0 && (context = this.parents.pop()).getResult() == UPDATE) {
            SessionDataManager mergeDataManager = this.mergeSession.getTransientNodesManager();
            for (NodeData corrNode : context.getCorrChildNodes()) {
                TransientNodeData existedSameIdentifier = (TransientNodeData)mergeDataManager.getItemData(corrNode.getIdentifier());
                if (existedSameIdentifier != null) {
                    RemoveVisitor remover = new RemoveVisitor();
                    existedSameIdentifier.accept(remover);
                    this.changes.addAll(remover.getRemovedStates());
                }
                ItemDataCopyVisitor copier = new ItemDataCopyVisitor(context.getParent(), corrNode.getQPath().getName(), this.mergeSession.getWorkspace().getNodeTypesHolder(), mergeDataManager, true);
                corrNode.accept(copier);
                this.changes.addAll(copier.getItemAddStates());
            }
        }
    }

    protected void doMerge(TransientNodeData mergeNode) throws RepositoryException {
        TransientNodeData corrNode = this.getCorrNodeData(mergeNode);
        if (corrNode != null) {
            TransientNodeData mergeVersion = this.getBaseVersionData(mergeNode, this.mergeSession);
            if (mergeVersion != null) {
                TransientNodeData corrVersion = this.getBaseVersionData(corrNode, this.corrSession);
                if (corrVersion != null) {
                    SessionDataManager mergeDataManager = this.mergeSession.getTransientNodesManager();
                    PropertyData isCheckedOutProperty = (PropertyData)mergeDataManager.getItemData((NodeData)mergeNode, new QPathEntry(Constants.JCR_ISCHECKEDOUT, 0));
                    try {
                        if (!Boolean.valueOf(new String(isCheckedOutProperty.getValues().get(0).getAsByteArray())).booleanValue() && this.isSuccessor(mergeVersion, corrVersion)) {
                            this.doUpdate(mergeNode, corrNode);
                        }
                        if (mergeVersion.getQPath().equals(corrVersion.getQPath()) || this.isPredecessor(mergeVersion, corrVersion)) {
                            this.doLeave(mergeNode);
                        }
                        this.doFail(mergeNode, corrVersion);
                    }
                    catch (IOException e) {
                        throw new RepositoryException("Merge. Get isCheckedOut error " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    this.doLeave(mergeNode);
                }
            } else {
                this.doUpdate(mergeNode, corrNode);
            }
        } else {
            this.doLeave(mergeNode);
        }
    }

    protected void doLeave(TransientNodeData mergeNode) throws RepositoryException {
        this.parents.push(new ContextParent((NodeData)mergeNode, LEAVE));
    }

    protected void doUpdate(TransientNodeData mergeNode, TransientNodeData corrNode) throws RepositoryException {
        PropertyData existed;
        TransientNodeData existedSameIdentifier;
        TransactionableDataManager mergeDataManager = this.mergeSession.getTransientNodesManager().getTransactManager();
        QPath mergePath = mergeNode.getQPath();
        TransientNodeData mergedNode = new TransientNodeData(mergePath, mergeNode.getIdentifier(), mergeNode.getPersistedVersion(), corrNode.getPrimaryTypeName(), corrNode.getMixinTypeNames(), mergeNode.getOrderNumber(), mergeNode.getParentIdentifier(), mergeNode.getACL());
        if (!mergeNode.getIdentifier().equals(corrNode.getIdentifier()) && (existedSameIdentifier = (TransientNodeData)mergeDataManager.getItemData(corrNode.getIdentifier())) != null) {
            RemoveVisitor remover = new RemoveVisitor();
            existedSameIdentifier.accept(remover);
            this.changes.addAll(remover.getRemovedStates());
        }
        this.changes.add(new ItemState(mergedNode, 2, true, mergeNode.getQPath(), true));
        TransactionableDataManager corrDataManager = this.corrSession.getTransientNodesManager().getTransactManager();
        List<PropertyData> corrChildProps = corrDataManager.getChildPropertiesData(corrNode);
        List<PropertyData> mergeChildProps = mergeDataManager.getChildPropertiesData(mergeNode);
        HashMap<InternalQName, PropertyData> existedProps = new HashMap<InternalQName, PropertyData>();
        for (PropertyData cp : mergeChildProps) {
            existed = ((TransientPropertyData)cp).clone();
            this.changes.add(new ItemState(existed, 4, true, mergedNode.getQPath(), true));
            existedProps.put(((TransientItemData)((Object)existed)).getQPath().getName(), existed);
        }
        for (PropertyData cp : corrChildProps) {
            existed = (PropertyData)existedProps.get((Object)cp.getQPath().getName());
            TransientPropertyData mcp = new TransientPropertyData(QPath.makeChildPath(mergePath, cp.getQPath().getName()), existed != null ? existed.getIdentifier() : cp.getIdentifier(), existed != null ? existed.getPersistedVersion() : cp.getPersistedVersion(), cp.getType(), mergedNode.getIdentifier(), cp.isMultiValued());
            mcp.setValues(cp.getValues());
            this.changes.add(new ItemState(mcp, 1, true, mergedNode.getQPath(), true));
        }
        List<NodeData> childNodes = corrDataManager.getChildNodesData(corrNode);
        this.parents.push(new ContextParent(mergedNode, childNodes, UPDATE));
    }

    protected void doFail(TransientNodeData mergeNode, TransientNodeData corrVersion) throws RepositoryException {
        if (!this.bestEffort) {
            throw new MergeException("Merging of node " + this.mergeSession.getLocationFactory().createJCRPath(mergeNode.getQPath()).getAsString(false) + " failed");
        }
        this.failed.put(mergeNode.getIdentifier(), corrVersion.getIdentifier());
        this.doLeave(mergeNode);
    }

    protected TransientNodeData getBaseVersionData(TransientNodeData node, SessionImpl session) throws RepositoryException {
        NodeTypeDataManager ntManager = session.getWorkspace().getNodeTypesHolder();
        if (ntManager.isNodeType(Constants.MIX_VERSIONABLE, node.getPrimaryTypeName(), node.getMixinTypeNames())) {
            SessionDataManager dmanager = session.getTransientNodesManager();
            PropertyData bvProperty = (PropertyData)dmanager.getItemData((NodeData)node, new QPathEntry(Constants.JCR_BASEVERSION, 0));
            try {
                return (TransientNodeData)dmanager.getItemData(new String(bvProperty.getValues().get(0).getAsByteArray()));
            }
            catch (IOException e) {
                throw new RepositoryException("Merge. Get base version error " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected TransientNodeData getCorrNodeData(TransientNodeData mergeNode) throws RepositoryException {
        QPath mergePath = mergeNode.getQPath();
        SessionDataManager corrDataManager = this.corrSession.getTransientNodesManager();
        SessionDataManager mergeDataManager = this.mergeSession.getTransientNodesManager();
        NodeTypeDataManager mergeNtManager = this.mergeSession.getWorkspace().getNodeTypesHolder();
        if (mergeNtManager.isNodeType(Constants.MIX_REFERENCEABLE, mergeNode.getPrimaryTypeName(), mergeNode.getMixinTypeNames())) {
            return (TransientNodeData)corrDataManager.getItemData(mergeNode.getIdentifier());
        }
        for (int i = 1; i <= mergePath.getDepth(); ++i) {
            NodeData corrAncestor;
            QPath ancesstorPath = mergePath.makeAncestorPath(i);
            NodeData mergeAncestor = (NodeData)mergeDataManager.getItemData(ancesstorPath);
            if (mergeAncestor == null || !mergeNtManager.isNodeType(Constants.MIX_REFERENCEABLE, mergeAncestor.getPrimaryTypeName(), mergeAncestor.getMixinTypeNames()) || (corrAncestor = (NodeData)corrDataManager.getItemData(mergeAncestor.getIdentifier())) == null) continue;
            QPathEntry[] relPathEntries = mergePath.getRelPath(mergePath.getDepth() - i);
            return (TransientNodeData)corrDataManager.getItemData(corrAncestor, relPathEntries);
        }
        return (TransientNodeData)corrDataManager.getItemData(mergePath);
    }

    protected boolean isPredecessor(TransientNodeData mergeVersion, TransientNodeData corrVersion) throws RepositoryException {
        SessionDataManager mergeDataManager = this.mergeSession.getTransientNodesManager();
        PropertyData predecessorsProperty = (PropertyData)mergeDataManager.getItemData((NodeData)mergeVersion, new QPathEntry(Constants.JCR_PREDECESSORS, 0));
        if (predecessorsProperty != null) {
            for (ValueData pv : predecessorsProperty.getValues()) {
                try {
                    String pidentifier = new String(pv.getAsByteArray());
                    if (pidentifier.equals(corrVersion.getIdentifier())) {
                        return true;
                    }
                    TransientNodeData predecessor = (TransientNodeData)mergeDataManager.getItemData(pidentifier);
                    if (predecessor != null) {
                        if (!this.isPredecessor(predecessor, corrVersion)) continue;
                        return true;
                    }
                    throw new RepositoryException("Merge. Predecessor is not found by uuid " + pidentifier + ". Version " + this.mergeSession.getLocationFactory().createJCRPath(mergeVersion.getQPath()).getAsString(false));
                }
                catch (IOException e) {
                    throw new RepositoryException("Merge. Get predecessors error " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    protected boolean isSuccessor(TransientNodeData mergeVersion, TransientNodeData corrVersion) throws RepositoryException {
        SessionDataManager mergeDataManager = this.mergeSession.getTransientNodesManager();
        PropertyData successorsProperty = (PropertyData)mergeDataManager.getItemData((NodeData)mergeVersion, new QPathEntry(Constants.JCR_SUCCESSORS, 0));
        if (successorsProperty != null) {
            for (ValueData sv : successorsProperty.getValues()) {
                try {
                    String sidentifier = new String(sv.getAsByteArray());
                    if (sidentifier.equals(corrVersion.getIdentifier())) {
                        return true;
                    }
                    TransientNodeData successor = (TransientNodeData)mergeDataManager.getItemData(sidentifier);
                    if (successor != null) {
                        if (!this.isSuccessor(successor, corrVersion)) continue;
                        return true;
                    }
                    throw new RepositoryException("Merge. Ssuccessor is not found by uuid " + sidentifier + ". Version " + this.mergeSession.getLocationFactory().createJCRPath(mergeVersion.getQPath()).getAsString(false));
                }
                catch (IOException e) {
                    throw new RepositoryException("Merge. Get successors error " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    public SessionChangesLog getMergeChanges() {
        return this.changes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VersionableStateComparator
    implements Comparator<VersionableState> {
        private VersionableStateComparator() {
        }

        @Override
        public int compare(VersionableState nc1, VersionableState nc2) {
            return nc1.getPath().compareTo(nc2.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContextParent {
        private final NodeData parent;
        private final List<NodeData> corrChildNodes;
        private final int result;

        private ContextParent(NodeData parent, List<NodeData> corrChildNodes, int result) {
            this.parent = parent;
            this.corrChildNodes = corrChildNodes;
            this.result = result;
        }

        private ContextParent(NodeData parent, int result) {
            this(parent, null, result);
        }

        public NodeData getParent() {
            return this.parent;
        }

        public List<NodeData> getCorrChildNodes() {
            return this.corrChildNodes;
        }

        public int getResult() {
            return this.result;
        }
    }

    protected class RemoveVisitor
    extends ItemDataRemoveVisitor {
        RemoveVisitor() throws RepositoryException {
            super(ItemDataMergeVisitor.this.mergeSession.getTransientNodesManager(), null, ItemDataMergeVisitor.this.mergeSession.getWorkspace().getNodeTypesHolder(), ItemDataMergeVisitor.this.mergeSession.getAccessManager(), ItemDataMergeVisitor.this.mergeSession.getUserState());
        }

        protected void validateReferential(NodeData node) throws RepositoryException {
        }
    }

    private class VersionableState {
        private final int result;
        private final QPath path;

        private VersionableState(QPath path, int result) {
            this.path = path;
            this.result = result;
        }

        public int getResult() {
            return this.result;
        }

        public QPath getPath() {
            return this.path;
        }
    }
}

